package clinical.test;

import java.io.IOException;
import java.util.Map;

import junit.framework.TestSuite;
import clinical.web.common.security.User;
import clinical.web.services.SimpleSecurityService;

/**
 * @author I. Burak Ozyurt
 * @version $Id: SimpleSecurityServiceTest.java 365 2011-05-05 20:04:18Z bozyurt $
 */
public class SimpleSecurityServiceTest extends MyTestCase {
	public SimpleSecurityServiceTest(String testName, String propsFile)
			throws IOException {
		super(testName, propsFile);
	}

	public void testUsersFileValidity() throws Exception {
		SimpleSecurityService sss = null;

		String usersFile = getProperty("mbirn.users_file");
		String usersSchema = getProperty("mbirn.users_schema");
		String dbID = getProperty("mbirn.dbid");

		sss = SimpleSecurityService.getInstance(usersFile, usersSchema);

		Map<String, User> users = sss.getAllUsers(dbID);
		assertTrue(users.keySet().size() >= 1);
		boolean foundAdminUser = false;
		for (String userName : users.keySet()) {
			if (userName.equals("admin"))
				foundAdminUser = true;
			System.out.println(userName);
		}
		assertTrue(foundAdminUser);
	}

	public static TestSuite suite() throws IOException {
		TestSuite suite = new TestSuite();
		suite.addTest(new SimpleSecurityServiceTest("testUsersFileValidity",
				"test.properties"));
		return suite;
	}

	public static void main(String[] args) throws IOException {
		junit.textui.TestRunner.run(suite());
	}

}
