package clinical.test;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.LinkedList;
import java.util.List;

import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.springframework.context.support.ClassPathXmlApplicationContext;

import clinical.utils.FileUtils;
import clinical.web.soap.QueryAtlasService;

/**
 * @author I. Burak Ozyurt
 * @version $Id: StatsSoapClientTest.java 365 2011-05-05 20:04:18Z bozyurt $
 */
public class StatsSoapClientTest extends TestCase {
	
	public StatsSoapClientTest(String testName) {
		super(testName);
	}

	protected static String[] loadPopIds(String filename) throws Exception {
		BufferedReader in = null;
		try {
			in = new BufferedReader(new FileReader(filename));
			String line = null;
			List<String> idList = new LinkedList<String>();
			while ((line = in.readLine()) != null) {
				idList.add(line);
			}
			String[] ids = new String[idList.size()];
			return idList.toArray(ids);
		} finally {
			FileUtils.close(in);
		}
	}

	public void testStats() {
		ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(
				new String[] { "ws_client_beans.xml" });
		String[] popSubjectIds = new String[] {"WRONG"};
		String subjectID = "";
		int expID = -1;
		QueryAtlasService qas = (QueryAtlasService) ctx
				.getBean("queryAtlasServiceClient");
		String result = qas.getDerivedDataStatsForSubject("b", "b", subjectID,
				expID, popSubjectIds);
		System.out.println(result);
	}

	public static TestSuite suite()  {
		TestSuite suite = new TestSuite();
		suite.addTest(new StatsSoapClientTest("testStats"));
		return suite;
	}

	public static void main(String[] args)  {
		junit.textui.TestRunner.run(suite());
	}

}
