package clinical.test.cbf;

import java.io.File;
import java.util.List;

import clinical.utils.CBFImageTypeDecider;
import clinical.web.services.CBFImageTypeLookupService;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class CBFImageTypeLookupServiceTests extends TestCase {
	CBFImageTypeLookupService service = null;

	public CBFImageTypeLookupServiceTests(String testName) {
		super(testName);
	}
	protected void setUp() throws Exception {
		String xmlLookupRulesFile = new File(System.getProperty("user.home"),
				"/dev/java/clinical/conf/series_type_rules.xml")
				.getCanonicalPath();
		service = CBFImageTypeLookupService.getInstance(xmlLookupRulesFile);
	}
	
	public void testMatch() {
		List<String> matchingGroups = service.getMatchingGroups("FSPGR_SAG_TI450", true);
		assertEquals(1, matchingGroups.size());
		assertEquals("Anatomical", matchingGroups.get(0));
		
		matchingGroups = service.getMatchingGroups("fspgr_SAG_TI450", false);
		assertEquals(1, matchingGroups.size());
		assertEquals("Anatomical", matchingGroups.get(0));
		
		matchingGroups = service.getMatchingGroups("ep2d_pasl_414_FBIRN", false);
		assertEquals(2, matchingGroups.size());
		
		CBFImageTypeDecider decider = new CBFImageTypeDecider(service);
		int fieldMapNo = decider.getFieldMapNo("fbirn_field_mapping", "fm1");
		assertEquals(CBFImageTypeDecider.FIELD_MAP1, fieldMapNo);
		
		
	}
	
	public static TestSuite suite() throws Exception {
		TestSuite suite = new TestSuite();
	    suite.addTest(new CBFImageTypeLookupServiceTests("testMatch"));
		return suite;
	}
	
	public static void main(String[] args) throws Exception {
		junit.textui.TestRunner.run(suite());
	}
}
