package clinical.test.cbf;

import java.util.List;

import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.json.JSONArray;

import clinical.utils.CSVParser;
import clinical.utils.FileUtils;
import clinical.utils.GenUtils;

public class CBFROIMiscTests extends TestCase {

	public CBFROIMiscTests(String testName) {
		super(testName);
	}

	public void testPrepFromAssociationResults() throws Exception {
		String jsonStr = FileUtils.loadTextFile("/tmp/test_roi_assoc.json");
		new JSONArray(jsonStr);
	}

	public void testCSVParser() throws Exception {
		CSVParser parser = new CSVParser();
		parser.extractData("/tmp/ROI_Summary.csv");
		List<List<String>> rows = parser.getRows();
		assertEquals(9, rows.size());
	}

	public void testCSVParser2() throws Exception {
		CSVParser parser = new CSVParser();
		parser.extractData("/home/bozyurt/download_cache/upload_4ga/caffeine_roi_masks_1342646255475_files/Masks/association.csv");
		List<List<String>> rows = parser.getRows();
		assertEquals(4, rows.size());
		int i = 0;
		for (List<String> row : rows) {
			System.out.println("Row " + i);
			assertEquals(3, row.size());
			i++;
		}
		for(List<String> row: rows) {
			String join = GenUtils.join(row, ",");
			System.out.println(join);
		}
	}

	public static TestSuite suite() {
		TestSuite suite = new TestSuite();
		// suite.addTest(new CBFROIMiscTests("testPrepFromAssociationResults"));
		suite.addTest(new CBFROIMiscTests("testCSVParser2"));
		return suite;
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(suite());
	}
}
