package clinical.test.cbf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import junit.framework.TestSuite;
import clinical.web.ServiceFactory;
import clinical.web.services.IBatchAssessmentService;
import clinical.web.vo.SubjectAsScoreValueSummary;

public class CBFRoiGroupAnalysisServiceTests extends BaseTestCase {

	public CBFRoiGroupAnalysisServiceTests(String testName) throws IOException {
		super(testName);
	}

	public void testPrepAssessmentCSVFile() throws Exception {
		IBatchAssessmentService bas = ServiceFactory
				.getBatchAssessmentService(csm.getDbID());
		List<String> expNames = new ArrayList<String>(1);
		expNames.add("Tom_EEG_Caffeine");
		Map<Integer, List<String>> expSubjectIDListMap = bas
				.prepExpSubjectIDListMap(csm.getUi(), expNames);

		List<SubjectAsScoreValueSummary> sasvsList = bas
				.getAllAssessmentValues(csm.getUi(), expSubjectIDListMap);
		File csvFile = new File("/tmp/Tom_EEG_Caffeine_assessments.csv");

		bas.prepareCSVFile(csm.getUi(), csvFile, sasvsList);
		System.out.println("saved CSV file:" + csvFile);
	}

	public void testPrepPhase3AssessmentCSVFile() throws Exception {
		IBatchAssessmentService bas = ServiceFactory
				.getBatchAssessmentService(csm.getDbID());
		List<String> expNames = new ArrayList<String>(7);
		String[] expNameArr = { "Phase3_ucsd", "Phase3_uci", "Phase3_duke",
				"Phase3_ucsf", "Phase3_mrn", "Phase3_uiowa", "Phase3_umn" };
		for (String expName : expNameArr) {
			expNames.add(expName);
		}

		Map<Integer, List<String>> expSubjectIDListMap = bas
				.prepExpSubjectIDListMap(csm.getUi(), expNames);

		List<SubjectAsScoreValueSummary> sasvsList = bas
				.getAllAssessmentValues(csm.getUi(), expSubjectIDListMap);
		File csvFile = new File("/tmp/Phase3_assessments.csv");

		bas.prepareCSVFile(csm.getUi(), csvFile, sasvsList);
		System.out.println("saved CSV file:" + csvFile);
	}

	public static TestSuite suite() throws Exception {
		TestSuite suite = new TestSuite();
	//	suite.addTest(new CBFRoiGroupAnalysisServiceTests(
	//			"testPrepAssessmentCSVFile"));
		suite.addTest(new CBFRoiGroupAnalysisServiceTests(
				"testPrepPhase3AssessmentCSVFile"));
		return suite;
	}

	public static void main(String[] args) throws Exception {
		junit.textui.TestRunner.run(suite());
	}
}
