package clinical.test.cbf;

import java.util.List;
import java.util.Map;

import junit.framework.TestSuite;

import org.json.JSONObject;

import clinical.cache.CacheUtils;
import clinical.utils.ThreadPoolMan;
import clinical.web.ServiceFactory;
import clinical.web.common.IAuthorizationService.PrivilegeLabel;
import clinical.web.common.query.CBFQueryAggregator;
import clinical.web.services.ICBFSearchService;
import clinical.web.vo.AssessmentQueryInfo;
import clinical.web.vo.CBFQueryMetaData;
import clinical.web.vo.CBFQueryResultSummary;
import clinical.web.vo.JobProvenanceQueryInfo;

public class QueryAggregatorTests extends BaseTestCase {

	public QueryAggregatorTests(String testName) {
		super(testName);
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		ThreadPoolMan.create(3);
	}

	@Override
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testCBFSearchService1() throws Exception {
		ICBFSearchService ss = ServiceFactory
				.getCBFSearchService(csm.getDbID());

		Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
		String primarySiteID = dbID2SiteIDMap.get(csm.getDbID());

		CBFQueryMetaData metaData = ss.getMetadataQuery(csm.getUi(),
				primarySiteID, PrivilegeLabel.READ);

		JSONObject json = metaData.toJSON();

		System.out.println(json.toString(2));
	}

	@SuppressWarnings("unused")
	public void testProvQuery() throws Exception {
		String queryJS = "{asQPIList:[],jobProvQPIList:[{ prov: {name:'automated', value:''},"
				+ "provType:'BOOL',connector:'AND',partIdx:0,operator:1, rhs:'yes'},"
				+ "{ prov: {name:'fieldmap', value:''},provType:'BOOL',connector:'AND',partIdx:1,operator:1, rhs:'no'},"
				+ "{ prov: {name:'Finish Date', value:''},provType:'DATE',connector:'NONE',partIdx:2,operator:6,rhs:'01/01/2012'}],"
				+ "jobResultQPIList:[]}";
		
		
		String queryJS2 = "{asQPIList:[],jobProvQPIList:["
				+ "{ prov: {name:'fieldmap', value:''},provType:'BOOL',connector:'AND',partIdx:1,operator:1, rhs:'no'}],"
				+ "jobResultQPIList:[]}";

		String queryJS3 = "{asQPIList:[],jobProvQPIList:["
				+ "{ prov: {name:'Finish Date', value:''},provType:'DATE',connector:'NONE',partIdx:2,operator:6,rhs:'01/01/2012'}],"
				+ "jobResultQPIList:[]}";

		JSONObject js = new JSONObject(queryJS);
		JobProvenanceQueryInfo jpqi = JobProvenanceQueryInfo
				.initializeFromJSON(js);

		System.out.println(jpqi);

		CBFQueryAggregator qa = new CBFQueryAggregator(csm.getDbID(),
				csm.getUi(), null);

		List<CBFQueryResultSummary> qsList = qa.handleQuery(null, jpqi, null,
				null);
		// show output
		for (CBFQueryResultSummary qs : qsList) {
			System.out.println(qs);
		}
	}

	public void testClinicalAndProvQuery() throws Exception {
		String queryJS = "{asQPIList:["
				+ "{ asi: { name:'Subject Information', asId:1218},score:{ name:'age',type:'integer'}, connector:'AND',partIdx:0,operator:2,rhs:'15'}],"
				+ "jobProvQPIList:[{ prov: {name:'automated', value:''},provType:'BOOL',connector:'AND',partIdx:1,operator:1, rhs:'yes'},"
				+ "{ prov: {name:'gmThresh', value:''},provType:'REAL',connector:'NONE',partIdx:2,operator:2,rhs:'0.7'}],"
				+ "jobResultQPIList:[]}";
		JSONObject js = new JSONObject(queryJS);
		JobProvenanceQueryInfo jpqi = null;
		Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
		String primarySiteID = dbID2SiteIDMap.get(csm.getDbID());
		AssessmentQueryInfo aqi = null;
		if (js.has("asQPIList")) {
			aqi = AssessmentQueryInfo.initializeFromJSON(js);
		}

		if (js.has("jobProvQPIList")) {
			jpqi = JobProvenanceQueryInfo.initializeFromJSON(js);
		}
		// aqi = null;

		CBFQueryAggregator qa = new CBFQueryAggregator(csm.getDbID(),
				csm.getUi(), null);

		List<CBFQueryResultSummary> qsList = qa.handleQuery(aqi, jpqi, null,
				primarySiteID);
		// show output
		for (CBFQueryResultSummary qs : qsList) {
			System.out.println(qs);
		}
		System.out.println("# of results:" + qsList.size());
	}
	
	

	public static TestSuite suite() throws Exception {
		TestSuite suite = new TestSuite();
		// suite.addTest( new QueryAggregatorTests("testProvQuery"));

		suite.addTest(new QueryAggregatorTests("testClinicalAndProvQuery"));

		// suite.addTest( new QueryAggregatorTests("testCBFSearchService1"));
		return suite;
	}

	public static void main(String[] args) throws Exception {
		junit.textui.TestRunner.run(suite());
	}
}
