package clinical.test.cbf;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import clinical.utils.Assertion;
import clinical.utils.Executor;
import clinical.utils.FileUtils;
import clinical.web.workflow.cbf.CBFException;
import clinical.web.workflow.cbf.SiemensCBFProcJobHelper.NIFTIAndBrikFiles;
import clinical.web.workflow.cbf.SiemensCBFProcJobHelper.NIFTIFile;
import clinical.web.workflow.cbf.SiemensCBFProcJobHelper.NIFTIWrapper;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class SiemensProcScriptExecTests extends TestCase {
	private String envPath = "/usr/local/bin:/bin:/usr/bin:/data/apps/fsl/bin:/data/apps/afni/bin:.";
	private Map<String, String> envMap = new HashMap<String, String>(7);

	public SiemensProcScriptExecTests(String testName) {
		super(testName);
	}

	public static TestSuite suite() throws Exception {
		TestSuite suite = new TestSuite();
		suite.addTest(new SiemensProcScriptExecTests("testDoB0Mosaic"));
	//	suite.addTest(new SiemensProcScriptExecTests(
	//			"testDoSiemensFieldMapCorrection"));
		return suite;
	}

	public void testDoB0Mosaic() throws Exception {
		String visitDir = "/data/bozyurt/fbirn/preprocess/ECTS/001802407836/scanVisit__0018__0002/MRI__0001";
		String aslNifti = visitDir + "/ASL_BRIKS/asl1.nii";
		Executor executor = new Executor("/home/bozyurt/bin/do_B0_mosaic.pl",
				true);
		executor.setErrorStreamReliable(false);
		StringBuilder sb = new StringBuilder(256);
		sb.append("--visit ").append(visitDir);
		sb.append(" --asl ").append(aslNifti);
		String argsStr = sb.toString();
		System.out.println("cmdLine:" + argsStr);
		runProcess(executor, argsStr);
	}

	public void testDoSiemensFieldMapCorrection() throws Exception {
		File destDir = new File("/home/bozyurt/etc/ects_siemens_test");
		File workDir = new File("/home/bozyurt/etc/ects_siemens_test/fm_dest");
		File magnitudeDir = new File(
				"/home/bozyurt/etc/ects_siemens_test/001802407836/Visit_07_28_2007_0018/B0_mag1");
		File phaseDir = new File(
				"/home/bozyurt/etc/ects_siemens_test/001802407836/Visit_07_28_2007_0018/B0_phase1");
		NIFTIFile nifti = new NIFTIFile(new File(
				"/home/bozyurt/etc/ects_siemens_test/dest/asl1.nii"));
		NIFTIWrapper nw = new NIFTIWrapper(nifti, null);

		boolean forcePrep = false;
		doFieldMapCorrection(destDir, workDir, nw, magnitudeDir, phaseDir,
				forcePrep);
	}

	public NIFTIAndBrikFiles doFieldMapCorrection(File destDir, File workDir,
			NIFTIWrapper series2Correct, File magnitudeDir, File phaseDir,
			boolean forcePrep) throws CBFException {
		Executor executor = new Executor(
				"/usr/local/bin/do_B0_mosaic_cbfbirn.pl");
		executor.addEnvParam("PATH", this.envPath);
		executor.addEnvParam("FSLDIR", "/data/apps/fsl");
		executor.addEnvParam("FSLOUTPUTTYPE", "ANALYZE");
		executor.addEnvParam("AFNI_PLUGINPATH", "/data/apps/afni/bin");
		executor.addEnvParam("FSLMULTIFILEQUIT", "TRUE");
		executor.addEnvParam("FSLCONFDIR", "/data/apps/fsl/bin/config");
		executor.addEnvParam("FSLMACHTYPE", "x86_64-redhat-linux-gcc4.1.2");
		for (String ev : this.envMap.keySet()) {
			String value = envMap.get(ev);
			executor.addEnvParam(ev, value);
		}
		executor.showOutput(true);
		executor.setErrorStreamReliable(false);
		StringBuilder sb = new StringBuilder(256);
		try {
			NIFTIAndBrikFiles nbFiles = new NIFTIAndBrikFiles();
			sb.append("--dest ").append(workDir.getCanonicalPath());
			sb.append(" --mag ").append(magnitudeDir.getCanonicalPath());
			sb.append(" --phase ").append(phaseDir.getCanonicalPath());
			sb.append(" --asl  ")
					.append(
							series2Correct.getNifti().getNiftiFile()
									.getCanonicalPath());
			if (forcePrep) {
				sb.append(" --force-prep");
			}

			System.out.println("running  do_B0_mosaic_cbfbirn.pl "
					+ sb.toString());
			executor.execute(sb.toString());

			String aslSeriesName = clinical.utils.FileUtils
					.getBasename(series2Correct.getNifti().getNiftiFile()
							.getName());
			File b0CorrectedDir = new File(workDir, "B0_corrected");
			Assertion.assertTrue(b0CorrectedDir.isDirectory());
			File[] files = b0CorrectedDir.listFiles();
			for (File f : files) {
				String name = f.getName();
				if (f.isFile() && name.startsWith(aslSeriesName)) {
					if (FileUtils.isAFNIBrick(name)
							|| FileUtils.isAFNIHeader(name)) {
						File destFile = new File(destDir, f.getName());
						if (!clinical.utils.FileUtils.moveTo(f, destFile)) {
							throw new Exception("Cannot move file:"
									+ f.getName());
						}

					} else if (FileUtils.isNiftiFile(name)) {
						File destFile = new File(destDir, name);
						if (!clinical.utils.FileUtils.moveTo(f, destFile)) {
							throw new Exception("Cannot move file:"
									+ f.getName());
						}
						nbFiles.addNIFTI(new NIFTIFile(destFile));
					}
				}
			} // for
			// return B0 corrected AFNI BRIK and NIFTI file info (all moved to
			// their final destinations)
			return nbFiles;

		} catch (Exception ex) {
			ex.printStackTrace();
			throw new CBFException(ex);
		}
	}

	protected void runProcess(Executor executor, String cmdLine)
			throws Exception {
		executor.addEnvParam("PATH", this.envPath);
		for (String ev : this.envMap.keySet()) {
			String value = envMap.get(ev);
			executor.addEnvParam(ev, value);
		}
		executor.showOutput(true);
		executor.execute(cmdLine);

		// String output = executor.getOutput();
		// System.out.println(output);
	}

	public static void main(String[] args) throws Exception {
		junit.textui.TestRunner.run(suite());
	}
}
