package clinical.tools.dbadmin;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import clinical.utils.CSVParser;
import clinical.utils.FileUtils;
import clinical.web.ConnectionSupportMixin;
import clinical.web.ServiceFactory;
import clinical.web.services.IBIRNIDGenerationService;
import clinical.web.services.SecurityService;

public class BIRNIDMappingAdmin extends AbstractAdmin {

	public BIRNIDMappingAdmin(String usersXmlFile) throws Exception {
		csm = new ConnectionSupportMixin(usersXmlFile);
		csm.startup();

		SecurityService ss = SecurityService.getInstance(
				csm.getDbPoolService(), csm.getDbID(), csm.getDbType());
		ss.startup();
	}

	public void prepLocalID2BIRNIDLookupTable(String csvFile,
			String local2BIRNIDFile) throws Exception {
		CSVParser parser = new CSVParser();
		parser.extractData(csvFile);
		List<List<String>> rows = parser.getRows();

		SecurityService ss = (SecurityService) ServiceFactory
				.getSecurityService();
		String siteID = ss.getSiteID(csm.getDbID());

		IBIRNIDGenerationService big = ServiceFactory
				.getBIRNIDGenerationService(csm.getDbID());
		Set<String> seenSet = new HashSet<String>();
		int len = rows.size();
		List<String> lines = new ArrayList<String>();
		for (int i = 1; i < len; i++) {
			List<String> row = rows.get(i);
			if (row.isEmpty() || row.get(0).length() == 0) {
				break;
			}
			String localID = row.get(0);
			String BIRNID = big.createBIRNID(siteID);
			while (seenSet.contains(BIRNID)) {
				BIRNID = big.createBIRNID(siteID);
			}
			lines.add(localID + "," + BIRNID);
			seenSet.add(BIRNID);
		}

		BufferedWriter out = null;
		try {
			out = new BufferedWriter(new FileWriter(local2BIRNIDFile));
			for (Iterator<String> it = lines.iterator(); it.hasNext();) {
				String line = it.next();
				out.write(line);
				if (it.hasNext())
					out.newLine();
			}
		} finally {
			FileUtils.close(out);
		}
		System.out.println("wrote lookup table to:" + local2BIRNIDFile);
	}

	public static void main(String[] args) throws Exception {
		BIRNIDMappingAdmin admin = null;
		try {
			admin = new BIRNIDMappingAdmin("users.xml");
			// admin.prepLocalID2BIRNIDLookupTable("/tmp/TMARC_T03.csv",
			// "/tmp/tmarc_birnid_map.csv");
			String rootDir = "/home/bozyurt/dev/java/clinical/scripts/ucla_peds_project";
			// admin.prepLocalID2BIRNIDLookupTable(rootDir + "/localid1.csv",
			// rootDir + "/birnid_map1.csv");

			rootDir = "/home/bozyurt/dev/java/clinical/scripts/TMARC2_project";
			admin.prepLocalID2BIRNIDLookupTable(rootDir
					+ "/tmarc_local_ids.csv", rootDir + "/tmarc_birnid_map.csv");
		} finally {
			if (admin != null) {
				admin.shutdown();
			}
		}
	}
}
