package clinical.tools.dbadmin;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.jdom.Element;

import clinical.server.dao.ExperimentDAO;
import clinical.server.dao.ResearchgroupDAO;
import clinical.server.dao.ResearchgrouptypeDAO;
import clinical.server.vo.Databaseuser;
import clinical.server.vo.Experiment;
import clinical.server.vo.Researchgroup;
import clinical.server.vo.Researchgrouptype;
import clinical.utils.Assertion;
import clinical.utils.FileUtils;
import clinical.utils.GenUtils;
import clinical.web.ConnectionSupportMixin;
import clinical.web.Constants;
import clinical.web.DAOFactory;
import clinical.web.DBUtils;
import clinical.web.ISequenceHelper;
import clinical.web.MinimalServiceFactory;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class ResearchGroupAdmin extends AbstractAdmin {
	Map<String, List<RGRec>> exp2RgListMap = new HashMap<String, List<RGRec>>(
			11);

	public ResearchGroupAdmin(String xmlFile, String usersXmlFile)
			throws Exception {
		super();
		Element rootEl = FileUtils.loadXML(xmlFile);
		List<?> expChildren = rootEl.getChildren("exp");
		for (Object o : expChildren) {
			Element ec = (Element) o;
			String expName = ec.getAttributeValue("name");
			List<RGRec> list = exp2RgListMap.get(expName);
			if (list == null) {
				list = new ArrayList<RGRec>(2);
				exp2RgListMap.put(expName, list);
			}
			List<?> children = ec.getChildren("pg");
			for (Object ob : children) {
				Element pe = (Element) ob;
				list.add(RGRec.fromXml(pe));
			}
		}

		csm = new ConnectionSupportMixin(usersXmlFile);
		csm.startup();
		MinimalServiceFactory.setMimimalOpMode(true);
	}

	public void save() throws Exception {
		Connection con = null;
		try {
			con = csm.getConnection();
			con.setAutoCommit(false);
			ExperimentDAO expDAO = DAOFactory
					.createExperimentDAO(csm.getDbID());
			List<Experiment> expList = expDAO.find(con, new Experiment());
			Map<String, Experiment> expMap = new HashMap<String, Experiment>(17);
			for (Experiment exp : expList) {
				expMap.put(exp.getName(), exp);
			}
			ResearchgrouptypeDAO rgtDAO = DAOFactory
					.createResearchgrouptypeDAO(csm.getDbID());
			Map<String, Researchgrouptype> rgtMap = new HashMap<String, Researchgrouptype>(
					7);
			List<Researchgrouptype> rgtList = rgtDAO.find(con,
					new Researchgrouptype());
			for (Researchgrouptype rgt : rgtList) {
				rgtMap.put(rgt.getName(), rgt);
			}

			Map<String, Map<String, Researchgroup>> exp2RgMap = getExpRgs(con);
			for (String expName : exp2RgListMap.keySet()) {
				List<RGRec> rgList = exp2RgListMap.get(expName);
				Map<String, Researchgroup> rgMap = exp2RgMap.get(expName);
				System.out.println("ExpName:" + expName);
				Experiment exp = expMap.get(expName);
				for (RGRec rg : rgList) {
				    if (rgMap == null) {
				    	System.out.println("Inserting " + rg);
				    	insert(con, rg, exp, rgtMap);
				    } else {
				    	Researchgroup researchgroup = rgMap.get(rg.name);
				    	if (researchgroup == null) {
				    		System.out.println("Inserting " + rg);					    	
				    		insert(con, rg, exp, rgtMap);
				    	} else {
				    		System.out.println("Updating " + rg);
				    		update(con,rg, researchgroup);
				    	}
				    }
				}
			}

			con.commit();
		} catch (Exception x) {
			con.rollback();
			x.printStackTrace();
		} finally {
			csm.releaseConnection(con);
		}

	}

	public void insert(Connection con, RGRec rg, Experiment exp,
			Map<String, Researchgrouptype> rgtMap) throws Exception {
		ResearchgroupDAO rgDAO = DAOFactory.createResearchgroupDAO(csm
				.getDbID());
		Researchgrouptype rgt = rgtMap.get(rg.type);
		Assertion.assertNotNull(rgt);
		Researchgroup bean = new Researchgroup();
		bean.setName(rg.name);
		bean.setDescription(rg.description);
		bean.setNcResearchgrouptypeUniqueid(rgt.getUniqueid());
		bean.setNcExperimentUniqueid(exp.getUniqueid());
		bean.setModtime(new Date());

		Databaseuser adminDU = getDatabaseUser(csm.getUi(),
				Constants.USERCLASS_ADMIN);
		bean.setOwner(adminDU.getUniqueid());
		bean.setModuser(adminDU.getUniqueid());
		ISequenceHelper sequenceHelper = MinimalServiceFactory
				.getSequenceHelper(csm.getDbID());
		BigDecimal uniqueid = sequenceHelper.getNextUID(con,
				Constants.RESEARCHGROUP_DB_TABLE, "uniqueid");
		bean.setUniqueid(uniqueid);
		int tableID = DBUtils.getTableID(csm.getDbID(), con,
				Constants.RESEARCHGROUP_DB_TABLE);

		bean.setTableid(GenUtils.toBigDecimal(tableID));
		rgDAO.insert(con, bean);
	}

	public void update(Connection con, RGRec rg, Researchgroup oldRg)
			throws Exception {
		Researchgroup cr = new Researchgroup();
		cr.setUniqueid(oldRg.getUniqueid());
		Researchgroup updateBean = new Researchgroup();
		boolean needsUpdate = false;
		if (rg.name != null && !rg.name.equals(oldRg.getName())) {
			needsUpdate = true;
			updateBean.setName(rg.name);
		}
		if (rg.description != null) {
			needsUpdate = true;
			updateBean.setDescription(rg.description);
		}
		if (needsUpdate) {
			ResearchgroupDAO rgDAO = DAOFactory.createResearchgroupDAO(csm
					.getDbID());
			rgDAO.update(con, updateBean, cr);
		}
	}

	public Map<String, Map<String, Researchgroup>> getExpRgs(Connection con)
			throws Exception {
		Map<String, Map<String, Researchgroup>> exp2RgMap = new HashMap<String, Map<String, Researchgroup>>();
		ExperimentDAO expDAO = DAOFactory.createExperimentDAO(csm.getDbID());
		ResearchgroupDAO rgDAO = DAOFactory.createResearchgroupDAO(csm
				.getDbID());

		List<Experiment> expList = expDAO.find(con, new Experiment());
		List<Researchgroup> rgList = rgDAO.find(con, new Researchgroup());
		Map<BigDecimal, Experiment> expMap = new HashMap<BigDecimal, Experiment>(
				17);
		for (Experiment exp : expList) {
			expMap.put(exp.getUniqueid(), exp);
		}
		for (Researchgroup rg : rgList) {
			Experiment exp = expMap.get(rg.getNcExperimentUniqueid());
			Assertion.assertNotNull(exp);
			Map<String, Researchgroup> rgMap = exp2RgMap.get(exp.getName());
			if (rgMap == null) {
				rgMap = new HashMap<String, Researchgroup>(7);
				exp2RgMap.put(exp.getName(), rgMap);
			}
			rgMap.put(rg.getName(), rg);

		}

		return exp2RgMap;
	}

	public static class RGRec {
		String uniqueid;
		String name;
		String description;
		String type;

		public RGRec() {
		}

		public Element toXml() {
			Element el = new Element("rg");
			el.setAttribute("uniqueid", uniqueid);
			el.setAttribute("type", type);
			if (description != null) {
				Element de = new Element("description");
				de.addContent(description);
				el.addContent(de);
			}
			return el;
		}

		public static RGRec fromXml(Element el) {
			RGRec rg = new RGRec();
			rg.uniqueid = el.getAttributeValue("uniqueid");
			rg.name = el.getAttributeValue("name");
			rg.type = el.getAttributeValue("type");
			if (el.getChild("description") != null) {
				rg.description = el.getChildTextTrim("description");
			}
			return rg;
		}

		@Override
		public String toString() {
			StringBuilder sb = new StringBuilder();
			sb.append("RGRec::[");
			sb.append("name:").append(name);
			sb.append(",type:").append(type);
			sb.append(",uniqueid:").append(uniqueid);
			sb.append(']');
			return sb.toString();
		}
	}
	
	public static void usage() {
		System.err.println("Usage:ResearchGroupAdmin <protocol-xml-file>\n");
		System.exit(1);
	}

	public static void main(String[] args) throws Exception {
		if (args.length != 1) {
			usage();
		}
		String rgXml = args[0];
		if (!new File(rgXml).isFile()) {
			System.err.println("Not a file:" + rgXml);
			usage();
		}
		ResearchGroupAdmin rga = null;
		try {
			rga = new ResearchGroupAdmin(rgXml, "users.xml");
			
			rga.save();
		} finally {
			if (rga != null) {
				rga.shutdown();
			}
		}
	}
}
