package clinical.tools.dbadmin;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.jdom.Element;

import clinical.server.dao.CollectionequipmentDAO;
import clinical.server.vo.Collectionequipment;
import clinical.server.vo.Databaseuser;
import clinical.utils.FileUtils;
import clinical.utils.GenUtils;
import clinical.web.ConnectionSupportMixin;
import clinical.web.Constants;
import clinical.web.DAOFactory;
import clinical.web.DBUtils;
import clinical.web.ISequenceHelper;
import clinical.web.MinimalServiceFactory;

public class ScannerAdmin extends AbstractAdmin {
    List<ScannerRec> srList = new ArrayList<ScannerRec>();
    
    public ScannerAdmin(String xmlFile, String usersXmlFile) throws Exception {
    	super();
    	Element rootEl = FileUtils.loadXML(xmlFile);
		List<?> children = rootEl.getChildren("scanner");
		for (Object o : children) {
			Element ce = (Element) o;
			srList.add(ScannerRec.fromXml(ce));
		}
		csm = new ConnectionSupportMixin(usersXmlFile);
		csm.startup();
		MinimalServiceFactory.setMimimalOpMode(true);
	}
    
    public void save() throws Exception {
    	Connection con = null;
		try {
			con = csm.getConnection();
			con.setAutoCommit(false);
			
			Map<String, Collectionequipment> ceMap = getCEMap(con);
			
			for(ScannerRec sr : srList) {
				String key = sr.make + ":" + sr.model;
				Collectionequipment ce = ceMap.get(key);
				if (ce == null) {
					System.out.println("inserting " + sr);
					insert(con,sr);
				}
			}
			con.commit();
		} catch (Exception x) {
			con.rollback();
			x.printStackTrace();
		} finally {
			csm.releaseConnection(con);
		}
    }
    
    
    public Map<String, Collectionequipment> getCEMap(Connection con) throws Exception {
    	CollectionequipmentDAO dao = DAOFactory.createCollectionequipmentDAO(csm.getDbID());
    	List<Collectionequipment> ceList = dao.find(con, new Collectionequipment());
    	Map<String,Collectionequipment> ceMap = new HashMap<String, Collectionequipment>();
    	for(Collectionequipment ce : ceList) {
    		String key = ce.getMake() + ":" + ce.getModel();
    		ceMap.put(key, ce);
    	}
    	return ceMap;
    }
    
    
	public void insert(Connection con, ScannerRec sr) throws Exception {
		CollectionequipmentDAO dao = DAOFactory
				.createCollectionequipmentDAO(csm.getDbID());
		Collectionequipment ce = new Collectionequipment();
		ce.setMake(sr.make);
		ce.setModel(sr.model);
		ce.setModtime(new Date());
		Databaseuser adminDU = getDatabaseUser(csm.getUi(),
				Constants.USERCLASS_ADMIN);
		ce.setOwner(adminDU.getUniqueid());
		ce.setModuser(adminDU.getUniqueid());
		ISequenceHelper sequenceHelper = MinimalServiceFactory
				.getSequenceHelper(csm.getDbID());
		BigDecimal uniqueid = sequenceHelper.getNextUID(con,
				Constants.COLLECTION_EQUIPMENT_TABLE, "uniqueid");
		ce.setUniqueid(uniqueid);
		int tableID = DBUtils.getTableID(csm.getDbID(), con,
				Constants.COLLECTION_EQUIPMENT_TABLE);
		ce.setTableid(GenUtils.toBigDecimal(tableID));
		
		dao.insert(con, ce);

	}
   
	public static class ScannerRec {
		String make;
		String model;
		
		public ScannerRec() {
		}
		
		public Element toXml() {
			Element el = new Element("scanner");
			el.setAttribute("make",make);
			el.setAttribute("model",model);
			return el;
		}
		
		public static ScannerRec fromXml(Element el) {
			ScannerRec sr = new ScannerRec();
			sr.make = el.getAttributeValue("make");
			sr.model = el.getAttributeValue("model");
			return sr;
		}
		
		public String toString() {
			StringBuilder sb = new StringBuilder();
			sb.append("ScannerRec::[");
			   sb.append("make:").append(make);
			   sb.append(",model:").append(model);
			sb.append("]");
			return sb.toString();
		}
	}
	
	public static void usage() {
		System.err.println("Usage:ScannerAdmin <scanner-xml-file>\n");
		System.exit(1);
	}
	
	public static void main(String[] args) throws Exception {
		if (args.length != 1) {
			usage();
		}
		String scannerXml = args[0];
		if (!new File(scannerXml).isFile()) {
			System.err.println("Not a file:" + scannerXml);
			usage();
		}
		ScannerAdmin sa = null;
		try {
			sa = new ScannerAdmin(scannerXml, "users.xml");
			
			sa.save();
		} finally {
			if (sa != null) {
				sa.shutdown();
			}
		}
	}
}
