package clinical.tools.dbadmin.migration;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.jdom.Element;

import clinical.server.dao.AssessmentDAO;
import clinical.server.dao.AssessmentfloatDAO;
import clinical.server.dao.AssessmentintegerDAO;
import clinical.server.dao.AssessmentscoreDAO;
import clinical.server.dao.AssessmenttimestampDAO;
import clinical.server.dao.AssessmentvarcharDAO;
import clinical.server.dao.CollectionequipmentDAO;
import clinical.server.dao.DataobjectDAO;
import clinical.server.dao.DataobjecttypeDAO;
import clinical.server.dao.DeriveddataDAO;
import clinical.server.dao.ExpcomponentDAO;
import clinical.server.dao.ExperimentDAO;
import clinical.server.dao.ExpsegmentDAO;
import clinical.server.dao.HumansubjectDAO;
import clinical.server.dao.JobProvParamTypeDAO;
import clinical.server.dao.JobProvenanceDAO;
import clinical.server.dao.JobProvenanceParamDAO;
import clinical.server.dao.JobsDAO;
import clinical.server.dao.PersonDAO;
import clinical.server.dao.RawdataDAO;
import clinical.server.dao.ResearchgroupDAO;
import clinical.server.dao.StoredassessmentDAO;
import clinical.server.dao.SubjexperimentDAO;
import clinical.server.dao.VisitJobDAO;
import clinical.server.vo.Assessment;
import clinical.server.vo.Assessmentfloat;
import clinical.server.vo.Assessmentinteger;
import clinical.server.vo.Assessmentscore;
import clinical.server.vo.Assessmenttimestamp;
import clinical.server.vo.Assessmentvarchar;
import clinical.server.vo.Collectionequipment;
import clinical.server.vo.Dataobject;
import clinical.server.vo.Dataobjecttype;
import clinical.server.vo.Deriveddata;
import clinical.server.vo.Expcomponent;
import clinical.server.vo.Experiment;
import clinical.server.vo.Expsegment;
import clinical.server.vo.Humansubject;
import clinical.server.vo.JobProvParamType;
import clinical.server.vo.JobProvenance;
import clinical.server.vo.JobProvenanceParam;
import clinical.server.vo.Jobs;
import clinical.server.vo.Person;
import clinical.server.vo.Rawdata;
import clinical.server.vo.Researchgroup;
import clinical.server.vo.Storedassessment;
import clinical.server.vo.Subjexperiment;
import clinical.server.vo.VisitJob;
import clinical.tools.dbadmin.migration.VOMigrationManager.VOXMLPersister;
import clinical.utils.Assertion;
import clinical.utils.FileUtils;
import clinical.web.ConnectionSupportMixin;
import clinical.web.DAOFactory;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class SourceExtractor {
	private String migrationXmlFile;
	VOMigrationManager migMan;
	private ConnectionSupportMixin csm;

	public SourceExtractor(String migrationXmlFile, ConnectionSupportMixin csm)
			throws Exception {
		this.csm = csm;
		this.migrationXmlFile = migrationXmlFile;
		migMan = VOMigrationManager.getInstance();

		VOXMLPersister<Collectionequipment> cePersister = new VOXMLPersister<Collectionequipment>(
				Collectionequipment.class);
		migMan.register(cePersister);
		VOXMLPersister<Experiment> expPersister = new VOXMLPersister<Experiment>(
				Experiment.class);
		migMan.register(expPersister);
		VOXMLPersister<Humansubject> subjPersister = new VOXMLPersister<Humansubject>(
				Humansubject.class);
		migMan.register(subjPersister);
		VOXMLPersister<Subjexperiment> sePersister = new VOXMLPersister<Subjexperiment>(
				Subjexperiment.class);
		migMan.register(sePersister);

		VOXMLPersister<Researchgroup> rgPersister = new VOXMLPersister<Researchgroup>(
				Researchgroup.class);
		migMan.register(rgPersister);

		VOXMLPersister<Expcomponent> visitPersister = new VOXMLPersister<Expcomponent>(
				Expcomponent.class);
		migMan.register(visitPersister);
		VOXMLPersister<Expsegment> segPersister = new VOXMLPersister<Expsegment>(
				Expsegment.class);
		migMan.register(segPersister);
		VOXMLPersister<Assessment> asPersister = new VOXMLPersister<Assessment>(
				Assessment.class);
		migMan.register(asPersister);
		VOXMLPersister<Assessmentscore> scorePersister = new VOXMLPersister<Assessmentscore>(
				Assessmentscore.class);
		migMan.register(scorePersister);
		VOXMLPersister<Assessmentinteger> aiPersister = new VOXMLPersister<Assessmentinteger>(
				Assessmentinteger.class);
		migMan.register(aiPersister);
		VOXMLPersister<Assessmentfloat> afPersister = new VOXMLPersister<Assessmentfloat>(
				Assessmentfloat.class);
		migMan.register(afPersister);
		VOXMLPersister<Assessmentvarchar> avPersister = new VOXMLPersister<Assessmentvarchar>(
				Assessmentvarchar.class);
		migMan.register(avPersister);
		VOXMLPersister<Assessmenttimestamp> atPersister = new VOXMLPersister<Assessmenttimestamp>(
				Assessmenttimestamp.class);
		migMan.register(atPersister);
		VOXMLPersister<Storedassessment> saPersister = new VOXMLPersister<Storedassessment>(
				Storedassessment.class);
		migMan.register(saPersister);

		VOXMLPersister<Jobs> jobsPersister = new VOXMLPersister<Jobs>(
				Jobs.class);
		migMan.register(jobsPersister);
		VOXMLPersister<VisitJob> vjPersister = new VOXMLPersister<VisitJob>(
				VisitJob.class);
		migMan.register(vjPersister);

		VOXMLPersister<JobProvenance> jpPersister = new VOXMLPersister<JobProvenance>(
				JobProvenance.class);
		migMan.register(jpPersister);

		VOXMLPersister<JobProvenanceParam> jppPersister = new VOXMLPersister<JobProvenanceParam>(
				JobProvenanceParam.class);
		migMan.register(jppPersister);

		VOXMLPersister<JobProvParamType> jpptPersister = new VOXMLPersister<JobProvParamType>(
				JobProvParamType.class);
		migMan.register(jpptPersister);

		VOXMLPersister<Rawdata> rdPersister = new VOXMLPersister<Rawdata>(
				clinical.server.vo.Rawdata.class);
		migMan.register(rdPersister);
		VOXMLPersister<Deriveddata> ddPersister = new VOXMLPersister<Deriveddata>(
				Deriveddata.class);
		migMan.register(ddPersister);

		VOXMLPersister<Person> personPersister = new VOXMLPersister<Person>(
				Person.class);
		migMan.register(personPersister);

		VOXMLPersister<Dataobjecttype> dotPersister = new VOXMLPersister<Dataobjecttype>(
				Dataobjecttype.class);
		migMan.register(dotPersister);

		VOXMLPersister<Dataobject> doPersister = new VOXMLPersister<Dataobject>(
				Dataobject.class);
		migMan.register(doPersister);

	}

	@SuppressWarnings("unchecked")
	void collectAssessmentData(Connection con, Experiment exp, Element rootEl)
			throws Exception {
		AssessmentDAO asDAO = DAOFactory.createAssessmentDAO(csm.getDbID());
		AssessmentscoreDAO scDAO = DAOFactory.createAssessmentscoreDAO(csm
				.getDbID());
		AssessmentintegerDAO aiDAO = DAOFactory.createAssessmentintegerDAO(csm
				.getDbID());
		AssessmentvarcharDAO avDAO = DAOFactory.createAssessmentvarcharDAO(csm
				.getDbID());
		AssessmentfloatDAO afDAO = DAOFactory.createAssessmentfloatDAO(csm
				.getDbID());
		AssessmenttimestampDAO atDAO = DAOFactory
				.createAssessmenttimestampDAO(csm.getDbID());
		StoredassessmentDAO saDAO = DAOFactory.createStoredassessmentDAO(csm
				.getDbID());

		Storedassessment saCR = new Storedassessment();
		saCR.setNcExperimentUniqueid(exp.getUniqueid());

		List<Storedassessment> saList = saDAO.find(con, saCR);
		Set<BigDecimal> saIDSet = new HashSet<BigDecimal>();
		Set<BigDecimal> asIDSet = new HashSet<BigDecimal>();
		for (Storedassessment sa : saList) {
			if (!asIDSet.contains(sa.getAssessmentid())) {
				asIDSet.add(sa.getAssessmentid());
			}
			saIDSet.add(sa.getUniqueid());
		}

		List<Assessment> asList = asDAO.find(con, new Assessment());
		for (Iterator<Assessment> it = asList.iterator(); it.hasNext();) {
			Assessment as = it.next();
			if (!asIDSet.contains(as.getUniqueid())) {
				it.remove();
			}
		}
		VOXMLPersister<Assessment> asPersister = (VOXMLPersister<Assessment>) migMan
				.get("Assessment");
		for (Assessment as : asList) {
			rootEl.addContent(asPersister.toXml(as));
		}

		List<Assessmentscore> scList = scDAO.find(con, new Assessmentscore());
		for (Iterator<Assessmentscore> it = scList.iterator(); it.hasNext();) {
			Assessmentscore sc = it.next();
			if (!asIDSet.contains(sc.getAssessmentid())) {
				it.remove();
			}
		}
		VOXMLPersister<Assessmentscore> scPersister = (VOXMLPersister<Assessmentscore>) migMan
				.get("Assessmentscore");
		for (Assessmentscore sc : scList) {
			rootEl.addContent(scPersister.toXml(sc));
		}

		VOXMLPersister<Storedassessment> saPersister = (VOXMLPersister<Storedassessment>) migMan
				.get("Storedassessment");
		for (Storedassessment sa : saList) {
			rootEl.addContent(saPersister.toXml(sa));
		}

		List<Assessmentinteger> aiList = aiDAO.find(con,
				new Assessmentinteger());
		for (Iterator<Assessmentinteger> it = aiList.iterator(); it.hasNext();) {
			Assessmentinteger ai = it.next();
			if (!saIDSet.contains(ai.getStoredassessmentid())) {
				it.remove();
			}
		}

		VOXMLPersister<Assessmentinteger> aiPersister = (VOXMLPersister<Assessmentinteger>) migMan
				.get("Assessmentinteger");
		for (Assessmentinteger ai : aiList) {
			rootEl.addContent(aiPersister.toXml(ai));
		}

		List<Assessmentvarchar> avList = avDAO.find(con,
				new Assessmentvarchar());
		for (Iterator<Assessmentvarchar> it = avList.iterator(); it.hasNext();) {
			Assessmentvarchar av = it.next();
			if (!saIDSet.contains(av.getStoredassessmentid())) {
				it.remove();
			}
		}

		VOXMLPersister<Assessmentvarchar> avPersister = (VOXMLPersister<Assessmentvarchar>) migMan
				.get("Assessmentvarchar");
		for (Assessmentvarchar av : avList) {
			rootEl.addContent(avPersister.toXml(av));
		}

		List<Assessmentfloat> afList = afDAO.find(con, new Assessmentfloat());
		for (Iterator<Assessmentfloat> it = afList.iterator(); it.hasNext();) {
			Assessmentfloat af = it.next();
			if (!saIDSet.contains(af.getStoredassessmentid())) {
				it.remove();
			}
		}

		VOXMLPersister<Assessmentfloat> afPersister = (VOXMLPersister<Assessmentfloat>) migMan
				.get("Assessmentfloat");
		for (Assessmentfloat af : afList) {
			rootEl.addContent(afPersister.toXml(af));
		}

		List<Assessmenttimestamp> atList = atDAO.find(con,
				new Assessmenttimestamp());
		for (Iterator<Assessmenttimestamp> it = atList.iterator(); it.hasNext();) {
			Assessmenttimestamp at = it.next();
			if (!saIDSet.contains(at.getStoredassessmentid())) {
				it.remove();
			}
		}

		VOXMLPersister<Assessmenttimestamp> atPersister = (VOXMLPersister<Assessmenttimestamp>) migMan
				.get("Assessmenttimestamp");
		for (Assessmenttimestamp at : atList) {
			rootEl.addContent(atPersister.toXml(at));
		}
	}

	@SuppressWarnings("unchecked")
	void collectDataObjectData(Connection con, Experiment exp, Element rootEl)
			throws Exception {
		DataobjecttypeDAO dotDAO = DAOFactory.createDataobjecttypeDAO(csm
				.getDbID());
		DataobjectDAO doDAO = DAOFactory.createDataobjectDAO(csm.getDbID());
		RawdataDAO rdDAO = DAOFactory.createRawdataDAO(csm.getDbID());

		VOXMLPersister<Dataobjecttype> dotPersister = (VOXMLPersister<Dataobjecttype>) migMan
				.get("Dataobjecttype");

		Dataobjecttype dotCR = new Dataobjecttype();
		List<Dataobjecttype> dotList = dotDAO.find(con, dotCR);
		for (Dataobjecttype dot : dotList) {
			rootEl.addContent(dotPersister.toXml(dot));
		}

		Rawdata rdCR = new Rawdata();
		rdCR.setNcExperimentUniqueid(exp.getUniqueid());
		List<Rawdata> rdList = rdDAO.find(con, rdCR);
		Set<BigDecimal> rdSet = new HashSet<BigDecimal>();
		for (Rawdata rd : rdList) {
			rdSet.add(rd.getUniqueid());
		}

		VOXMLPersister<Dataobject> doPersister = (VOXMLPersister<Dataobject>) migMan
				.get("Dataobject");
		Dataobject doCR = new Dataobject();
		List<Dataobject> doList = doDAO.find(con, doCR);
		for (Dataobject d : doList) {
			if (rdSet.contains(d.getDataid())) {
				rootEl.addContent(doPersister.toXml(d));
			}
		}

	}

	@SuppressWarnings("unchecked")
	void collectJobData(Connection con, Experiment exp, Element rootEl)
			throws Exception {
		JobsDAO jobDAO = DAOFactory.createJobsDAO(csm.getDbID());
		VisitJobDAO vjDAO = DAOFactory.createVisitJobDAO(csm.getDbID());
		JobProvenanceDAO jpDAO = DAOFactory.createJobProvenanceDAO(csm
				.getDbID());
		JobProvParamTypeDAO jpptDAO = DAOFactory.createJobProvParamTypeDAO(csm
				.getDbID());
		JobProvenanceParamDAO jppDAO = DAOFactory
				.createJobProvenanceParamDAO(csm.getDbID());
		RawdataDAO rdDAO = DAOFactory.createRawdataDAO(csm.getDbID());
		DeriveddataDAO ddDAO = DAOFactory.createDeriveddataDAO(csm.getDbID());

		VisitJob vjCR = new VisitJob();
		vjCR.setExpId(exp.getUniqueid());
		List<VisitJob> vjList = vjDAO.find(con, vjCR);
		Set<BigDecimal> jobUniqueIDSet = new HashSet<BigDecimal>();
		for (VisitJob vj : vjList) {
			jobUniqueIDSet.add(vj.getJobUniqueId());
		}

		List<Jobs> jobList = jobDAO.find(con, new Jobs());
		for (Iterator<Jobs> it = jobList.iterator(); it.hasNext();) {
			Jobs job = it.next();
			if (!jobUniqueIDSet.contains(job.getUniqueid())) {
				it.remove();
			}
		}

		VOXMLPersister<Jobs> jobPersister = (VOXMLPersister<Jobs>) migMan
				.get("Jobs");
		for (Jobs job : jobList) {
			rootEl.addContent(jobPersister.toXml(job));
		}

		VOXMLPersister<VisitJob> vjPersister = (VOXMLPersister<VisitJob>) migMan
				.get("VisitJob");
		for (VisitJob vj : vjList) {
			rootEl.addContent(vjPersister.toXml(vj));
		}

		List<JobProvParamType> jpptList = jpptDAO.find(con,
				new JobProvParamType());
		VOXMLPersister<JobProvParamType> jpptPersister = (VOXMLPersister<JobProvParamType>) migMan
				.get("JobProvParamType");
		for (JobProvParamType jppt : jpptList) {
			rootEl.addContent(jpptPersister.toXml(jppt));
		}

		Set<BigDecimal> jpIDSet = new HashSet<BigDecimal>();
		List<JobProvenance> jpList = jpDAO.find(con, new JobProvenance());
		for (Iterator<JobProvenance> it = jpList.iterator(); it.hasNext();) {
			JobProvenance jp = it.next();
			if (!jobUniqueIDSet.contains(jp.getJobUniqueid())) {
				it.remove();
			} else {
				jpIDSet.add(jp.getUniqueid());
			}
		}

		VOXMLPersister<JobProvenance> jpPersister = (VOXMLPersister<JobProvenance>) migMan
				.get("JobProvenance");
		for (JobProvenance jp : jpList) {
			rootEl.addContent(jpPersister.toXml(jp));
		}

		List<JobProvenanceParam> jppList = jppDAO.find(con,
				new JobProvenanceParam());
		for (Iterator<JobProvenanceParam> it = jppList.iterator(); it.hasNext();) {
			JobProvenanceParam jpp = it.next();
			if (!jpIDSet.contains(jpp.getJobProvId())) {
				it.remove();
			}
		}
		VOXMLPersister<JobProvenanceParam> jppPersister = (VOXMLPersister<JobProvenanceParam>) migMan
				.get("JobProvenanceParam");
		for (JobProvenanceParam jpp : jppList) {
			rootEl.addContent(jppPersister.toXml(jpp));
		}

		Rawdata rdCR = new Rawdata();
		rdCR.setNcExperimentUniqueid(exp.getUniqueid());
		List<Rawdata> rdList = rdDAO.find(con, rdCR);

		VOXMLPersister<Rawdata> rdPersister = (VOXMLPersister<Rawdata>) migMan
				.get("Rawdata");
		for (Rawdata rd : rdList) {
			rootEl.addContent(rdPersister.toXml(rd));
		}

		Deriveddata ddCR = new Deriveddata();
		ddCR.setNcExperimentUniqueid(exp.getUniqueid());
		List<Deriveddata> ddList = ddDAO.find(con, ddCR);
		VOXMLPersister<Deriveddata> ddPersister = (VOXMLPersister<Deriveddata>) migMan
				.get("Deriveddata");
		for (Deriveddata dd : ddList) {
			File srcFile = new File(dd.getDatauri());
			if (!srcFile.exists()) {
				System.out
						.println("Stale Deriveddata record! Datauri points to no file! :"
								+ srcFile);
				System.out.println("Skipping");
				continue;
			}
			rootEl.addContent(ddPersister.toXml(dd));
		}
	}

	@SuppressWarnings("unchecked")
	public void collectExperimentData(String expName) throws Exception {
		Connection con = null;
		ExperimentDAO expDAO = DAOFactory.createExperimentDAO(csm.getDbID());
		SubjexperimentDAO seDAO = DAOFactory.createSubjexperimentDAO(csm
				.getDbID());
		HumansubjectDAO hsDAO = DAOFactory.createHumansubjectDAO(csm.getDbID());
		ResearchgroupDAO rgDAO = DAOFactory.createResearchgroupDAO(csm
				.getDbID());
		ExpcomponentDAO visitDAO = DAOFactory.createExpcomponentDAO(csm
				.getDbID());
		ExpsegmentDAO segDAO = DAOFactory.createExpsegmentDAO(csm.getDbID());
		PersonDAO personDAO = DAOFactory.createPersonDAO(csm.getDbID());
		CollectionequipmentDAO ceDAO = DAOFactory
				.createCollectionequipmentDAO(csm.getDbID());

		Element rootEl = new Element("migration");

		try {
			con = csm.getConnection();

			List<Person> persons = personDAO.find(con, new Person());
			VOXMLPersister<Person> personPersister = (VOXMLPersister<Person>) migMan
					.get("Person");
			for (Person person : persons) {
				rootEl.addContent(personPersister.toXml(person));
			}

			List<Collectionequipment> ceList = ceDAO.find(con,
					new Collectionequipment());
			VOXMLPersister<Collectionequipment> cePersister = (VOXMLPersister<Collectionequipment>) migMan
					.get("Collectionequipment");
			for (Collectionequipment ce : ceList) {
				rootEl.addContent(cePersister.toXml(ce));
			}

			Experiment expCR = new Experiment();
			expCR.setName(expName);
			List<Experiment> expList = expDAO.find(con, expCR);
			Assertion.assertTrue(expList.size() == 1);
			Experiment exp = expList.get(0);
			VOXMLPersister<Experiment> expPersister = (VOXMLPersister<Experiment>) migMan
					.get("Experiment");
			rootEl.addContent(expPersister.toXml(exp));

			Subjexperiment seCR = new Subjexperiment();
			seCR.setNcExperimentUniqueid(exp.getUniqueid());
			List<Subjexperiment> seList = seDAO.find(con, seCR);

			VOXMLPersister<Subjexperiment> sePersister = (VOXMLPersister<Subjexperiment>) migMan
					.get("Subjexperiment");
			for (Subjexperiment se : seList) {
				rootEl.addContent(sePersister.toXml(se));
			}

			Set<String> subjectIDSet = new HashSet<String>();
			for (Subjexperiment se : seList) {
				subjectIDSet.add(se.getSubjectid());
			}

			List<Humansubject> hsList = hsDAO.find(con, new Humansubject());

			for (Iterator<Humansubject> it = hsList.iterator(); it.hasNext();) {
				Humansubject hs = it.next();
				if (!subjectIDSet.contains(hs.getSubjectid())) {
					it.remove();
				}
			}

			VOXMLPersister<Humansubject> hsPersister = (VOXMLPersister<Humansubject>) migMan
					.get("Humansubject");
			for (Humansubject hs : hsList) {
				rootEl.addContent(hsPersister.toXml(hs));
			}

			Researchgroup rgCR = new Researchgroup();
			rgCR.setNcExperimentUniqueid(exp.getUniqueid());
			List<Researchgroup> rgList = rgDAO.find(con, rgCR);

			VOXMLPersister<Researchgroup> rgPersister = (VOXMLPersister<Researchgroup>) migMan
					.get("Researchgroup");
			for (Researchgroup rg : rgList) {
				rootEl.addContent(rgPersister.toXml(rg));
			}

			Expcomponent visitCR = new Expcomponent();
			visitCR.setNcExperimentUniqueid(exp.getUniqueid());

			List<Expcomponent> viList = visitDAO.find(con, visitCR);
			VOXMLPersister<Expcomponent> visitPersister = (VOXMLPersister<Expcomponent>) migMan
					.get("Expcomponent");
			for (Expcomponent vi : viList) {
				rootEl.addContent(visitPersister.toXml(vi));
			}

			Expsegment segCR = new Expsegment();
			segCR.setNcExperimentUniqueid(exp.getUniqueid());

			List<Expsegment> segList = segDAO.find(con, segCR);
			VOXMLPersister<Expsegment> segPersister = (VOXMLPersister<Expsegment>) migMan
					.get("Expsegment");
			for (Expsegment seg : segList) {
				rootEl.addContent(segPersister.toXml(seg));
			}

			collectAssessmentData(con, exp, rootEl);
			collectJobData(con, exp, rootEl);
			collectDataObjectData(con, exp, rootEl);

			FileUtils.saveXML(rootEl, migrationXmlFile);
			System.out.println("persisted as xml to file:" + migrationXmlFile);

		} finally {
			csm.releaseConnection(con);
		}
	}

}
