package clinical.utils;

/**
 * @author I. Burak Ozyurt
 * @version $Id: Assertion.java 165 2010-02-05 23:25:12Z bozyurt $
 */
public class Assertion {

	protected Assertion() {}
	
	public static void assertNotNull(Object value) {
		if ( value == null) {
			throw new RuntimeException("Object was not expected to be null!");			
		}
	}
	
	public static void assertNotNull(Object value, String msg) {
		if ( value == null) {
			throw new RuntimeException("Object was not expected to be null!\nReason: " + msg);			
		}
	}
	
	public static void assertTrue(boolean exprValue) {
		if ( !exprValue) {
			throw new RuntimeException("The expression evaluated to <false>! Expected <true>");			
		}
	}
	
	public static void assertFalse(boolean exprValue) {
		if ( exprValue) {
			throw new RuntimeException("The expression evaluated to <true>! Expected <false>");			
		}
	}
}
