package clinical.utils;

import java.util.ArrayList;
import java.util.List;

public class Field<T> {
	protected String name;
	protected String type;
	protected T value;
	protected List<T> values;

	public Field(String name) {
		super();
		this.name = name;
	}
	
	public Field(String name, T value) {
		super();
		this.name = name;
		this.value = value;
	}

	public String getName() {
		return name;
	}

	public String getType() {
		return type;
	}

	public T getValue() {
		return value;
	}

	public boolean isArray() {
		return values != null && !values.isEmpty();
	}

	public List<T> getValues() {
		return values;
	}

	void initArray(int size) {
		values = new ArrayList<T>(size);
	}

	void add(T value) {
		if (values == null) {
			values = new ArrayList<T>();
		}
		values.add(value);
	}

	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("Field::[");
		sb.append("name:").append(name);
		if (isArray()) {
			sb.append("\nvalues:");
			sb.append(getValues());
		} else {
			sb.append(",value:");
			sb.append(getValue());
		}
		sb.append(']');
		return sb.toString();
	}
}