package clinical.web;

/**
 * Collection of constants used by the overall application.
 * 
 * @version $Id: Constants.java 773 2013-03-02 00:14:00Z bozyurt $
 * @author I. Burak Ozyurt
 */

public final class Constants {

	private Constants() {
	}

	public final static String ADMIN_USER = "admin";

	public final static String SEL_ASSESSMENT = "select_as";
	public final static String SEL_SCORE = "select_score";
	public final static String SEL_DERIVED = "select_derived";
	public final static String COLLECT_QUERY = "collect_q";
	public final static String TO_COLLECT_QUERY = "collect_query";
	public final static String PREVIOUS = "previous_page";
	public final static String NEXT = "next_page";
	public final static String FINALIZED = "finalized";

	public final static String TO_PORTAL = "toportal";
	public final static String LOGINHANDLER = "/loginhandler.do";

	public final static String ASSESSMENT_NAME_MAP = "clinical.as_map";

	public final static String NAV_RESULTS = "nav_results";
	public final static String NONE = "none";

	public final static String CONTAINER_KEY = "container.key";

	public final static String DBPOOL_KEY = "dbpool.key";
	public final static String ASSESSMENTS_KEY = "assessments.key";
	public static final String DBID2SITEID_MAP = "dbid2siteid.map";
	public static final String DEFAULT_DBID_KEY = "default.dbid.key";

	public final static String ASQUERYFORM_KEY = "asSelectForm";
	public final static String SVMFORM_KEY = "svmForm";
	public final static String RECFORM_KEY = "recForm";
	public final static String ASENTRY_FORM_KEY = "aseForm";

	public final static String SUCCESS = "success";
	public final static String FAILURE = "failure";
	public final static String BACK = "back";

	public final static String MRI_JPEGS_DIR_KEY = "mri.jpegs.dir.key";
	public final static String CACHE_ROOT_KEY = "cache.root.key";
	public static final String IN_PUBLIC_MODE = "public.mode.login";

	/**
	 * holds application specific properties (like external process environment,
	 * path info etc
	 */
	public final static String APP_PROPERTIES_KEY = "app.props.key";

	public final static String SUBVISIT_FORM_KEY = "subVisitForm";
	public final static String SUBVISITMANAGEMENT_FORM_KEY = "svmForm";
	public final static String STORED_QUERY_FORM_KEY = "storedQueryForm";
	/** */
	public final static String CURRENT_EXPERIMENTID_KEY = "current.experimentid";
	public final static String CURRENT_EXPERIMENTNAME_KEY = "current.experiment.name";
	public final static String CURRENT_SUBJECTID_KEY = "current.subjectid";

	public final static String SESSION_STATE_COORDINATOR_KEY = "stateCoordinator";

	public final static String QUERYONLY_OP_PROPERTY = "queryonly.operation";
	public final static String MEDIATOR_SCHEMA_NAME_PROPERTY = "mediator.schema.name";
	public final static String ALLOW_MRI_DOWNLOAD_PROPERTY = "allow.mri.download";
	public final static String ALLOW_FBIRN_IMAGE_DOWNLOAD_PROPERTY = "allow.fbirn.image_download";
	public final static String MIN_NEEDED_MAJOR_VERSION = "min.needed.major.version";
	public final static String MIN_NEEDED_MINOR_VERSION = "min.needed.minor.version";
	public final static String MAX_NEEDED_MAJOR_VERSION = "max.needed.major.version";
	public final static String MAX_NEEDED_MINOR_VERSION = "max.needed.minor.version";

	/** holds the database id as used to find the database connection pool */
	public final static String SESSION_DBID_KEY = "session.dbid.key";

	public final static String MRICONVERT_PROGRESS_TASK_KEY = "prog.mri.task.key";

	public final static String SEGMENT_DB_TABLE = "NC_EXPSEGMENT";
	public final static String COMPONENT_DB_TABLE = "NC_EXPCOMPONENT";
	public final static String HUMANSUBJECT_DB_TABLE = "NC_HUMANSUBJECT";
	public final static String EXPERIMENT_DB_TABLE = "NC_EXPERIMENT";
	public final static String SUBJEXPERIMENT_DB_TABLE = "NC_SUBJEXPERIMENT";
	public final static String BRAINSEGMENTDATA_DB_TABLE = "NC_BRAINSEGMENTDATA";
	public final static String STORED_ASSESSMENT_DB_TABLE = "NC_STOREDASSESSMENT";
	public final static String ASSESSMENT_INTEGER_DB_TABLE = "NC_ASSESSMENTINTEGER";
	public final static String ASSESSMENT_FLOAT_DB_TABLE = "NC_ASSESSMENTFLOAT";
	public final static String ASSESSMENT_VARCHAR_DB_TABLE = "NC_ASSESSMENTVARCHAR";
	public final static String ASSESSMENT_BOOLEAN_DB_TABLE = "NC_ASSESSMENTBOOLEAN";
	public final static String ASSESSMENT_TIMESTAMP_DB_TABLE = "NC_ASSESSMENTTIMESTAMP";
	public final static String RESEARCHGROUP_DB_TABLE = "NC_RESEARCHGROUP";
	public final static String DATABASEUSER_DB_TABLE = "NC_DATABASEUSER";
	public final static String USERCLASS_DB_TABLE = "NC_USERCLASS";
	public final static String PERSON_DB_TABLE = "NC_PERSON";

	public final static String RANGEVALIDATOR_TABLE = "NC_RANGEVALIDATOR";
	public final static String STOREDQUERY_TABLE = "NC_STOREDQUERY";
	public static final String STUDY_DB_TABLE = "NC_EXPSTUDY";
	public static final String JOBS_DB_TABLE = "NC_JOBS";
	public static final String PROTOCOL_TABLE = "NC_PROTOCOL";
	public static final String JOB_PROVENANCE_DB_TABLE = "NC_JOB_PROVENANCE";
	public static final String JOB_PROVENANCE_PARAM_DB_TABLE = "NC_JOB_PROVENANCE_PARAM";
	public static final String JOB_RESULT_GROUP_DB_TABLE = "NC_JOB_RESULT_GROUP";
	public static final String JOB_RESULT_TYPE_DB_TABLE = "NC_JOB_RESULT_TYPE";
	public static final String STORED_JOB_RESULT_GROUP_DB_TABLE = "NC_STORED_JOB_RESULT_GROUP";
	public static final String JOB_RESULT_DB_TABLE = "NC_JOB_RESULT";
	
	public static final String USERCLASS_ADMIN = "admin";
	public static final String USERCLASS_DATA_PROCESSING = "data processing";
	public static final String USERCLASS_RESEARCHER = "researcher";

	public final static String UNIQUEID = "uniqueid";

	public final static String UID_SEQ_NEXTVAL = "uid_seq.nextval";

	public final static String EDIT_VISIT = "edit_visit";
	public final static String ADD_VISIT = "add_visit";
	public final static String AFTER_ADD_VISIT = "after_add_visit";

	public final static String EDIT_SUBJECT = "edit_subject";
	public final static String ADD_SUBJECT = "add_subject";
	public final static String SHOW_SUBJECT_DELETED = "subject_deleted";

	public static final String SHOW_QUERY_WIZARD = "show_qw";

	public final static String SHOW_SEARCH = "show_search";
	public final static String MANAGE_SEGMENT = "manage_segment";
	public final static String EDIT_SEGMENT = "edit_segment";
	public final static String ADD_SEGMENT = "add_segment";
	public final static String SAVE_QUERY = "save_query";
	public final static String LOAD_QUERY = "load_query";
	public final static String EDIT_STUDY = "edit_study";
	public final static String ADD_STUDY = "add_study";
	public final static String CANNOT_UNENROLL = "cannot_unenroll";

	public final static String SUBJECT_LIST = "subject_list";

	public final static String SHOW_ADD_EXP = "show_add_exp";
	public final static String SHOW_FIND_EXP = "show_find_exp";
	public final static String SHOW_ENROLL_SUBJECT = "show_enroll_subject";
	public final static String SHOW_ADD_STUDYGROUP = "show_add_studygroup";

	public final static String CAN_MANAGEEXPERIMENT = "manageExperiment";
	public final static String CAN_MANAGESUBJECT = "manageSubject";
	public final static String JUMP_TO_SUBJECT = "jump_to_subject";
	
	/** after successful password change forward */
	public final static String PC_SUCCESS = "pc_success";

	public final static String COLLAPSE_EXPAND = "collapse_expand";

	public final static String NO_PICTURE_JPEG = "/images/no-picture.jpg";
	/** the name of the representative DICOM slice from the SRB */
	public final static String DICOM_SLICE = "050.dcm";

	public final static String VISIT_TYPE_SCAN = "scan";
	public final static String VISIT_TYPE_CLINICAL = "clinical";

	/**
	 * property name for the local directory to store the temporary files
	 * created
	 */
	public final static String TEMP_FILES_LOCATION = "temp.files.location";
	/** the SRB collection to where the temporary files are saved */
	public final static String SRB_TEMP_COLLECTION = "srb.temp.collection";

	public final static String PORTAL_URL = "portal.url";
	public final static String PORTAL_BROWSER_ADDRESS = "portal.browser.address";
	public final static String PORTAL_STAT_SRB_LOCATION = "portal.stats.base.srb.location";

	// public final static String PORTAL_STAT_NAME = "portal.stats.stat.name";
	// public final static String PORTAL_STAT_PAGE = "portal.stats.stat.page";

	/** key for the list of database ids in application context */
	public final static String DBID_LIST_KEY = "dbid_list.key";

	/** index page */
	public final static String INDEX_PAGE = "/index.jsp";

	public final static String MISSING_VALUE_CLASSIFICATION = "Missing Value";

	// mediator related
	public final static String MEDIATOR_URL = "http://imhotep.ucsd.edu:18080/axis/servlet/AxisServlet";

	public final static String UCSD_SOURCE = "ucsdv3";
	public final static String MGH_SOURCE = "mghv3";

	public final static String WORKER_THREAD_QUEUE_KEY = "worker_thread_queue_key";
	public final static String SITE_ASSESSMENT_MAP_KEY = "site_as_map_key";

	public final static int MAX_COLUMNS_PER_ROW = 3;

	// GAME related
	public final static String GAME_FORM_BEAN_NAME_KEY = "game.formbean.name.key";
	public final static String GAME_CURRENT_FORM_BEAN_KEY = "game.formbean.key";
	public final static String SELECTED_ENTRYID_KEY = "game.entryid.key";

	/* default informant relation used */
	public final static String SELF = "self";
	public final static String INFORMANTID_PROPERTY = "informantid";
	public final static String INFORMANTRELATION_PROPERTY = "informantrelation";
	public final static String TIME_PROPERTY = "time";
	public final static String DATE_PROPERTY = "date";
	public final static String CLINICALRATER_PROPERTY = "clinicalrater";
	public final static String QUERY_PROPERTY = "query";
	public final static String CURRENTPAGEIDX_PROPERTY = "currentPageIdx";
	public final static String ALLOWVALIDATION_PROPERTY = "allowValidation";
	public final static String SELECTEDQUESTION_PROPERTY = "selectedQuestion";

	// start of Dispatcher Constants (DO NOT REMOVE THIS COMMENT! USED by CALM)
	public final static String TO_DEMOGRAPH = "to_demograph";
	public final static String TO_SES1 = "to_ses1";
	public final static String TO_QMST = "to_qmst";
	public final static String TO_FTCA = "to_ftca";
	public final static String TO_HCA = "to_hca";
	public final static String TO_HTCA = "to_htca";
	public final static String TO_SCID_NP = "to_scid_np";

	public final static String TO_AGEOFONSET = "to_ageofonset";
	public final static String TO_SCID_P_M = "to_scid_p_m";
	public final static String TO_QUICKMOOD = "to_quickmood";
	public final static String TO_ASI = "to_asi";
	public final static String TO_BDI = "to_bdi";
	public final static String TO_TEST1 = "to_test1";
	public final static String TO_BARS = "to_bars";
	public final static String TO_SANS = "to_sans";
	public final static String TO_CDS = "to_cds";
	public final static String TO_AIMS = "to_aims";
	public final static String TO_SAPS = "to_saps";
	public final static String TO_SARS = "to_sars";
	public final static String TO_FIGS = "to_figs";
	public final static String TO_PAS = "to_pas";
	public final static String TO_TEST = "to_test";
	public final static String TO_SES = "to_ses";
	public final static String TO_NAART = "to_naart";
	public final static String TO_DSS = "to_dss";
	public final static String TO_SCIDP = "to_scidp";
	public final static String TO_SCIDNP = "to_scidnp";
	public final static String TO_EHI = "to_ehi";
	public final static String TO_PANSS = "to_panss";
	public final static String TO_INTERSEPT = "to_intersept";
	public final static String TO_TESTMA = "to_testma";
	public final static String TO_FAVORITES = "to_favorites";
	public final static String TO_HAIRSTYLE = "to_hairstyle";
	public final static String TO_HALLUCINATION = "to_hallucination";
	public final static String TO_DEMOGRAPHICS = "to_demographics";

	public final static String TO_SCREENER = "to_screener";
	public final static String TO_ABERRANT = "to_aberrant";
	public final static String TO_VITALS = "to_vitals";

	public final static String TO_CTA = "to_cta";

	// for phase III
	public final static String TO_PACKYEAR = "to_packyear";
	public final static String TO_TRAVELSCREEN = "to_travelscreen";
	public final static String TO_HEMATOCRIT = "to_hematocrit";

	public static final String DO_SCHEMA_VERSION_CHECK = "schema.version.check";

	// for stats
	public final static String STATS_CHANGE = "change";

	// for job scheduler
	public static final String SCHEDULER_DIR = "WEB-INF/scheduler";
	public static final String BATCHQUERY_FORM_KEY = "bqForm";
	public static final String SHOW_JOBS = "show_jobs";
	// for help service
	public static final String HELP_MSG_REPOSITORY_FILE = "WEB-INF/help.messages";
	// for download shopping cart
	public static final String VIEW_CART = "view_cart";
	public static final String SCHEDULE_COMPLETE = "schedule_complete";
	public static final String BATCH_IMG_DOWNLOAD = "batch_img_download";

	// for by project downloading
	public static final String VIEW = "view";
	public static final String SCHEDULE_DOWNLOAD = "schedule_download";

	// for user & database configuration
	public static final String CC_SUCCESS = "cc_success";
	public static final String EDIT_USER = "edit_user";
	public static final String EDIT_DB = "edit_db";

	// for derived data with extended tuple
	public static final String MEASUREMENT_SYSTEM = "NC_MEASUREMENTSYSTEM";
	public static final String MEASUREMENT_TYPE = "NC_MEASUREMENTTYPE";
	public static final String MEASUREMENT_UNIT = "NC_MEASUREMENTUNIT";
	public static final String TUPLE_COLUMNS = "NC_TUPLECOLUMNS";

	public static final String TUPLE_CLASS = "NC_TUPLECLASS";
	public static final String TUPLE_SUBCLASS = "NC_TUPLESUBCLASS";
	public static final String EXTENDED_TUPLE = "NC_EXTENDEDTUPLE";

	public static final String TUPLE_INTEGER = "NC_TUPLEINTEGER";
	public static final String TUPLE_FLOAT = "NC_TUPLEFLOAT";
	public static final String TUPLE_VARCHAR = "NC_TUPLEVARCHAR";
	public static final String ANALYSIS_RESULT = "NC_ANALYSISRESULT";
	public static final String STORED_TUPLE = "NC_STOREDTUPLE";

	public static final String VARCHAR_TYPE = "varchar";
	public static final String INTEGER_TYPE = "integer";
	public static final String FLOAT_TYPE = "float";

	public static final String DEFAULT_ONT_SRC = "UNKNOWN";
	public static final String DEFAULT_ONT_CONCEPT = "9999";

	public static final String ANALYSIS = "NC_ANALYSIS";
	public static final String ANALYSIS_COMPONENT = "NC_ANALYSISCOMPONENT";
	public static final String ANALYSIS_FLOW = "NC_ANALYSISFLOW";

	public static final String TRANSFORMATION = "NC_TRANSFORMATION";
	public static final String TRANSFORMATION_ARG = "NC_TRANSFORMATIONARGUMENT";
	public static final String ARGUMENT_TYPE = "NC_ARGUMENTTYPE";

	public static final String MACHINE = "NC_MACHINE";
	public static final String DERIVED_DATA = "NC_DERIVEDDATA";
	public static final String EXECUTED_TRANSFORM = "NC_EXECUTEDTRANSFORM";
	public static final String EXECUTED_TRANSFORM_FLOW = "NC_EXECUTEDTRANSFORMFLOW";
	public static final String TRANSFORMED_DATA = "NC_TRANSFORMEDDATA";
	public static final String TRANSFORM_INPUT_DATA = "NC_TRANSFORMINPUTDATA";
	public static final String EXTERNAL_DATA = "NC_EXTERNALDATA";
	public static final String RAWDATA = "NC_RAWDATA";
	public static final String UPLOAD_STATUS = "NC_UPLOAD_STATUS";
	
	
	
	
	// FIXME turn on BIRN URIs
	public static final boolean USE_BIRN_URIS = false;

	public static final String SEGMENT_SCOPE = "Segment Scope";
	public static final String VISIT_SCOPE = "Visit Scope";
	public static final String PROJECT_SCOPE = "Project Scope";

   public static final String ASSESSMENT_TABLE = "NC_ASSESSMENT";
   public static final String ASSESSMENTSCORE_TABLE = "NC_ASSESSMENTSCORE";

	// -------------------- forward constants ------------------
	public static final String FORWARD_RESULTS = "results";
	public static final String FORWARD_CANCEL = "cancel";

	
	// -------------------- Globus related constants ---------------
	public static final String MYPROXY_HOST_KEY = "globus.myproxy.server.primary";
	public static final String RLS_URL_KEY = "globus.rls.server.url.primary";

	public static final String GRIDFTP_PORT_KEY = "globus.gridftp.server.port";
	public static final String MYPROXY_PORT_KEY = "globus.myproxy.server.port";

	public static final String MASTER_GRIDFTP_HOST_KEY = "globus.master.gridftp.server";

	public static final String TEMPLATE_DIR = "/WEB-INF/templates";

	// ---------------------- CBFBIRN related -----------------------
	public static final String ASSESSMENT_SEGMENT = "clinical";
	public static final String CLINICAL_PROTOCOL = "Clinical";

	public static final String VISIT_TYPE_MRI_SCAN = "MRI scan";
	public static final String COLLECTION_EQUIPMENT_TABLE = "NC_COLLECTIONEQUIPMENT";
	public static final String DATAOBJECT_TABLE = "NC_DATAOBJECT";

	public static final String CBFBIRN_DATA_ROOT_KEY = "cbfbirn.data.root";
	public static final String JOB_MAN_FORM_KEY = "jmForm";

	public static final String SUBMITTED = "submitted";
	public static final String ASSOCIATE = "associate";
	public static final String SSGA_SUBMITTED = "ssgaSubmitted";
	public static final String BLGA_SUBMITTED = "blgaSubmitted";
	public static final String GA_SEL_FACTORS = "gaSelectFactors";
	
	public static final String JOB_FILTER_DB_TABLE = "NC_JOB_FILTER";
	
	public static final String INPUT = "input";

	
}
