package clinical.web;

import java.sql.Connection;

import clinical.server.vo.Databaseuser;
import clinical.server.vo.Person;
import clinical.server.vo.Userclass;
import clinical.web.common.security.DBConfig;
import clinical.web.common.security.User;
import clinical.web.common.UserInfo;

/**
 * @author I. Burak Ozyurt
 * @version $Id: IDBUserManService.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public interface IDBUserManService {

   public void prepareKeyers(DBConfig dbConfig) throws Exception;

   public Person findOrInsertPerson(Connection con, String dbID, UserInfo ui,
         User owner, String firstName, String lastName, String email,
         String userClass) throws Exception;

   public Userclass insertUserClass(Connection con, String dbID, UserInfo ui,
         User owner, String userClass) throws Exception;

   public Databaseuser insertDatabaseUser(Connection con, String dbID,
         User webUser, Userclass uc, UserInfo ui, User owner) throws Exception;

   public Databaseuser ensureClinicalRater(UserInfo ui, String clinicalRater)
         throws Exception;
   
   public Databaseuser ensureClinicalRater(Connection con, UserInfo ui,
			String clinicalRater) throws Exception;

}