package clinical.web.actions;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ExceptionHandler;
import org.apache.struts.config.ExceptionConfig;

import clinical.utils.HTTPUtils;
import clinical.web.Constants;
import clinical.web.UserContainer;
import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;
import clinical.web.exception.ExpiredSessionException;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: BaseActionHelper.java 366 2011-05-05 20:06:27Z bozyurt $
 */

public class BaseActionHelper {
	private Log log = LogFactory.getLog(BaseActionHelper.class);

	public BaseActionHelper() {
	}

	/**
	 * This method determines how a thrown exception is handled. This method
	 * first checks if there is a registered ExceptionHandler for this
	 * exception, if so delegates the error processing to that. If there is no
	 * exception handler, it generates error messages and corresponding
	 * <code>ActionError</code> instances and populates the passed
	 * <code>errors</code>.
	 * <p>
	 * If no logical forward name is specified, it returns the default failure
	 * page as specified by the <code>Constants.FAILURE</code>.
	 * 
	 * @param request
	 * @param response
	 * @param mapping
	 *            represents the information that the Struts controller knows
	 *            about the mapping of a particular request to an instance of a
	 *            particular Action class
	 * @param form
	 *            a java bean holding the user interface form data
	 * @param be
	 *            an exception raised within the user defined Action
	 * @param errors
	 *            encapsulates the error messages being reported by the
	 *            <code>validate()</code> method of the
	 *            <code>ActionForm</code>.
	 * @param forwardName
	 *            the logical name of the page the response will be forwarded.
	 *            If null this method uses the <code>Constants.FAILURE</code>
	 *            as the failure forward logical name.
	 * @return destination to which the controller, RequestProcessor, might be
	 *         directed to perform a <code>RequestDispatcher.forward</code> or
	 *         <code>HttpServletResponse.sendRedirect</code> to, as a result
	 *         of processing activities of an <code>Action</code> class
	 * @throws ServletException
	 */
	public ActionForward processExceptions(HttpServletRequest request,
			HttpServletResponse response, ActionMapping mapping,
			ActionForm form, BaseException be, ActionMessages errors,
			String forwardName) throws ServletException {
		log.debug("forwardName=" + forwardName);

		ExceptionConfig excConfig = mapping.findException(be.getClass());
		if (excConfig != null) {
			log.info("*** excConfig " + excConfig);
			try {
				Class<?> handlerClazz = Class.forName(excConfig.getHandler());
				ExceptionHandler excHandler = (ExceptionHandler) handlerClazz
						.newInstance();
				return excHandler.execute(be, excConfig, mapping, form,
						request, response);
			} catch (Exception x) {
				throw new ServletException(x);
			}
		} else {
			log.info("*** no ExceptionConfig has found");
		}

		ActionForward forward = null;
		// use default locale for the environment
		Locale locale = Locale.getDefault();
		processBaseException(errors, be, locale);

		// return to either input resource or configured failure forward
		String inputStr = mapping.getInput();
		if (forwardName == null)
			forwardName = Constants.FAILURE;
		log.debug(">> forwardName=" + forwardName);
		ActionForward failureForward = mapping.findForward(forwardName);

		log.debug("inputStr=" + inputStr);
		if (failureForward != null) {
			forward = failureForward;
			log.debug(" failureForward != null new forward:" + forward);
		} else if (inputStr != null) {
			forward = new ActionForward(inputStr);
			log.debug(" inputStr != null new forward:" + forward);
		}
		List<?> exceptions = be.getExceptions();
		if (exceptions != null && !exceptions.isEmpty()) {
			for (Iterator<?> it = exceptions.iterator(); it.hasNext();) {
				BaseException se = (BaseException) it.next();
				processBaseException(errors, se, locale);
			}
		}
		// save exceptions
		return forward;
	}

	public ActionForward processExceptions(HttpServletRequest request,
			HttpServletResponse response, ActionMapping mapping,
			ActionForm form, BaseException be, ActionMessages errors)
			throws ServletException {
		return processExceptions(request, response, mapping, form, be, errors,
				null);
	}

	protected void processBaseException(ActionMessages errors,
			BaseException ex, Locale locale) {
		ActionMessage ae = null;

		String errCode = ex.getMessageKey();

		log.info("errCode=" + errCode);
		log.error("processBaseException", ex);
		Object[] args = ex.getMessageArgs();
		if (args != null && args.length > 0) {
			ae = new ActionMessage(errCode, args);
		} else {
			if (errCode.equals("errors.common")) {
				String msg = null;
				if (ex.getRootCause() == null) {
					msg = ex.getMessage();
				} else {
					msg = ex.getRootCause().getMessage();
				}
				ae = new ActionMessage(errCode, msg);
			} else {
				ae = new ActionMessage(errCode);
			}
		}
		errors.add(ActionMessages.GLOBAL_MESSAGE, ae);
	}

	/**
	 * checks the current session for user information, throws
	 * <code>ExpiredSessionException</code> if not found.
	 * 
	 * @param request
	 *            servlet request
	 * @throws ExpiredSessionException
	 *             if session has expired or the user is invalid
	 */
	public void checkUser(HttpServletRequest request)
			throws ExpiredSessionException {
		HttpSession session = request.getSession(false);
		if (session == null)
			throw new ExpiredSessionException();
		UserContainer uc = (UserContainer) session
				.getAttribute(Constants.CONTAINER_KEY);
		if (uc == null)
			throw new ExpiredSessionException();
		UserInfo ui = uc.getUserInfo();
		if (ui == null)
			throw new ExpiredSessionException();
	}

	/**
	 * 
	 * @param request
	 * @return
	 * @throws ExpiredSessionException
	 */
	public UserInfo getUserInfo(HttpServletRequest request)
			throws ExpiredSessionException {
		HttpSession session = request.getSession(false);
		if (session == null) {
			throw new ExpiredSessionException("Session was null");
		}

		if (log.isDebugEnabled()) {
			String contents = HTTPUtils.dumpSessionContents(session);
			log.debug(contents);
		}

		UserContainer uc = (UserContainer) session
				.getAttribute(Constants.CONTAINER_KEY);
		if (uc == null)
			throw new ExpiredSessionException("UserContainer was null");
		UserInfo ui = uc.getUserInfo();
		if (ui == null)
			throw new ExpiredSessionException("UserInfo was null");

		return ui;
	}
}
