package clinical.web.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONObject;

import clinical.server.vo.Experiment;
import clinical.utils.Assertion;
import clinical.utils.GenUtils;
import clinical.web.CBFBIRNConstants;
import clinical.web.Constants;
import clinical.web.IAppConfigService;
import clinical.web.ICBFWFManagementService;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.ISecurityService;
import clinical.web.common.UserInfo;
import clinical.web.common.security.DBConfig;
import clinical.web.common.security.User;
import clinical.web.exception.ValidationException;
import clinical.web.forms.CBFBatchJobManForm;
import clinical.web.helpers.CBFBirnHelper;
import clinical.web.helpers.SubjectExperimentsSelector;
import clinical.web.scheduler.IJob;
import clinical.web.scheduler.JobScheduler;
import clinical.web.scheduler.JobScheduler.JobSubmissionType;
import clinical.web.vo.upload.SegmentInfo;
import clinical.web.vo.upload.SeriesHeaderInfo;
import clinical.web.vo.upload.VisitInfo;
import clinical.web.workflow.cbf.CBFProcessingJob;
import clinical.web.workflow.cbf.CBFWFContext;
import clinical.web.workflow.cbf.SiemensCBFProcessingJob;
import clinical.web.workflow.cbf.UCLACBFProcessingJob;
import clinical.web.workflow.cbf.VisitProcessInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */

public class CBFBatchJobManAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(11);
	private Log log = LogFactory.getLog(CBFBatchJobManAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("action.batch.cbfjob.view", "viewMain");
		map.put("action.batch.cbfjob.submitjobs", "submitJobs");
		return map;
	}

	public ActionForward viewMain(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info("view");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			CBFBatchJobManForm batchForm = (CBFBatchJobManForm) form;
			batchForm.setDoFieldMapCorrection(false);
			batchForm.setDoSense(false);

			ICBFWFManagementService cbfService = ServiceFactory
					.getCBFWFManagementService(dbID);

			Map<String, List<VisitInfo>> exp2ViListMap = cbfService
					.getScanVisits(ui);

			exp2ViListMap = CBFBirnHelper
					.filterNonCBFProcessable(exp2ViListMap);
			batchForm.setExp2ViListMap(exp2ViListMap);
			JSONObject json = CBFBirnHelper
					.prepareExp2ViListMapAsJSON(exp2ViListMap);

			log.info(json.toString(3));

			batchForm.setExp2ViListJSON(json.toString());
			if (exp2ViListMap.isEmpty()) {
				batchForm.setHasData(false);
			} else {
				batchForm.setHasData(true);
				IDBCache dbCache = ServiceFactory.getDBCache(dbID);
				List<Experiment> experiments = dbCache.getExperiments(ui, true);
				List<Experiment> usedExpList = new ArrayList<Experiment>(
						experiments.size());
				for (Experiment exp : experiments) {
					if (exp2ViListMap.containsKey(exp.getName())) {
						usedExpList.add(exp);
					}
				}

				SubjectExperimentsSelector expSelector = new SubjectExperimentsSelector(
						usedExpList);
				batchForm.setExpSelector(expSelector);
			}
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("viewMain", x);
			return super.processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward submitJobs(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> submitJobs");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			CBFBatchJobManForm batchForm = (CBFBatchJobManForm) form;
			batchForm.setDoFieldMapCorrection(false);
			batchForm.setDoSense(false);
			String paramValue = request.getParameter("preproc");
			System.out.println("preproc:" + paramValue);
			if (paramValue != null && paramValue.equals("doFieldMapCorrection")) {
				batchForm.setDoFieldMapCorrection(true);
			}

			if (paramValue != null && paramValue.equals("doSense")) {
				batchForm.setDoSense(true);
			}
			paramValue = request.getParameter("doReg");
			if (paramValue != null) {
				batchForm.setDoReg(true);
			} else {
				batchForm.setDoReg(false);
			}
			paramValue = request.getParameter("doSkullStripping");
			if (paramValue != null) {
				batchForm.setDoSkullStripping(true);
			} else {
				batchForm.setDoSkullStripping(false);
			}

			paramValue = request.getParameter("doAutoCSF");
			batchForm.setUseAutomatedSegmentation(paramValue != null);

			paramValue = request.getParameter("doPVC");
			batchForm.setDoPartialVolumeCorrection(paramValue != null);

			double gmThreshold = GenUtils.toDouble(batchForm.getGmThreshold(),
					0.9);

			paramValue = request.getParameter("align");
			if (paramValue != null) {
				batchForm.setAlignment(GenUtils.toInt(paramValue, 3));
			} else {
				batchForm.setAlignment(3);
			}

			paramValue = request.getParameter("csfMethod");
			if (paramValue != null) {
				batchForm.setCsfMethod(GenUtils.toInt(paramValue,
						CBFWFContext.AUTOMATIC));
			} else {
				batchForm.setCsfMethod(CBFWFContext.AUTOMATIC);
			}

			paramValue = request.getParameter("ltMethod");
			batchForm.setUseLTMethod(paramValue != null);

			if (batchForm.getGaussianFilterParam() == null) {
				batchForm.setGaussianFilterParam("4.0");
			} else {
				batchForm.setGaussianFilterParam(String.valueOf(GenUtils
						.toDouble(batchForm.getGaussianFilterParam(), 4.0)));
			}

			System.out.println("skullStripping:"
					+ batchForm.isDoSkullStripping());
			System.out.println("gmThreshold:" + batchForm.getGmThreshold());
			System.out.println("doReg:" + batchForm.isDoReg());
			System.out.println("doAutoCSF:"
					+ batchForm.isUseAutomatedSegmentation());
			System.out.println("doPVC:"
					+ batchForm.isDoPartialVolumeCorrection());
			System.out.println("doFieldMapCorrection:"
					+ batchForm.isDoFieldMapCorrection());
			System.out.println("align:" + batchForm.getAlignment());
			System.out.println("csfMethod:" + batchForm.getCsfMethod());
			System.out.println("ltMethod:" + batchForm.isUseLTMethod());
			System.out.println("gaussianFilterParam:"
					+ batchForm.getGaussianFilterParam());

			String[] values = request.getParameterValues("viSelector");
			if (values != null && values.length > 0) {
				for (int i = 0; i < values.length; i++) {
					System.out.println("VisitInfo: " + values[i]);
				}
			}

			VisitInfoListWrapper wrapper = getSelectedVisitInfos(batchForm,
					values);

			ICBFWFManagementService cbfService = ServiceFactory
					.getCBFWFManagementService(dbID);
			IAppConfigService configService = ServiceFactory
					.getAppConfigService();

			// remove partially loaded segment data list for full segment info
			// retrieval
			for (VisitInfo vi : wrapper.getViList()) {
				vi.getSiList().clear();
			}

			List<VisitInfo> visitInfosWithScans = cbfService
					.getVisitInfosWithScans(ui, wrapper.getViList());

			String cacheRoot = configService
					.getParamValue("download.cacheroot");
			if (cacheRoot == null || cacheRoot.trim().length() == 0) {
				throw new ValidationException(
						"System Setup Problem: A valid cache root directory needs to be supplied "
								+ "during system setup with property download.cacheroot:! ");
			}

			String matlabDir = configService
					.getParamValue("cbfbirn.matlab.dir");
			if (matlabDir == null || matlabDir.trim().length() == 0) {
				throw new ValidationException(
						"System Setup Problem: A valid MATLAB source directory for CBF processing "
								+ "needs to be supplied "
								+ "during system setup with property cbfbirn.matlab.dir:! ");
			}
			String templateDir = super.servlet.getServletContext().getRealPath(
					Constants.TEMPLATE_DIR);

			DBConfig dbConfig = ServiceFactory.getSecurityAdminService()
					.getDBConfigMap().get(dbID);
			User user = dbConfig.findUser(ui.getName());

			if (user.getEmail() == null) {
				ISecurityService secService = ServiceFactory
						.getSecurityService();
				String email = secService.getEmail(ui.getName());
				user.setEmail(email);
			}
			log.info("CBFBatchJobManAction:: emailTo:" + user.getEmail());

			JobScheduler scheduler = JobScheduler.getInstance();

			batchForm.clearJobId2SubjectIdMap();
			for (VisitInfo visitInfo : visitInfosWithScans) {
				String id = String.valueOf(System.currentTimeMillis());

				String key = VisitInfoListWrapper.prepKey(
						visitInfo.getSubjectID(), visitInfo.getVisitId());
				String visitLabel = wrapper.getLabel(key);
				Assertion.assertNotNull(visitLabel);

				String workDir = visitLabel + "_" + id;
				File cacheDir = new File(cacheRoot, workDir);
				cacheDir.mkdirs();

				String description = "CBF processing for '" + visitLabel + "'";
				// placeholder used for recoverable jobs (jobs that were at
				// waiting state while a server crash).
				List<VisitProcessInfo> vpiList = new ArrayList<VisitProcessInfo>(
						1);

				CBFWFContext ctx = new CBFWFContext(dbID,
						batchForm.isDoFieldMapCorrection(),
						cacheDir.getAbsolutePath(),
						Arrays.asList(visitInfo) /* visitInfosWithScans */,
						batchForm.isDoSense(), batchForm.isDoReg(),
						batchForm.isDoSkullStripping(), gmThreshold, vpiList,
						id);
				ctx.setUseAutomatedSegmentation(batchForm
						.isUseAutomatedSegmentation());
				ctx.setDoPartialVolumeCorrection(batchForm
						.isDoPartialVolumeCorrection());
				ctx.setAlignment(batchForm.getAlignment());
				ctx.setCsfMethod(batchForm.getCsfMethod());
				ctx.setUseLTMethod(batchForm.isUseLTMethod());
				ctx.setGaussianFilterParam(GenUtils.toDouble(
						batchForm.getGaussianFilterParam(), 4.0));

				ctx.setTemplateDir(templateDir);
				ctx.setMatlabDir(matlabDir);
				ctx.setEmailTo(user.getEmail());

				IJob job = null;
				boolean uclaData = hasAnalyzeSeries(visitInfo);
				if (visitInfo.getScannerType().equalsIgnoreCase(
						CBFBIRNConstants.SIEMENS)) {
					if (!uclaData) {
						job = new SiemensCBFProcessingJob(id, ui, description,
								ctx, templateDir, matlabDir, user.getEmail());
					} else {
						// UCLA data
						job = new UCLACBFProcessingJob(id, ui, description, ctx,
								templateDir, matlabDir, user.getEmail(), null);
					}
				} else {
					job = new CBFProcessingJob(id, ui, description, ctx,
							templateDir, matlabDir, user.getEmail());
				}
				// schedule job
				scheduler.addJob(job, JobSubmissionType.BATCH);
				// wait a few millisecs for uniqueid job id
				try {
					Thread.sleep(20);
				} catch (InterruptedException ie) {
					// no op
				}

				log.info("adding job with ID " + id + " to the scheduler.");
				batchForm.putSubmittedJobInfo(id, visitInfo.getSubjectID());
			} // for visitInfosWithScans

			return mapping.findForward(Constants.SUBMITTED);

		} catch (Exception x) {
			log.error("submitJobs", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	private boolean hasAnalyzeSeries(VisitInfo vi) {
		for (SegmentInfo si : vi.getSiList()) {
			if (si.getShi().getImageType().equals(SeriesHeaderInfo.ANALYZE)) {
				return true;
			}
		}
		return false;
	}

	private VisitInfoListWrapper getSelectedVisitInfos(
			CBFBatchJobManForm batchForm, String[] visitInfoArr) {
		String selExpName = batchForm.getExpSelector()
				.getSelectedExperimentName();
		List<VisitInfo> viList = batchForm.getExp2ViListMap().get(selExpName);
		Map<String, VisitInfo> viMap = new HashMap<String, VisitInfo>();
		for (VisitInfo vi : viList) {
			String key = VisitInfoListWrapper.prepKey(vi.getSubjectID(),
					vi.getVisitId());
			viMap.put(key, vi);
		}

		List<VisitInfo> selViList = new ArrayList<VisitInfo>(
				visitInfoArr.length);
		VisitInfoListWrapper wrapper = new VisitInfoListWrapper(selViList);
		for (String visitInfo : visitInfoArr) {
			int idx = visitInfo.lastIndexOf('_');
			Assertion.assertTrue(idx != -1);
			String selSubjectID = visitInfo.substring(0, idx);
			int selVisitID = GenUtils.toInt(visitInfo.substring(idx + 1), -1);
			Assertion.assertTrue(selVisitID != -1);
			String key = VisitInfoListWrapper.prepKey(selSubjectID, selVisitID);
			VisitInfo vi = viMap.get(key);
			Assertion.assertNotNull(vi);
			wrapper.viList.add(vi);
			wrapper.addKey2Label(key, visitInfo);

		}
		return wrapper;
	}

	public final static class VisitInfoListWrapper {
		List<VisitInfo> viList;
		Map<String, String> key2LabelMap = new HashMap<String, String>();

		public VisitInfoListWrapper(List<VisitInfo> viList) {
			this.viList = viList;
		}

		void addKey2Label(String key, String label) {
			key2LabelMap.put(key, label);
		}

		public String getLabel(String key) {
			return key2LabelMap.get(key);
		}

		public static String prepKey(String subjectID, int visitID) {
			StringBuilder sb = new StringBuilder();
			sb.append(subjectID).append(':').append(visitID);
			return sb.toString();
		}

		public List<VisitInfo> getViList() {
			return viList;
		}
	}
}
