package clinical.web.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONObject;

import clinical.server.vo.Experiment;
import clinical.utils.Assertion;
import clinical.utils.GenUtils;
import clinical.web.CBFBIRNConstants;
import clinical.web.Constants;
import clinical.web.IAppConfigService;
import clinical.web.ICBFWFManagementService;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.ISecurityService;
import clinical.web.common.UserInfo;
import clinical.web.common.security.DBConfig;
import clinical.web.common.security.User;
import clinical.web.exception.ValidationException;
import clinical.web.forms.CBFJobManForm;
import clinical.web.helpers.CBFBirnHelper;
import clinical.web.helpers.SubjectExperimentsSelector;
import clinical.web.scheduler.IJob;
import clinical.web.scheduler.JobScheduler;
import clinical.web.scheduler.JobScheduler.JobSubmissionType;
import clinical.web.vo.upload.SegmentInfo;
import clinical.web.vo.upload.SeriesHeaderInfo;
import clinical.web.vo.upload.VisitInfo;
import clinical.web.workflow.cbf.CBFProcessingJob;
import clinical.web.workflow.cbf.CBFWFContext;
import clinical.web.workflow.cbf.SiemensCBFProcessingJob;
import clinical.web.workflow.cbf.UCLACBFProcessingJob;
import clinical.web.workflow.cbf.VisitProcessInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: CBFJobManAction.java 806 2013-05-06 23:25:04Z bozyurt $
 */

public class CBFJobManAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(11);
	private Log log = LogFactory.getLog(CBFJobManAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("action.cbfjob.view", "viewMain");
		map.put("action.cbfjob.submitjob", "submitJob");
		return map;
	}

	public ActionForward viewMain(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> viewMain");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			CBFJobManForm cjmForm = (CBFJobManForm) form;
			cjmForm.setDoSense(false);
			cjmForm.setDoFieldMapCorrection(false);

			ICBFWFManagementService cbfService = ServiceFactory
					.getCBFWFManagementService(dbID);

			Map<String, List<VisitInfo>> exp2ViListMap = cbfService
					.getScanVisits(ui);

			exp2ViListMap = CBFBirnHelper
					.filterNonCBFProcessable(exp2ViListMap);

			cjmForm.setExp2ViListMap(exp2ViListMap);

			JSONObject json = CBFBirnHelper
					.prepareExp2ViListMapAsJSON(exp2ViListMap);
			if (log.isDebugEnabled()) {
				log.debug(json.toString(3));
			}

			cjmForm.setExp2ViListJSON(json.toString());
			// TODO
			if (exp2ViListMap.isEmpty()) {
				cjmForm.setHasData(false);

			} else {
				cjmForm.setHasData(true);
				IDBCache dbCache = ServiceFactory.getDBCache(dbID);
				List<Experiment> experiments = dbCache.getExperiments(ui, true);
				List<Experiment> usedExpList = new ArrayList<Experiment>(
						experiments.size());
				for (Experiment exp : experiments) {
					if (exp2ViListMap.containsKey(exp.getName())) {
						usedExpList.add(exp);
					}
				}

				SubjectExperimentsSelector expSelector = new SubjectExperimentsSelector(
						usedExpList);
				cjmForm.setExpSelector(expSelector);

			}
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("viewMain", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward submitJob(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> submitJob");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			CBFJobManForm cjmForm = (CBFJobManForm) form;

			cjmForm.setDoFieldMapCorrection(false);
			cjmForm.setDoSense(false);
			String paramValue = request.getParameter("preproc");
			System.out.println("preproc:" + paramValue);
			if (paramValue != null && paramValue.equals("doFieldMapCorrection")) {
				cjmForm.setDoFieldMapCorrection(true);
			}

			if (paramValue != null && paramValue.equals("doSense")) {
				cjmForm.setDoSense(true);
			}
			paramValue = request.getParameter("doReg");
			if (paramValue != null) {
				cjmForm.setDoReg(true);
			} else {
				cjmForm.setDoReg(false);
			}
			paramValue = request.getParameter("doSkullStripping");
			if (paramValue != null) {
				cjmForm.setDoSkullStripping(true);
			} else {
				cjmForm.setDoSkullStripping(false);
			}

			paramValue = request.getParameter("doAutoCSF");
			cjmForm.setUseAutomatedSegmentation(paramValue != null);

			paramValue = request.getParameter("doPVC");
			cjmForm.setDoPartialVolumeCorrection(paramValue != null);

			paramValue = request.getParameter("align");
			if (paramValue != null) {
				cjmForm.setAlignment(GenUtils.toInt(paramValue, 3));
			} else {
				cjmForm.setAlignment(3);
			}

			paramValue = request.getParameter("csfMethod");
			if (paramValue != null) {
				cjmForm.setCsfMethod(GenUtils.toInt(paramValue,
						CBFWFContext.PVM));
			} else {
				cjmForm.setCsfMethod(CBFWFContext.PVM);
			}

			paramValue = request.getParameter("ltMethod");
			cjmForm.setUseLTMethod(paramValue != null);

			if (cjmForm.getGaussianFilterParam() == null) {
				cjmForm.setGaussianFilterParam("4.0");
			} else {
				cjmForm.setGaussianFilterParam(String.valueOf(GenUtils
						.toDouble(cjmForm.getGaussianFilterParam(), 4.0)));
			}

			System.out
					.println("skullStripping:" + cjmForm.isDoSkullStripping());
			System.out.println("gmThreshold:" + cjmForm.getGmThreshold());
			System.out.println("doReg:" + cjmForm.isDoReg());
			System.out.println("doAutoCSF:"
					+ cjmForm.isUseAutomatedSegmentation());
			System.out
					.println("doPVC:" + cjmForm.isDoPartialVolumeCorrection());
			System.out.println("align:" + cjmForm.getAlignment());
			System.out.println("csfMethod:" + cjmForm.getCsfMethod());
			System.out.println("ltMethod:" + cjmForm.isUseLTMethod());
			System.out.println("gaussianFilterParam:"
					+ cjmForm.getGaussianFilterParam());

			String[] values = request.getParameterValues("viSelector");
			if (values != null && values.length > 0) {
				for (int i = 0; i < values.length; i++) {
					System.out.println("VisitInfo: " + values[i]);
				}
			}
			String visitInfo = values[0];
			VisitInfo selVI = getSelectedVisitInfo(cjmForm, visitInfo);

			Assertion.assertNotNull(selVI);

			ICBFWFManagementService cbfService = ServiceFactory
					.getCBFWFManagementService(dbID);

			List<VisitInfo> viList = new ArrayList<VisitInfo>(1);
			viList.add(selVI);
			// remove partially loaded segment data list for full segment info
			// retrieval
			selVI.getSiList().clear();

			List<VisitInfo> visitInfosWithScans = cbfService
					.getVisitInfosWithScans(ui, viList);
			// prepare visitInfos and job context , submit matlab job

			String id = String.valueOf(System.currentTimeMillis());
			String description = "CBF processing for '" + visitInfo + "'";

			IAppConfigService configService = ServiceFactory
					.getAppConfigService();

			String cacheRoot = configService
					.getParamValue("download.cacheroot");
			if (cacheRoot == null || cacheRoot.trim().length() == 0) {
				throw new ValidationException(
						"System Setup Problem: A valid cache root directory needs to be supplied "
								+ "during system setup with property download.cacheroot:! ");
			}

			String matlabDir = configService
					.getParamValue("cbfbirn.matlab.dir");
			if (matlabDir == null || matlabDir.trim().length() == 0) {
				throw new ValidationException(
						"System Setup Problem: A valid MATLAB source directory for CBF processing "
								+ "needs to be supplied "
								+ "during system setup with property cbfbirn.matlab.dir:! ");
			}

			String workDir = visitInfo + "_" + id;
			File cacheDir = new File(cacheRoot, workDir);
			if (!cacheDir.mkdirs()) {
				log.error("Cannot create cacheDir:" + cacheDir);
				throw new ValidationException(
						"A problem occured during job submission setup!");
			}

			String templateDir = super.servlet.getServletContext().getRealPath(
					Constants.TEMPLATE_DIR);

			double gmThreshold = GenUtils.toDouble(cjmForm.getGmThreshold(),
					0.9);

			// placeholder used for recoverable jobs (jobs that were at waiting
			// state while a server crash).
			List<VisitProcessInfo> vpiList = new ArrayList<VisitProcessInfo>(1);

			CBFWFContext ctx = new CBFWFContext(dbID,
					cjmForm.isDoFieldMapCorrection(),
					cacheDir.getAbsolutePath(), visitInfosWithScans,
					cjmForm.isDoSense(), cjmForm.isDoReg(),
					cjmForm.isDoSkullStripping(), gmThreshold, vpiList, id);
			ctx.setUseAutomatedSegmentation(cjmForm
					.isUseAutomatedSegmentation());
			ctx.setDoPartialVolumeCorrection(cjmForm
					.isDoPartialVolumeCorrection());
			ctx.setAlignment(cjmForm.getAlignment());
			ctx.setCsfMethod(cjmForm.getCsfMethod());

			ctx.setUseLTMethod(cjmForm.isUseLTMethod());
			ctx.setGaussianFilterParam(GenUtils.toDouble(
					cjmForm.getGaussianFilterParam(), 4.0));

			// for DEBUGGING
			// File serFile = new
			// File(System.getProperty("user.home"),"CBFWFContext.ser");
			// FileUtils.serialize(ctx, serFile.getAbsolutePath());
			// end for DEBUGGING

			DBConfig dbConfig = ServiceFactory.getSecurityAdminService()
					.getDBConfigMap().get(dbID);
			User user = dbConfig.findUser(ui.getName());

			if (user.getEmail() == null) {
				ISecurityService secService = ServiceFactory
						.getSecurityService();
				String email = secService.getEmail(ui.getName());
				user.setEmail(email);
			}

			System.out.println("CBFJobManAction:: emailTo:" + user.getEmail());

			ctx.setTemplateDir(templateDir);
			ctx.setMatlabDir(matlabDir);
			ctx.setEmailTo(user.getEmail());

			// depending on the scanner type decide on the processing job class
			IJob job = null;
			VisitInfo vi = visitInfosWithScans.get(0);

			boolean uclaData = hasAnalyzeSeries(vi);

			if (vi.getScannerType().equalsIgnoreCase(CBFBIRNConstants.SIEMENS)) {
				if (!uclaData) {
					job = new SiemensCBFProcessingJob(id, ui, description, ctx,
							templateDir, matlabDir, user.getEmail());
				} else {
					// UCLA data
					job = new UCLACBFProcessingJob(id, ui, description, ctx,
							templateDir, matlabDir, user.getEmail(), null);
				}
			} else {

				job = new CBFProcessingJob(id, ui, description, ctx,
						templateDir, matlabDir, user.getEmail());
			}
			// schedule job
			JobScheduler scheduler = JobScheduler.getInstance();
			scheduler.addJob(job, JobSubmissionType.INDIVIDUAL);

			cjmForm.setSubmittedJobId(id);
			cjmForm.setSubmittedSubjectId(selVI.getSubjectID());

			return mapping.findForward(Constants.SUBMITTED);
		} catch (Exception x) {
			log.error("submitJob", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	private boolean hasAnalyzeSeries(VisitInfo vi) {
		for (SegmentInfo si : vi.getSiList()) {
			if (si.getShi().getImageType().equals(SeriesHeaderInfo.ANALYZE)) {
				return true;
			}
		}
		return false;
	}

	private VisitInfo getSelectedVisitInfo(CBFJobManForm cjmForm,
			String visitInfo) {
		int idx = visitInfo.lastIndexOf('_');
		Assertion.assertTrue(idx != -1);
		String selSubjectID = visitInfo.substring(0, idx);
		int selVisitID = GenUtils.toInt(visitInfo.substring(idx + 1), -1);

		String selExpName = cjmForm.getExpSelector()
				.getSelectedExperimentName();
		List<VisitInfo> viList = cjmForm.getExp2ViListMap().get(selExpName);
		VisitInfo selVI = null;
		for (VisitInfo vi : viList) {
			if (vi.getSubjectID().equals(selSubjectID)
					&& vi.getVisitId() == selVisitID) {
				selVI = vi;
				break;
			}
		}
		return selVI;
	}

}
