package clinical.web.actions;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.web.CBFBIRNConstants;
import clinical.web.Constants;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;
import clinical.web.services.IJobProvenanceService;
import clinical.web.vo.JobProvenanceInfo;
import clinical.web.vo.JobProvenanceInfo.JobProvenanceParamInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class CBFQualityRatingAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(5);
	private Log log = LogFactory.getLog(CBFQualityRatingAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("action.rating.cbf.save", "saveCBFQuality");
		map.put("action.cprq.segmentation.save", "saveSegmentationQuality");
		map.put("action.rating.cbf.load", "loadCBFQuality");
		map.put("action.cprq.segmentation.load", "loadSegmentationQuality");
		return map;
	}

	public ActionForward loadCBFQuality(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			log.info(">> loadCBFQuality");
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String jobUniqueID = request.getParameter("juid");
			log.info("jobUniqueID:" + jobUniqueID);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			IJobProvenanceService jps = ServiceFactory
					.getJobProvenanceService(dbID);

			List<JobProvenanceInfo> jpiList = jps.findJobProvenancesByJobUniqueID(ui,
					new BigDecimal(jobUniqueID));
			if (jpiList != null) {
				JobProvenanceInfo jpi = jpiList.get(0);
				
				JSONObject json = qualityProvenanceParamsToJSON(jpi);
				String jsonStr = json.toString();
				log.info("cbfQuality:" + json.toString(2));
				response.setContentType("application/json");
                response.getOutputStream().println(jsonStr);
			} else {
				response.setContentType("application/json");
                response.getOutputStream().println("{}");
			}

		} catch (Exception x) {
			log.error("Error in loadCBFQuality", x);
			throw new BaseException(x.getMessage());
		}
		return null;
	}
	
	public ActionForward loadSegmentationQuality(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			log.info(">> loadSegmentationQuality");
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String jobUniqueID = request.getParameter("juid");
			log.info("jobUniqueID:" + jobUniqueID);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			IJobProvenanceService jps = ServiceFactory
					.getJobProvenanceService(dbID);

			List<JobProvenanceInfo> jpiList = jps.findJobProvenancesByJobUniqueID(ui,
					new BigDecimal(jobUniqueID));
			if (jpiList != null) {
				JobProvenanceInfo jpi = jpiList.get(0);
				JSONObject json = segQualityParams2JSON(jpi);
				String jsonStr = json.toString();
				log.info("segmentationQuality:" + json.toString(2));
				response.setContentType("application/json");
                response.getOutputStream().println(jsonStr);
			} else {
				response.setContentType("application/json");
                response.getOutputStream().println("{}");
			}

		} catch (Exception x) {
			log.error("Error in loadSegmentationQuality", x);
			throw new BaseException(x.getMessage());
		}
		return null;
	}

	public ActionForward saveCBFQuality(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			log.info(">> saveCBFQuality");
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String qualityJSON = request.getParameter("qualityInfo");
			String jobUniqueID = request.getParameter("juid");

			log.info("qualityInfo:" + qualityJSON);
			log.info("jobUniqueID:" + jobUniqueID);

			JSONObject json = new JSONObject(qualityJSON);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			String rating = json.getString("rating");
			String userComment = null;
			String reasons = null;
			if (json.has("userComment")) {
				userComment = json.getString("userComment").trim();
				if (userComment.length() == 0) {
					userComment = null;
				}
			}
			if (json.has("reasons")) {
				JSONArray jsArr = json.getJSONArray("reasons");
				if (jsArr != null && jsArr.length() > 0) {
					reasons = combineReasons(jsArr);
				}
			}
			IJobProvenanceService jps = ServiceFactory
					.getJobProvenanceService(dbID);
			List<JobProvenanceParamInfo> jpiList = new ArrayList<JobProvenanceParamInfo>(
					3);

			JobProvenanceParamInfo jppi = new JobProvenanceParamInfo(
					CBFBIRNConstants.CBF_PROC_QUALITY_RATING_NAME, rating);
			jpiList.add(jppi);
			if (reasons != null) {
				jppi = new JobProvenanceParamInfo(
						CBFBIRNConstants.CBF_PROC_QUALITY_REASONS_NAME, reasons);
				jpiList.add(jppi);
			}
			if (userComment != null) {
				jppi = new JobProvenanceParamInfo(
						CBFBIRNConstants.CBF_PROC_QUALITY_COMMENT_NAME,
						userComment);
				jpiList.add(jppi);
			}

			jps.addUpdateProvenanceParams(ui, new Integer(jobUniqueID), jpiList);

		} catch (Exception x) {
			log.error("Error in saveCBFQuality", x);
			throw new BaseException(x.getMessage());
		}
		return null;
	}
	
	
	public ActionForward saveSegmentationQuality(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			log.info(">> saveSegmentationQuality");
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String qualityJSON = request.getParameter("qualityInfo");
			String jobUniqueID = request.getParameter("juid");

			log.info("qualityInfo:" + qualityJSON);
			log.info("jobUniqueID:" + jobUniqueID);

			JSONObject json = new JSONObject(qualityJSON);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			String rating = json.getString("rating");
			String reasons = null;
			if (json.has("reasons")) {
				JSONArray jsArr = json.getJSONArray("reasons");
				if (jsArr != null && jsArr.length() > 0) {
					reasons = combineReasons(jsArr);
				}
			}

			IJobProvenanceService jps = ServiceFactory
					.getJobProvenanceService(dbID);

			List<JobProvenanceParamInfo> jpiList = new ArrayList<JobProvenanceParamInfo>(
					2);
			JobProvenanceParamInfo jppi = new JobProvenanceParamInfo(
					CBFBIRNConstants.SEG_QUALITY_RATING_NAME, rating);
			jpiList.add(jppi);
			if (reasons != null) {
				jppi = new JobProvenanceParamInfo(
						CBFBIRNConstants.SEG_QUALITY_REASONS_NAME, reasons);
				jpiList.add(jppi);
			}
			jps.addUpdateProvenanceParams(ui, new Integer(jobUniqueID), jpiList);
			
		} catch (Exception x) {
			log.error("Error in saveSegmentationQuality", x);
			throw new BaseException(x.getMessage());
		}
		return null;
	}

	private String combineReasons(JSONArray jsArr) throws JSONException {
		StringBuilder sb = new StringBuilder(256);
		for (int i = 0; i < jsArr.length(); i++) {
			if (i > 0) {
				sb.append('|');
			}
			sb.append(jsArr.getString(i));
		}
		return sb.toString();
	}

	private JSONObject qualityProvenanceParamsToJSON(JobProvenanceInfo jpi)
			throws JSONException {
		JSONObject json = new JSONObject();
		for (JobProvenanceParamInfo jppi : jpi.getParams()) {
			String name = jppi.getName();
			if (name.equals(CBFBIRNConstants.CBF_PROC_QUALITY_RATING_NAME)) {
				json.put("rating", jppi.getValue());
			} else if (name
					.equals(CBFBIRNConstants.CBF_PROC_QUALITY_COMMENT_NAME)) {
				json.put("comments", jppi.getValue());
			} else if (name
					.equals(CBFBIRNConstants.CBF_PROC_QUALITY_REASONS_NAME)) {
				String[] values = jppi.getValue().split("\\|");
				JSONArray jsArr = new JSONArray();
				json.put("reasons", jsArr);
				for (String reason : values) {
					jsArr.put(reason);
				}
			}
		}
		return json;
	}
	
	
	private JSONObject segQualityParams2JSON(JobProvenanceInfo jpi)
			throws JSONException {
		JSONObject json = new JSONObject();
		for (JobProvenanceParamInfo jppi : jpi.getParams()) {
			String name = jppi.getName();
			if (name.equals(CBFBIRNConstants.SEG_QUALITY_RATING_NAME)) {
				json.put("rating", jppi.getValue());
			}  else if (name
					.equals(CBFBIRNConstants.SEG_QUALITY_REASONS_NAME)) {
				String[] values = jppi.getValue().split("\\|");
				JSONArray jsArr = new JSONArray();
				json.put("reasons", jsArr);
				for (String reason : values) {
					jsArr.put(reason);
				}
			}
		}
		return json;
	}
}
