package clinical.web.actions;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.exolab.castor.xml.ValidationException;
import org.json.JSONArray;
import org.json.JSONObject;

import clinical.server.vo.Experiment;
import clinical.server.vo.GroupAnalysisData;
import clinical.utils.FileUtils;
import clinical.web.CBFBIRNConstants;
import clinical.web.Constants;
import clinical.web.IAppConfigService;
import clinical.web.ISubjectVisitManagement;
import clinical.web.ServiceFactory;
import clinical.web.common.IAuthorizationService;
import clinical.web.common.IAuthorizationService.PrivilegeLabel;
import clinical.web.common.UserInfo;
import clinical.web.common.vo.GroupCBFReportRec;
import clinical.web.common.vo.GroupCBFReportRec.GAResult;
import clinical.web.download.FileBundleConfig;
import clinical.web.download.Packager;
import clinical.web.download.PathWrapper;
import clinical.web.forms.AsQueryBuilderForm;
import clinical.web.helpers.MultipleGAJobTypeSelector;
import clinical.web.services.IGroupCBFReportQueryService;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class GroupAnalysisReportQueryAction extends BaseLookupDispatchAction {
	private final Map<String, String> map = new HashMap<String, String>(5);
	private Log log = LogFactory.getLog(GroupAnalysisReportQueryAction.class);
	public static final String REL_REPORT_IMAGES_PATH = "/report/";

	@Override
	protected Map<String, String> getKeyMethodMap() {
		map.put("action.garq.show", "show");
		map.put("action.garq.query", "query");
		map.put("action.garq.download", "download");
		return map;
	}

	public ActionForward show(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			getUserInfo(request);
			AsQueryBuilderForm asForm = (AsQueryBuilderForm) form;
			prepareJobTypeSelector(asForm);

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward download(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			log.info("download");
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			String jobID = request.getParameter("selJobID");
			log.info("jobID:" + jobID);

			// double check if the group analysis job is visible by the
			// user
			IAuthorizationService authService = ServiceFactory
					.getAuthorizationService();
			if (!authService.isAuthorized(ui, dbID,
					PrivilegeLabel.CREATE_SUBJECT, null)
					&& !authService.isAuthorized(ui, dbID,
							PrivilegeLabel.UPDATE, null)
					&& !authService.isAuthorized(ui, dbID,
							PrivilegeLabel.ADMIN, null)
					&& !authService.isAuthorized(ui, dbID,
							PrivilegeLabel.UPDATE, null)) {
				throw new Exception("User '" + ui.getName()
						+ "' is unauthorized to download analysis results!");
			}

			IAppConfigService configService = ServiceFactory
					.getAppConfigService();
			String cacheRoot = configService
					.getParamValue("download.cacheroot");
			if (cacheRoot == null || cacheRoot.trim().length() == 0) {
				throw new ValidationException(
						"System Setup Problem: A valid cache root directory needs to be supplied "
								+ "during system setup with property download.cacheroot:! ");
			}

			IGroupCBFReportQueryService garqs = ServiceFactory
					.getGroupCBFReportQueryService(dbID);

			List<GroupAnalysisData> gadList = garqs
					.getGroupAnalysisDerivedData(ui, jobID);
			if (gadList.isEmpty()) {
				return null;
			}
			String jobRootDirName = new File(gadList.get(0).getDatauri())
					.getParentFile().getName();
			File cacheDir = null;
			String bundleName = null;
			if (jobRootDirName.startsWith("baseline_")) {
				bundleName = "Baseline_Analysis_" + jobID;
				cacheDir = new File(cacheRoot, "baseline_" + jobID);
			} else if (jobRootDirName.startsWith("roi_")) {
				bundleName = "ROI_Analysis_" + jobID;
				cacheDir = new File(cacheRoot, "roi_" + jobID);
			} else {
				bundleName = "Standard_Space_Analysis_" + jobID;
				cacheDir = new File(cacheRoot, "standard_" + jobID);
			}

			File tarFile = new File(cacheDir, bundleName + ".tar.gz");

			if (!cacheDir.isDirectory() || !tarFile.isFile()) {

				if (!cacheDir.isDirectory()) {
					cacheDir.mkdir();
				}
				List<PathWrapper> allFiles = new ArrayList<PathWrapper>(
						gadList.size());

				String srcRootDir = new File(gadList.get(0).getDatauri())
						.getParentFile().getAbsolutePath();
				for (GroupAnalysisData gad : gadList) {
					String datauURI = gad.getDatauri();
					String relativePath = FileUtils.getRelativePath(srcRootDir,
							datauURI);
					PathWrapper pw = new PathWrapper(relativePath, srcRootDir);
					allFiles.add(pw);
				}

				// final packaging
				Packager p = new Packager(cacheDir.getAbsolutePath(),
						bundleName, FileBundleConfig.GZIPPED);
				p.includeFiles(allFiles);
				p.pack();
			}

			// now stream the tar file
			log.info("streaming file to the browser:" + tarFile);

			response.setContentType("application/octet-stream");
			response.setHeader("Content-Disposition", "attachment; filename="
					+ tarFile.getName());
			// let's the browser to not cache this page
			response.setHeader("CACHE-CONTROL", "no-cache");
			response.setHeader("expires", "0");

			try {
				OutputStream os = response.getOutputStream();
				FileUtils.copyContent(tarFile.getAbsolutePath(), os);
			} finally {
				FileUtils.close(response.getOutputStream());
			}
			return null;
		} catch (Throwable t) {
			Exception x = (t instanceof Exception) ? (Exception) t
					: new Exception(t);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward query(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			log.info("query");
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			AsQueryBuilderForm asForm = (AsQueryBuilderForm) form;

			int[] selectedJobTypeIDs = asForm.getJobTypeSelector()
					.getSelectedJobTypeIDs();
			Set<String> includedJobTypeSet = new HashSet<String>(5);

			boolean allJobTypes = false;
			if (selectedJobTypeIDs == null || selectedJobTypeIDs.length == 0) {
				allJobTypes = true;
			} else {
				for (int i = 0; i < selectedJobTypeIDs.length; i++) {
					if (selectedJobTypeIDs[i] == MultipleGAJobTypeSelector.ALL_JOBTYPES) {
						allJobTypes = true;
						break;
					}
				}
			}
			if (!allJobTypes) {
				for (int i = 0; i < selectedJobTypeIDs.length; i++) {
					switch (selectedJobTypeIDs[i]) {
					case MultipleGAJobTypeSelector.BASELINE:
						includedJobTypeSet
								.add(CBFBIRNConstants.CBF_BASELINE_GROUP_ANALYSIS);
						break;
					case MultipleGAJobTypeSelector.NATIVE_ROI:
						includedJobTypeSet
								.add(CBFBIRNConstants.CBF_ROI_ANALYSIS);
						break;
					case MultipleGAJobTypeSelector.STANDARD_SPACE:
						includedJobTypeSet
								.add(CBFBIRNConstants.CBF_STANDARD_SPACE_ANALYSIS);
						break;
					}
				}
			}

			ISubjectVisitManagement isvm = ServiceFactory
					.getSubjectVisitManagement(dbID);
			List<Experiment> allVisibleExperiments = isvm
					.getAllVisibleExperiments(ui);

			IGroupCBFReportQueryService grqs = ServiceFactory
					.getGroupCBFReportQueryService(dbID);

			List<GroupCBFReportRec> recList = grqs.getGroupCBFRecords(ui,
					allVisibleExperiments, allJobTypes ? null
							: includedJobTypeSet);
			String cacheRoot = REL_REPORT_IMAGES_PATH;
			cacheRoot = session.getServletContext().getRealPath(cacheRoot);
			new File(cacheRoot).mkdirs();
			for (GroupCBFReportRec rec : recList) {
				if (!rec.getGaResults().isEmpty()) {
					for (GAResult gr : rec.getGaResults()) {
						if (gr.getType().equals("img")) {
							File cachedImg = prepCachedFile(cacheRoot,
									gr.getPath());
							String basePart = getBasePart(cachedImg, "report");
							gr.setPath(basePart);
						}
					}
				}
			}

			JSONObject js = new JSONObject();
			JSONArray recArr = new JSONArray();
			js.put("records", recArr);
			for (GroupCBFReportRec rec : recList) {
				recArr.put(rec.toJSON());
			}
			// log.info("GroupAnalysisReportQueryAction:: query:" +
			// js.toString(2));
			asForm.setGaProcRecordsJSONStr(js.toString());
			return mapping.findForward(Constants.FORWARD_RESULTS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	private void prepareJobTypeSelector(AsQueryBuilderForm queryForm) {
		MultipleGAJobTypeSelector jobTypeSelector = new MultipleGAJobTypeSelector();
		if (queryForm.getJobTypeSelector() != null) {
			int[] selectedJobTypeIDs = queryForm.getJobTypeSelector()
					.getSelectedJobTypeIDs();
			jobTypeSelector.setSelectedJobTypeIDs(selectedJobTypeIDs);
		}
		queryForm.setJobTypeSelector(jobTypeSelector);

	}

	private File prepCachedFile(String cacheRoot, String srcPath)
			throws IOException {
		File srcFile = new File(srcPath);
		String basePart = getBasePart(srcFile);
		File destFile = new File(cacheRoot, basePart);
		if (!destFile.getParentFile().exists()) {
			destFile.getParentFile().mkdirs();
			FileUtils.copyFile(srcPath, destFile.getAbsolutePath());
		} else {
			if (destFile.exists()) {
				if (srcFile.lastModified() > destFile.lastModified()) {
					FileUtils.copyFile(srcPath, destFile.getAbsolutePath());
				}
			} else {
				FileUtils.copyFile(srcPath, destFile.getAbsolutePath());
			}
		}

		return destFile;
	}

	static String getBasePart(File fullPath) {
		StringBuilder sb = new StringBuilder();
		sb.append(fullPath.getParentFile().getName());
		sb.append('/').append(fullPath.getName());
		return sb.toString();
	}

	static String getBasePart(File fullPath, String startPart) {
		// any spaces in startPart is converted to underscores
		if (startPart.indexOf(' ') != -1) {
			startPart = startPart.replaceAll("\\s+", "_");
		}
		String s = fullPath.getAbsolutePath();
		String[] parts = s.split("\\/+");
		int idx = -1;
		for (int i = 0; i < parts.length; i++) {
			if (parts[i].equals(startPart)) {
				idx = i;
				break;
			}
		}
		if (idx == -1) {
			return null;
		}
		StringBuilder sb = new StringBuilder(128);
		for (int i = idx; i < parts.length; i++) {
			sb.append(parts[i]);
			if ((i + 1) < parts.length) {
				sb.append("/");
			}
		}
		return sb.toString();
	}
}
