package clinical.web.actions;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.server.vo.Experiment;
import clinical.storage.IPlugin;
import clinical.storage.PluginManager;
import clinical.storage.StorageUtils;
import clinical.utils.Assertion;
import clinical.utils.BIRNURIException;
import clinical.utils.BIRNURIUtils;
import clinical.utils.FileUtils;
import clinical.web.Constants;
import clinical.web.IAppConfigService;
import clinical.web.IDerivedImageDataService;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.UserInfo;
import clinical.web.download.FileInfo;
import clinical.web.services.AppConfigService;
import clinical.web.vo.DerivedDataInfo;
import clinical.xml.ApplicationUtils;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileSystem;

/**
 * @author I. Burak Ozyurt
 * @version $Id: ImageUploadAction.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class ImageUploadAction extends Action {

	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		String dbID = null;
		IDBCache dbCache = null;
		try {
			System.out.println("in ImageUploadAction");
			dbID = getDBID();
			boolean isMultipart = ServletFileUpload.isMultipartContent(request);

			System.out.println("isMultipart:" + isMultipart);
			dbCache = ServiceFactory.getDBCache(dbID);

			ServletFileUpload upload = new ServletFileUpload();
			FileItemIterator iter = upload.getItemIterator(request);
			String webUser = null;
			String pwd = null;
			String projectID = null;
			Map<String, String> map = new HashMap<String, String>();
			// String[] params = new String[] { "webUser", "pwd", "projectID",
			// "subjectID", "visitID", "studyID", "episodeID",
			// "analysisShortName", "snapshotVersion" };

			UserInfo ui = null;
			IAppConfigService cs = AppConfigService.getInstance();
			
			String cacheRoot = cs.getParamValue("download.cacheroot");
			if (cacheRoot == null || !new File(cacheRoot).isDirectory()) {
				throw new Exception("Not a valid 'download.cacheroot' directory:"
						+ cacheRoot);
			}
			File workDir = new File(cacheRoot, "upload");
			if (!workDir.exists() || !workDir.isDirectory()) {
				boolean ok = workDir.mkdir();
				if (!ok) {
					throw new Exception("Cannot create directory:" + workDir);
				}
			}

			String localPath = null;
			String imageFilename = null;

			// TODO assumption ONLY one file to upload
			while (iter.hasNext()) {
				System.out.println("have item");
				FileItemStream item = iter.next();
				String fieldName = item.getFieldName();
				System.out.println("fieldName= " + fieldName);
				if (item.isFormField()) {
					String value = Streams.asString(item.openStream());
					map.put(fieldName, value);

				} else {
					webUser = map.get("webUser");
					pwd = map.get("pwd");

					ui = ApplicationUtils.authenticate(webUser, pwd, dbID);

					String filename = item.getName();
					System.out.println("filename=" + filename);
					BufferedInputStream in = null;
					BufferedOutputStream out = null;
					try {
						in = new BufferedInputStream(item.openStream(), 4096);
						localPath = new File(workDir, filename).getAbsolutePath();
						imageFilename = filename;

						out = new BufferedOutputStream(
								new FileOutputStream(localPath));
						int bytesRead = -1;
						byte[] buf = new byte[4096];
						while ((bytesRead = in.read(buf)) != -1) {
							out.write(buf, 0, bytesRead);
						}
					} finally {
						FileUtils.close(in);
						FileUtils.close(out);
					}
				}
			}
			
			webUser = map.get("webUser");
			pwd = map.get("pwd");
			projectID = map.get("projectID");

			Assertion.assertNotNull(webUser);
			Assertion.assertNotNull(pwd);
			if (ui == null) {
				ui = ApplicationUtils.authenticate(webUser, pwd, dbID);
			}

			List<Experiment> expList = dbCache.getExperiments(ui, false);
			Experiment theExp = findExperiment(projectID, expList);
			Assertion.assertNotNull(theExp);
			String storageType = theExp.getStoragetype();
			if (storageType == null) {
				storageType = cs.getParamValue("storage.type");
			}
			if (storageType == null)
				storageType = "local";

			String dataURI = null;		

			dataURI = store(map, localPath, imageFilename, theExp, false,
					storageType, ui, pwd);

			Assertion.assertNotNull(dataURI);

			if (map.containsKey("dd") && map.get("dd").equals(true)) {
				// also add a record to deriveddata table
				IDerivedImageDataService dids = ServiceFactory
						.getDerivedImageDataService(dbID);
				DerivedDataInfo ddi = prepareDerivedDataInfo(map, dataURI + "/"
						+ imageFilename);
				List<DerivedDataInfo> ddiList = new ArrayList<DerivedDataInfo>(1);
				ddiList.add(ddi);
				dids.addDerivedData(ui, ddiList);
			}

			return null;
		} catch (Exception x) {
			throw x;
		}
	}

	protected DerivedDataInfo prepareDerivedDataInfo(Map<String, String> map,
			String dataURI) {
		DerivedDataInfo ddi = new DerivedDataInfo();
		ddi.setDataURI(dataURI);
		ddi.setSubjectID(map.get("subjectID"));
		ddi.setExperimentID(new Integer(map.get("projectID")));
		ddi.setVisitID(new Integer(map.get("visitID")));
		ddi.setSegmentID(new Integer(map.get("episodeID")));
		ddi.setBad(false);
		ddi.setRaw(false);
		return ddi;
	}

	protected String storeLocally(Map<String, String> map, String localPath,
			String imageFilename, Experiment theExp) throws Exception {
		String existingURI = prepDataURI(theExp, map);
		File existingPath = new File(existingURI);
		Assertion.assertTrue(existingPath.exists() && existingPath.isDirectory());
		String analysisURI = prepAnalysisURI(existingURI, map);
		System.out.println("analysisURI =" + analysisURI);
		File anPath = new File(analysisURI);
		if (anPath.exists() || anPath.mkdirs()) {
			File imageFile = new File(anPath, imageFilename);
			System.out.println("imageFile=" + imageFile);
			FileUtils.copyFile(localPath, imageFile.getAbsolutePath());
		} else {
			throw new Exception("Cannot create directory: " + anPath);
		}
		return analysisURI;
	}

	protected String store(Map<String, String> map, String localPath,
			String imageFilename, Experiment theExp, boolean skip,
			String storageType, UserInfo ui, String pwd) throws Exception {
		String existingURI = prepDataURI(theExp, map);
		System.out.println("existingURI:" + existingURI);
		String analysisURI = null;
		IPlugin plugin = null;
		Map<String, Object> paramMap = new HashMap<String, Object>();
		try {
			analysisURI = prepAnalysisURI(existingURI, map);
			System.out.println("analysisURI =" + analysisURI);
			paramMap.put("cacheDir", localPath);

			if (!skip) {
				String uri = analysisURI + "/" + imageFilename;
				System.out.println("uri=" + uri);
				PluginManager pm = PluginManager.getInstance();

				if (storageType.equalsIgnoreCase(FileInfo.LOCAL_STR)) {
					plugin = pm.getPlugin(FileInfo.LOCAL_STR, paramMap);
				} else if (storageType.equalsIgnoreCase(FileInfo.GRIDFTP_STR)) {
					IAppConfigService acs = ServiceFactory.getAppConfigService();

					StorageUtils.prepareGridFtpPluginParams(acs, paramMap, ui
							.getName(), pwd);
					plugin = pm.getPlugin(FileInfo.GRIDFTP_STR, paramMap);
				} else if (storageType.equalsIgnoreCase(FileInfo.SRB_STR)) {
					plugin = pm.getPlugin(FileInfo.SRB_STR, paramMap);
				}
				plugin.startup();

				FileInfo localFi = new FileInfo(localPath, FileInfo.TAR,
						FileInfo.LOCAL, null, false);
				FileInfo remoteFi = new FileInfo(uri, FileInfo.TAR,
						FileInfo.GRIDFTP, null, false);
				plugin.put(localFi, remoteFi);

			}

		} finally {
			if (plugin != null) {
				plugin.shutdown();
			}
		}
		return analysisURI;
	}

	protected String storeInSRB(Map<String, String> map, String localPath,
			String imageFilename, Experiment theExp, boolean skip)
			throws Exception {
		String existingURI = prepDataURI(theExp, map);
		System.out.println("existingURI:" + existingURI);
		SRBFileSystem srbFileSystem = null;
		String analysisURI = null;
		try {
			srbFileSystem = new SRBFileSystem();
			SRBFile srbFile = new SRBFile(srbFileSystem, existingURI);
			Assertion.assertTrue(srbFile.exists() && srbFile.isDirectory());
			analysisURI = prepAnalysisURI(existingURI, map);
			System.out.println("analysisURI =" + analysisURI);
			if (!skip) {
				srbFile = new SRBFile(srbFileSystem, analysisURI);
				if (srbFile.exists() || srbFile.mkdirs()) {

					LocalFile lf = null;
					lf = new LocalFile(localPath);
					String uri = analysisURI + "/" + imageFilename;
					System.out.println("uri=" + uri);
					SRBFile srbF = new SRBFile(srbFileSystem, uri);
					// force overwrite on copy like the normal copy semantics
					lf.copyTo(srbF, true);
				} else {
					throw new Exception("Cannot create collection: " + srbFile);
				}
			}
		} finally {
			if (srbFileSystem != null) {
				try {
					srbFileSystem.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		return analysisURI;
	}

	public static Experiment findExperiment(String projectID,
			List<Experiment> expList) {
		for (Experiment exp : expList) {
			if (exp.getName().equals(projectID)) {
				return exp;
			}
		}
		return null;
	}

	public static String prepAnalysisURI(String uri, Map<String, String> paramMap) {
		String subjectID = paramMap.get("subjectID");
		String analysisShortName = paramMap.get("analysisShortName");
		String snapshotVersion = paramMap.get("snapshotVersion");
		StringBuffer buf = new StringBuffer(256);
		buf.append(uri).append("/Analysis/");
		// TODO which siteID?
		String siteID = subjectID.substring(0, 4);
		buf.append(analysisShortName).append("__");
		buf.append(siteID).append("__").append(snapshotVersion);
		return buf.toString();
	}

	public static String prepDataURI(Experiment exp, Map<String, String> paramMap)
			throws BIRNURIException {
		String subjectID = paramMap.get("subjectID");
		String visitID = paramMap.get("visitID");
		String studyID = paramMap.get("studyID");
		String episodeID = paramMap.get("episodeID");

		StringBuilder buf = new StringBuilder(256);
		String baseURI = exp.getBaseuri();

		if (Constants.USE_BIRN_URIS) {
			baseURI = BIRNURIUtils.getPath(baseURI);
		}

		buf.append(baseURI).append('/');
		buf.append(subjectID).append('/');
		String siteID = subjectID.substring(0, 4);
		String[] toks = visitID.split("__");
		// FIXME which siteID?
		buf.append(toks[0]).append("__").append(siteID);
		buf.append("__").append(toks[1]).append('/');
		buf.append(studyID).append('/');
		buf.append(episodeID);
		String uri = buf.toString();
		uri = uri.replaceAll("/+", "/");
		return uri;
	}

	protected String getDBID() throws Exception {
		IAppConfigService cs = AppConfigService.getInstance();
		String dbID = cs.getParamValue("fbirn.dbid");

		if (dbID == null || dbID.trim().length() == 0) {
			throw new Exception(
					"Cannot detect data source! Possible misconfiguration!");
		}
		return dbID;
	}

}
