package clinical.web.actions;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.server.vo.Humansubject;
import clinical.web.Constants;
import clinical.web.ISubjectVisitManagement;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.common.query.QueryUtils;
import clinical.web.common.query.SearchCriteria;
import clinical.web.common.query.SearchPredicate;
import clinical.web.common.query.SearchPredicateList;
import clinical.web.forms.SubjectVisitManagementForm;
import clinical.web.helpers.PropertyQueryPartInfo;
import clinical.web.vo.Subject;

/**
 *
 *
 * @author I. Burak Ozyurt
 * @version $Id: SubjectQueryAction.java 366 2011-05-05 20:06:27Z bozyurt $
 */

public class SubjectQueryAction extends BaseAction {
	private Log log = LogFactory.getLog(SubjectQueryAction.class);

	public SubjectQueryAction() {
	}

	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		ISubjectVisitManagement svm = null;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			svm = ServiceFactory.getSubjectVisitManagement(dbID);

			SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) session
					.getAttribute(Constants.SUBVISITMANAGEMENT_FORM_KEY);
			String action = svmForm.getCurrentAction();

			log.debug("*** SUBJECTQUERYACTION action=" + action);

			BeanInfo bi = Introspector.getBeanInfo(Subject.class, Object.class);

			SearchCriteria sc = prepareSearchCriteria(svmForm, bi);

			List<Humansubject> subjects = svm.getMatchingSubjects(ui, sc);
			List<Subject> summaryList = new ArrayList<Subject>(subjects.size());
			for (Humansubject hs : subjects) {
				Subject s = new Subject(hs);
				summaryList.add(s);
			}
			svmForm.setSubjectSummaryList(summaryList);

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}

	}

	private SearchCriteria prepareSearchCriteria(
			SubjectVisitManagementForm svmForm, BeanInfo bi) throws Exception {
		List<PropertyQueryPartInfo> queryParts = svmForm.getQueryParts();
		SearchPredicateList spList = new SearchPredicateList();
		int idx = 0;
		SearchPredicate prev = null;
		for (PropertyQueryPartInfo pqp : queryParts) {

			SearchPredicate.Range range = null;
			SearchPredicate sp = null;

			int relOp = pqp.getOperator();
			int spType = 0;

			PropertyDescriptor pd = getPropertyDescriptor(bi, pqp
					.getPropertyName());

			spType = QueryUtils.getSearchPredicateTypeForProperty(pd
					.getPropertyType());

			Object value = QueryUtils.convertToType(pqp.getRhs(), spType);
			Object attribute = pqp.getPropertyName();

			if (pqp.getLowBound() != null && pqp.getLowBound().length() > 0
					&& pqp.getUppBound() != null
					&& pqp.getUppBound().length() > 0) {
				Number lowBound = (Number) QueryUtils.convertToType(pqp
						.getLowBound(), spType);
				Number uppBound = (Number) QueryUtils.convertToType(pqp
						.getUppBound(), spType);

				range = new SearchPredicate.Range(lowBound, uppBound);
			}

			if (range == null) {
				sp = new SearchPredicate(attribute, value, relOp, spType);
			} else {
				sp = new SearchPredicate(attribute, range, relOp, spType);
			}
			if (prev == null) {
				spList.addSearchPredicate(sp, SearchPredicateList.NONE);
			} else {
				int logOp = getSelectedCombinator(idx, svmForm);
				spList.addSearchPredicate(sp, prev, logOp);
			}

			prev = sp;
			++idx;
		}
		return new SearchCriteria(spList);
	}

	private PropertyDescriptor getPropertyDescriptor(BeanInfo bi,
			String propertyName) {
		PropertyDescriptor[] pds = bi.getPropertyDescriptors();
		for (int i = 0; i < pds.length; i++) {
			if (pds[i].getName().equals(propertyName))
				return pds[i];
		}
		return null;
	}

	private int getSelectedCombinator(int idx, SubjectVisitManagementForm form) {
		String combStr = form.getCombinator(idx - 1);
		return (combStr.equals("AND")) ? SearchPredicateList.AND
				: SearchPredicateList.OR;
	}

}