package clinical.web.actions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.cache.CacheUtils;
import clinical.utils.Assertion;
import clinical.web.Constants;
import clinical.web.IUploadManagementService;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.forms.SynonymAdminForm;
import clinical.web.services.ICBFSearchService;
import clinical.web.services.SynonymExpansionService;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class SynonymAdminAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(7);
	private Log log = LogFactory.getLog(SynonymAdminAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("action.saman.view", "viewMain");
		map.put("action.saman.scorevals", "getDistinctScoreValues");
		map.put("action.saman.experiments", "getExperimentsUsingAssessment");
		return map;
	}

	public ActionForward viewMain(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			SynonymAdminForm saForm = (SynonymAdminForm) form;
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
			String primarySiteID = dbID2SiteIDMap.get(dbID);
			IUploadManagementService ums = ServiceFactory
					.getUploadManagementService(dbID);

			List<AssessmentSelectionInfo> asiList = ums.getAssessmentMetaData(
					ui, primarySiteID);
			for (java.util.Iterator<AssessmentSelectionInfo> it = asiList
					.iterator(); it.hasNext();) {
				AssessmentSelectionInfo asi = it.next();
				if (asi.getName().equalsIgnoreCase("subject information")) {
					it.remove();
				}
			}
			JSONObject asiListJSON = toJSON(asiList);
			saForm.setAsiListJSON(asiListJSON.toString());

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("viewMain", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward getExperimentsUsingAssessment(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> getExperimentsUsingAssessment");
		try {
			UserInfo ui = getUserInfo(request);
			String asID = request.getParameter("asID");
			Assertion.assertNotNull(asID);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			SynonymExpansionService ses = ServiceFactory
					.getSynonymExpansionService(dbID);

			JSONObject json = ses.getExperimentsUsingAssessment(ui, asID);
			response.setContentType("application/json");
			log.info("jsonStr:" + json.toString(2));
			response.getOutputStream().println(json.toString());

		} catch (Exception x) {
			log.error("getExperimentsUsingAssessment", x);
			response.setContentType("application/json");
			response.getOutputStream().println((new JSONObject()).toString());
		}
		return null;

	}

	public ActionForward getDistinctScoreValues(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> getDistinctScoreValues");
		try {
			UserInfo ui = getUserInfo(request);
			String asID = request.getParameter("asID");
			Assertion.assertNotNull(asID);
			String scoreName = request.getParameter("scoreName");
			Assertion.assertNotNull(scoreName);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			ICBFSearchService ss = ServiceFactory.getCBFSearchService(dbID);
			JSONObject json = ss.getDistinctScoreValues(ui, asID, scoreName);
			response.setContentType("application/json");
			log.info("jsonStr:" + json.toString());
			response.getOutputStream().println(json.toString());
		} catch (Exception x) {
			log.error("getDistinctScoreValues", x);
			response.setContentType("application/json");
			response.getOutputStream().println((new JSONObject()).toString());
		}
		return null;
	}

	protected JSONObject toJSON(List<AssessmentSelectionInfo> asiList)
			throws JSONException {
		JSONObject js = new JSONObject();
		JSONArray asiJSArr = new JSONArray();
		js.put("asiList", asiJSArr);
		if (asiList != null) {
			for (AssessmentSelectionInfo asi : asiList) {
				asiJSArr.put(asi.toJSON(new JSONObject()));
			}
		}
		return js;
	}

}
