package clinical.web.actions;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.cache.CacheUtils;
import clinical.server.vo.Experiment;
import clinical.server.vo.Site;
import clinical.utils.Assertion;
import clinical.web.Constants;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.ISecurityAdminService;
import clinical.web.common.UserInfo;
import clinical.web.common.security.DBConfig;
import clinical.web.common.security.User;
import clinical.web.common.security.User.PrivilegeExperiments;
import clinical.web.common.security.User.ProjectPrivilegeStatus;
import clinical.web.forms.DBConfigForm;
import clinical.web.forms.UserAndDBConfigForm;
import clinical.web.forms.UserConfigForm;
import clinical.web.helpers.DBConfigSelector;
import clinical.web.helpers.DbUserSelector;
import clinical.web.helpers.SiteSelector;
import clinical.web.helpers.StringListSelector;
import clinical.web.services.SecurityService;
import clinical.web.vo.ExperimentInfo;

/**
 * @author I. Burak Ozyurt
 * @version $Id: UserAndDBConfigAction.java,v 1.2 2007/12/27 01:46:43 bozyurt
 *          Exp $
 */
public class UserAndDBConfigAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(11);
	private Log log = LogFactory.getLog(UserAndDBConfigAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("button.dbconf.view", "viewMain");
		map.put("button.dbconf.remove.privs", "removePrivileges");
		map.put("button.dbconf.add.priv", "addPrivileges");
		map.put("button.dbconf.view.webuser", "viewAddEditWebUser");
		map.put("button.dbconf.view.dbuser", "viewAddEditDbUser");
		map.put("button.dbconf.view.db", "viewAddDatabase");
		map.put("button.dbconf.change.db", "changeDB");
		map.put("button.dbconf.remove.db", "removeDBConf");
		map.put("button.dbconf.remove.webuser", "removeWebUser");
		map.put("button.dbconf.save.priv", "savePrivileges");

		return map;
	}

	public ActionForward viewMain(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> viewMain");
		try {
			UserInfo ui = getUserInfo(request);
			UserAndDBConfigForm configForm = (UserAndDBConfigForm) form;
			ISecurityAdminService saService = ServiceFactory
					.getSecurityAdminService();

			// Use as read only!
			Map<String, DBConfig> configMap = saService.getDBConfigMap();
			List<DBConfig> dbConfList = new ArrayList<DBConfig>(configMap
					.values());
			DBConfigSelector selector = new DBConfigSelector(dbConfList);
			configForm.setDbConfigSelector(selector);

			DBConfig curDBConfig = configMap.get(configForm
					.getDbConfigSelector().getSelectedDBId());

			// make sure project privileges are synchronized
			((SecurityService) saService).refreshWebUserPrivileges(curDBConfig);

			configForm.setCurDBConfig(curDBConfig);
			configForm.setDbConfigs(dbConfList);
			configForm.setPrivileges(saService.getPrivileges());

			IDBCache dbCache = ServiceFactory.getDBCache(curDBConfig.getId());
			List<Experiment> experiments = dbCache.getExperiments(ui, false);
			List<ExperimentInfo> eiList = new ArrayList<ExperimentInfo>(
					experiments.size());
			for (Experiment exp : experiments) {
				ExperimentInfo ei = new ExperimentInfo();
				ei.setName(exp.getName());
				ei.setId(exp.getUniqueid().intValue());
				eiList.add(ei);
			}
			experiments = null;
			/*
			 * List<Privilege> ppList = new ArrayList<Privilege>(configForm
			 * .getPrivileges().size()); for (Privilege priv :
			 * configForm.getPrivileges()) { if (priv.isProjSpec())
			 * ppList.add(priv); } List<PrivilegeExperiments> peList = new
			 * ArrayList<PrivilegeExperiments>( ppList.size()); for (User
			 * webUser : curDBConfig.getWebUsers()) { for (Privilege priv :
			 * ppList) { List<ProjectPrivilegeStatus> ppStatusList = new
			 * ArrayList<ProjectPrivilegeStatus>( eiList.size());
			 * 
			 * for (ExperimentInfo ei : eiList) { ProjectPrivilegeStatus pps =
			 * new ProjectPrivilegeStatus(ei .getId(), false, ei.getName());
			 * ppStatusList.add(pps); } PrivilegeExperiments pe = new
			 * PrivilegeExperiments(priv .getName(), ppStatusList);
			 * peList.add(pe); } webUser.setPrivExperiments(peList); }
			 */
			configForm.setCurDBExperiments(eiList);

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("viewMain", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward savePrivileges(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> savePrivileges");
		try {
			getUserInfo(request);
			UserAndDBConfigForm configForm = (UserAndDBConfigForm) form;
			ISecurityAdminService saService = ServiceFactory
					.getSecurityAdminService();
			// Use as read only!
			Map<String, DBConfig> configMap = saService.getDBConfigMap();
			DBConfig curDBConfig = configMap.get(configForm
					.getDbConfigSelector().getSelectedDBId());
			String curWebUser = configForm.getCurWebUser();
			SecurityService ss = (SecurityService) saService;

			for (User webUser : curDBConfig.getWebUsers()) {
				if (webUser.getName().equals(curWebUser)) {
					for (PrivilegeExperiments pe : webUser.getPrivExperiments()) {
						StringBuilder sb = new StringBuilder();
						sb.append(webUser.getName()).append('.');
						sb.append(pe.getPrivilege()).append('.');
						String prefix = sb.toString();
						for (ProjectPrivilegeStatus pps : pe.getPpStatusList()) {
							String key = prefix + pps.getExpId();
							String value = request.getParameter(key);
							System.out.println(key + ": " + value);
							if (value != null && value.equals("on")) {
								pps.setGranted(true);
							} else {
								pps.setGranted(false);
							}
						}
					}
					// persist it also
					ss.saveProjectPrivileges(curDBConfig, webUser);
				}
			}

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("viewMain", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward viewAddEditWebUser(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> viewAddEditWebUser");
		try {
			getUserInfo(request);
			UserAndDBConfigForm configForm = (UserAndDBConfigForm) form;
			DBConfig dbConfig = configForm.getCurDBConfig();
			UserConfigForm ucForm = new UserConfigForm();
			ucForm.setDbConfig(dbConfig);
			ucForm.setUserType(UserConfigForm.WEBUSER);
			DbUserSelector selector = new DbUserSelector(dbConfig.getDbUsers());
			ucForm.setDbUserSelector(selector);

			request.getSession().setAttribute("usercForm", ucForm);
			String opType = configForm.getOpType();
			ucForm.setOpType(opType);
			if (opType.equals(UserAndDBConfigForm.EDIT_OP)) {
				User webUser = dbConfig.findUser(configForm.getCurWebUser());
				Assertion.assertNotNull(webUser);
				ucForm.setUserName(webUser.getName());
				ucForm.setPassword(webUser.getPwd());
				ucForm.setPasswordRepeat(webUser.getPwd());
				selector.setSelectedDBUserName(webUser.getDbUser().getName());
				if (webUser.isUseGSI()) {
					ucForm.setUseGSI("true");
				}
			}

			return mapping.findForward(Constants.EDIT_USER);
		} catch (Exception x) {
			log.error("viewAddEditWebUser", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward viewAddEditDbUser(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> viewAddEditDbUser");
		try {
			getUserInfo(request);
			UserAndDBConfigForm configForm = (UserAndDBConfigForm) form;
			DBConfig dbConfig = configForm.getCurDBConfig();
			UserConfigForm ucForm = new UserConfigForm();
			ucForm.setDbConfig(dbConfig);
			ucForm.setUserType(UserConfigForm.DBUSER);

			request.getSession().setAttribute("usercForm", ucForm);
			String opType = configForm.getOpType();
			ucForm.setOpType(opType);
			if (opType.equals(UserAndDBConfigForm.EDIT_OP)) {
				User dbUser = dbConfig.findDBUser(configForm.getCurDBUser());
				Assertion.assertNotNull(dbUser);
				ucForm.setDbUserName(dbUser.getName());
				ucForm.setPassword(dbUser.getPwd());
				ucForm.setPasswordRepeat(dbUser.getPwd());
			}

			return mapping.findForward(Constants.EDIT_USER);
		} catch (Exception x) {
			log.error("viewAddEditDbUser", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward removePrivileges(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> removePrivileges");
		try {
			getUserInfo(request);
			UserAndDBConfigForm configForm = (UserAndDBConfigForm) form;
			ISecurityAdminService saService = ServiceFactory
					.getSecurityAdminService();

			SecurityService ss = (SecurityService) saService;
			DBConfig curDBConfig = configForm.getCurDBConfig();
			String curWebUser = configForm.getCurWebUser();
			if (curWebUser != null) {
				List<String> privNames = new ArrayList<String>(2);
				Enumeration<?> en = request.getParameterNames();
				while (en.hasMoreElements()) {
					String name = (String) en.nextElement();
					// System.out.println("+++ >> " + name);
					if (name.startsWith(curWebUser)) {
						String privName = name.substring(name.indexOf('.',
								curWebUser.length()) + 1);
						privNames.add(privName);
					}
				}
				if (!privNames.isEmpty()) {
					ss.removePrivileges(curDBConfig, curWebUser, privNames);
				}
			}
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("removePrivileges", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward addPrivileges(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> addPrivileges");
		try {
			getUserInfo(request);
			UserAndDBConfigForm configForm = (UserAndDBConfigForm) form;
			ISecurityAdminService saService = ServiceFactory
					.getSecurityAdminService();

			SecurityService ss = (SecurityService) saService;
			DBConfig curDBConfig = configForm.getCurDBConfig();
			String curWebUser = configForm.getCurWebUser();
			if (curWebUser != null) {
				List<String> privNames = new ArrayList<String>(2);
				String[] values = request.getParameterValues(curWebUser
						+ ".privSelector");
				if (values != null && values.length > 0) {
					for (int i = 0; i < values.length; i++) {
						privNames.add(values[i]);
					}
					ss.addPrivileges(curDBConfig, curWebUser, privNames);
				}
			}
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("addPrivileges", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward viewAddDatabase(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> viewAddDatabase");
		try {
			getUserInfo(request);
			UserAndDBConfigForm configForm = (UserAndDBConfigForm) form;
			DBConfigForm dbcForm = new DBConfigForm();
			dbcForm.setDbTypeSelector(new StringListSelector(new String[] {
					"oracle", "postgres" }));
			dbcForm.setOpType(DBConfigForm.ADD);
			request.getSession().setAttribute("dconfForm", dbcForm);

			SecurityService ss = (SecurityService) ServiceFactory
					.getSecurityService();
			List<Site> allSites = ss.getAllSites();
			List<DBConfig> dbConfList = configForm.getDbConfigs();
			Map<String, DBConfig> dbcMap = new HashMap<String, DBConfig>(17);
			for (DBConfig config : dbConfList) {
				dbcMap.put(config.getSiteID(), config);
			}
			List<Site> availableSites = new ArrayList<Site>(10);
			for (Site site : allSites) {
				if (!dbcMap.containsKey(site.getSiteid())) {
					availableSites.add(site);
				}
			}
			SiteSelector selector = new SiteSelector(availableSites);
			dbcForm.setSiteSelector(selector);
			return mapping.findForward(Constants.EDIT_DB);
		} catch (Exception x) {
			log.error("viewAddDatabase", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward changeDB(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> changeDB");
		try {
			getUserInfo(request);
			UserAndDBConfigForm configForm = (UserAndDBConfigForm) form;
			String curDBId = configForm.getCurDB();
			DBConfig theDBConf = null;
			for (DBConfig dbConf : configForm.getDbConfigs()) {
				if (dbConf.getId().equals(curDBId)) {
					theDBConf = dbConf;
					break;
				}
			}
			if (theDBConf != null) {
				configForm.setCurDBConfig(theDBConf);
				ISecurityAdminService saService = ServiceFactory
						.getSecurityAdminService();
				// make sure project privileges are synchronized
				((SecurityService) saService)
						.refreshWebUserPrivileges(theDBConf);
			}

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("changeDB", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	@SuppressWarnings("unchecked")
	public ActionForward removeDBConf(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> removeDBConf");
		try {
			getUserInfo(request);
			UserAndDBConfigForm configForm = (UserAndDBConfigForm) form;
			ISecurityAdminService saService = ServiceFactory
					.getSecurityAdminService();

			SecurityService ss = (SecurityService) saService;
			DBConfig curDBConfig = configForm.getCurDBConfig();
			System.out.println("curDBConfig.isDefaultDB="
					+ curDBConfig.isDefaultDB() + " curDBConfig.id"
					+ curDBConfig.getId());
			if (!curDBConfig.isDefaultDB()) {
				ss.removeDatabase(curDBConfig);
				configForm.getDbConfigSelector().removeDbConfig(
						curDBConfig.getId());
				configForm.getDbConfigs().remove(curDBConfig);

				for (DBConfig dbc : configForm.getDbConfigs()) {
					if (dbc.isDefaultDB()) {
						configForm.setCurDBConfig(dbc);
						break;
					}
				}
				// also remove from the dbID2SiteIDMap
				CacheUtils.removeFromDBID2SiteIDMap(curDBConfig.getId());

				List<String> dbIDList = (List<String>) super.getServlet()
						.getServletContext().getAttribute(
								Constants.DBID_LIST_KEY);
				List<String> newDbIDList = new ArrayList<String>(dbIDList
						.size());
				for (String aDbId : dbIDList) {
					if (!curDBConfig.getId().equals(aDbId))
						newDbIDList.add(aDbId);
				}
				super.getServlet().getServletContext().setAttribute(
						Constants.DBID_LIST_KEY, newDbIDList);

			}
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("removeDBConf", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward removeWebUser(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> removeWebUser");
		try {
			getUserInfo(request);
			UserAndDBConfigForm configForm = (UserAndDBConfigForm) form;
			ISecurityAdminService saService = ServiceFactory
					.getSecurityAdminService();

			SecurityService ss = (SecurityService) saService;
			DBConfig curDBConfig = configForm.getCurDBConfig();
			String dbUserName = configForm.getCurDBUser();
			String webUserName = configForm.getCurWebUser();
			log.info("dbUserName=" + dbUserName + ", webUserName="
					+ webUserName);
			ss.removeWebUser(curDBConfig, webUserName);

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("removeWebUser", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}
}
