package clinical.web.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.server.vo.Experiment;
import clinical.utils.GenUtils;
import clinical.utils.ValidationUtils;
import clinical.web.Constants;
import clinical.web.IAppConfigService;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.ISecurityAdminService;
import clinical.web.common.UserInfo;
import clinical.web.common.security.DBConfig;
import clinical.web.common.security.User;
import clinical.web.common.security.User.PrivilegeExperiments;
import clinical.web.common.security.User.ProjectPrivilegeStatus;
import clinical.web.exception.AuthenticationException;
import clinical.web.exception.BaseException;
import clinical.web.exception.ValidationException;
import clinical.web.forms.UserManForm;
import clinical.web.forms.UserManForm.InviteInfo;
import clinical.web.forms.UserManForm.WebUser;
import clinical.web.helpers.DbUserSelector;
import clinical.web.helpers.EmailHelper;
import clinical.web.helpers.WebUserSelector;
import clinical.web.helpers.security.AuthorizationHelper;
import clinical.web.helpers.security.UserPrivilegeSet;
import clinical.web.services.SecurityService;
import clinical.web.vo.ExperimentInfo;

public class UserManagementAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(11);
	private Log log = LogFactory.getLog(UserManagementAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("button.userman.view", "viewMain");
		map.put("button.userman.view.add.user", "viewAddEditWebUser");
		map.put("button.userman.add.user", "addWebUser");
		map.put("button.userman.edit.user", "editWebUser");
		map.put("button.userman.add.priv", "addPrivileges");
		map.put("button.userman.remove.privs", "removePrivileges");
		map.put("button.userman.save.priv", "savePrivileges");
		map.put("button.userman.invite.user", "inviteUser");
		map.put("button.userman.show.invite.user", "showInviteUser");
		return map;
	}

	public ActionForward viewMain(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> viewMain");
		try {
			UserInfo ui = getUserInfo(request);
			UserManForm umForm = (UserManForm) form;
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			ISecurityAdminService saService = ServiceFactory
					.getSecurityAdminService();

			DBConfig dbConfig = saService.getDBConfigMap().get(dbID);

			// make sure project privileges are synchronized
			((SecurityService) saService).refreshWebUserPrivileges(dbConfig);

			umForm.setCurDB(dbID);
			umForm.setCurDBConfig(dbConfig);
			umForm.setPrivileges(saService.getPrivileges());
			umForm.setMasterUser(ui.getName());

			IDBCache dbCache = ServiceFactory.getDBCache(dbID);
			List<Experiment> experiments = dbCache.getExperiments(ui, false);
			List<ExperimentInfo> eiList = new ArrayList<ExperimentInfo>(
					experiments.size());
			for (Experiment exp : experiments) {
				ExperimentInfo ei = new ExperimentInfo();
				ei.setName(exp.getName());
				ei.setId(exp.getUniqueid().intValue());
				eiList.add(ei);
			}
			experiments = null;
			umForm.setCurDBExperiments(eiList);
			boolean canSendEmail = canSendEmail();
			for (User webUser : dbConfig.getWebUsers()) {
				prepareInviteInfo(umForm, canSendEmail, webUser);
			}

			if (umForm.getWebUserSelector() == null) {
				WebUserSelector wuSel = prepareWebUserSelector(umForm);
				umForm.setWebUserSelector(wuSel);
			}

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("viewMain", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	protected WebUserSelector prepareWebUserSelector(UserManForm umForm) {
		List<User> webUsers = new ArrayList<User>(umForm.getCurDBConfig()
				.getWebUsers());
		for (Iterator<User> it = webUsers.iterator(); it.hasNext();) {
			User wu = it.next();
			if (wu.getName().equals("admin")) {
				it.remove();
			} else if (umForm.getMasterUser() != null
					&& wu.getName().equals(umForm.getMasterUser())) {
				it.remove();
			}
		}
		Collections.sort(webUsers, new Comparator<User>() {
			public int compare(User o1, User o2) {
				return o1.getName().compareTo(o2.getName());
			}
		});
		WebUserSelector wuSel = new WebUserSelector(webUsers);
		return wuSel;
	}

	private void prepareInviteInfo(UserManForm umForm, boolean canSendEmail,
			User webUser) {
		InviteInfo ii = new InviteInfo();
		ii.setCanEmail(canSendEmail);
		if (!canSendEmail) {
			ii.setMessage("No email setup.");
		} else {
			if (!GenUtils.isValidEmail(webUser.getEmail())) {
				ii.setMessage("User has no valid email.");
				ii.setCanEmail(false);
			}
		}
		umForm.getInviteMap().put(webUser.getName(), ii);
	}

	public ActionForward viewAddEditWebUser(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> viewAddEditWebUser");
		try {
			getUserInfo(request);
			UserManForm umForm = (UserManForm) form;
			System.out.println("opType:" + umForm.getOpType() + "  curWebUser:"
					+ umForm.getCurWebUser());
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			ISecurityAdminService saService = ServiceFactory
					.getSecurityAdminService();
			DBConfig dbConfig = saService.getDBConfigMap().get(dbID);

			WebUser newUser = new WebUser();
			DbUserSelector selector = new DbUserSelector(dbConfig.getDbUsers());
			newUser.setDbUserSelector(selector);
			if (umForm.getOpType().equals(UserManForm.EDIT_OP)) {
				String curWebUser = umForm.getCurWebUser();
				User webUser = dbConfig.findUser(curWebUser);
				newUser.setEmail(webUser.getEmail());
				newUser.setUserName(webUser.getName());
				selector.setSelectedDBUserName(webUser.getDbUser().getName());
			}
			umForm.setNewUser(newUser);

			return mapping.findForward(Constants.EDIT_USER);
		} catch (Exception x) {
			log.error("viewAddEditWebUser", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward addWebUser(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> addWebUser");
		try {
			getUserInfo(request);
			UserManForm umForm = (UserManForm) form;
			WebUser newUser = umForm.getNewUser();
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			ISecurityAdminService saService = ServiceFactory
					.getSecurityAdminService();
			DBConfig dbConfig = saService.getDBConfigMap().get(dbID);

			String userName = newUser.getUserName();
			String pwd = newUser.getPassword();
			String pwdConfirm = newUser.getPasswordRepeat();
			String email = newUser.getEmail();
			String dbUserName = newUser.getDbUserSelector()
					.getSelectedDBUserName();
			User dbUser = dbConfig.findDBUser(dbUserName);
			validateFields(userName, pwd, pwdConfirm, email);

			// no GSI
			boolean useGSI = false;
			AuthorizationHelper helper = new AuthorizationHelper(dbID);
			// UserPrivilegeSet ups =
			// helper.prepareUserPrivileges(userName.trim(),
			// Constants.ADMIN_USER);
			UserPrivilegeSet ups = new UserPrivilegeSet(userName.trim());
			User webUser = new User(userName.trim(), pwd.trim(), ups, useGSI);
			webUser.setDbUser(dbUser);
			if (email != null && email.trim().length() > 0) {
				webUser.setEmail(email.trim());
			}

			SecurityService ss = (SecurityService) saService;
			ss.addWebUser(dbConfig, webUser);
			ups = helper.prepareUserPrivileges(userName.trim(),
					Constants.ADMIN_USER);
			webUser.setUserPrivSet(ups);

			boolean canSendEmail = canSendEmail();
			prepareInviteInfo(umForm, canSendEmail, webUser);

			WebUserSelector wuSel = prepareWebUserSelector(umForm);
			umForm.setWebUserSelector(wuSel);

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("addWebUser", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward editWebUser(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> editWebUser");
		try {
			getUserInfo(request);
			UserManForm umForm = (UserManForm) form;
			String curWebUser = umForm.getCurWebUser();
			if (curWebUser != null) {
				HttpSession session = request.getSession(false);
				String dbID = (String) session
						.getAttribute(Constants.SESSION_DBID_KEY);
				ISecurityAdminService saService = ServiceFactory
						.getSecurityAdminService();
				DBConfig dbConfig = saService.getDBConfigMap().get(dbID);

				WebUser newUser = umForm.getNewUser();
				String userName = newUser.getUserName();
				String pwd = newUser.getPassword();
				String pwdConfirm = newUser.getPasswordRepeat();
				String email = newUser.getEmail();
				validateFields(userName, pwd, pwdConfirm, email);

				User webUser = dbConfig.findUser(curWebUser);

				if (email != null && email.trim().length() > 0) {
					webUser.setEmail(email.trim());
				}
				webUser.setPwd(pwd);

				SecurityService ss = (SecurityService) saService;
				ss.editWebUser(dbConfig, webUser);

				boolean canSendEmail = canSendEmail();
				InviteInfo ii = umForm.getInviteMap().get(webUser.getName());
				ii.setHasError(false);
				ii.setCanEmail(canSendEmail);
				if (!canSendEmail) {
					ii.setMessage("No email setup.");
				} else {
					if (!GenUtils.isValidEmail(webUser.getEmail())) {
						ii.setMessage("User has no valid email.");
						ii.setCanEmail(false);
					}
				}

			}
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("addWebUser", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward showInviteUser(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> showInviteUser");
		UserManForm umForm = null;
		String curWebUser = null;
		try {
			getUserInfo(request);
			umForm = (UserManForm) form;
			curWebUser = umForm.getCurWebUser();
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			ISecurityAdminService saService = ServiceFactory
					.getSecurityAdminService();
			DBConfig dbConfig = saService.getDBConfigMap().get(dbID);
			User user = dbConfig.findUser(curWebUser);

			WebUser newUser = new WebUser();
			newUser.setUserName(curWebUser);
			newUser.setEmail(user.getEmail());
			umForm.setNewUser(newUser);
			return mapping.findForward("show_invite");
		} catch (Exception x) {
			log.error("showInviteUser", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward inviteUser(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> inviteUser");
		UserManForm umForm = null;
		String curWebUser = null;
		try {
			getUserInfo(request);
			umForm = (UserManForm) form;
			curWebUser = umForm.getCurWebUser();
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			ISecurityAdminService saService = ServiceFactory
					.getSecurityAdminService();
			DBConfig dbConfig = saService.getDBConfigMap().get(dbID);
			String templateDir = super.servlet.getServletContext().getRealPath(
					Constants.TEMPLATE_DIR);
			User webUser = dbConfig.findUser(curWebUser);
			User webUserCopy = new User(webUser.getName(), umForm.getNewUser()
					.getPassword(), null);
			webUserCopy.setEmail(umForm.getNewUser().getEmail());

			// check if password is correct
			String digest = GenUtils.getMD5Digest(webUserCopy.getPwd());
			System.out.println("entered pwd:" + webUserCopy.getPwd()
					+ " webUser.pwd:" + webUser.getPwd());
			System.out.println("digest:" + digest);
			if (!webUser.getPwd().equals(digest)) {
				throw new AuthenticationException("Incorrect Password!");
			}

			if (GenUtils.isNotEmpty(webUser.getEmail())
					&& GenUtils.isValidEmail(webUser.getEmail())) {
				String digestPwd = webUser.getPwd();
				handleEmail(templateDir, webUserCopy);
				SecurityService ss = (SecurityService) saService;
				webUserCopy.setInvited(true);
				webUserCopy.setPwd(null);
				webUserCopy.setDbUser(webUser.getDbUser());
				ss.editWebUser(dbConfig, webUserCopy);
				// restore MD5 digest of the password
				webUser.setPwd(digestPwd);
				InviteInfo ii = umForm.getInviteMap().get(curWebUser);
				ii.setHasError(false);
				ii.setMessage("");
			}
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			if (umForm != null && curWebUser != null) {
				InviteInfo ii = umForm.getInviteMap().get(curWebUser);
				ii.setMessage("Cannot send email.");
				ii.setHasError(true);
			}
			log.error("inviteUser", x);
			processExceptions(request, response, mapping, form, x);
			return mapping.findForward("invite_failure");
		}
	}

	public static boolean canSendEmail() throws BaseException {
		IAppConfigService configService = ServiceFactory.getAppConfigService();

		String emailHost = configService.getParamValue("email.host");
		// String emailUser = configService.getParamValue("email.user");
		String emailFrom = configService.getParamValue("email.from");
		boolean canSendEmail = GenUtils.hasEnoughInfoForEmail(emailHost, emailFrom);;
		return canSendEmail;
	}

	protected void handleEmail(String templateDir, User webUser)
			throws Exception {
		IAppConfigService configService = ServiceFactory.getAppConfigService();

		String emailHost = configService.getParamValue("email.host");
		String emailUser = configService.getParamValue("email.user");
		String emailPwd = configService.getParamValue("email.pwd");
		String emailFrom = configService.getParamValue("email.from");
		boolean canSendEmail = GenUtils.hasEnoughInfoForEmail(emailHost, emailFrom);
		
		
		if (canSendEmail) {
			EmailHelper helper = new EmailHelper(emailHost, emailUser,
					emailPwd, emailFrom);
			String toEmail = webUser.getEmail();
			String subject = "Invitation from CBFBIRN";
			Map<String, String> paramMap = new HashMap<String, String>();
			paramMap.put("email", toEmail);
			paramMap.put("username", webUser.getName());
			paramMap.put("pwd", webUser.getPwd());

			try {
				helper.sendEmail(toEmail, subject, paramMap, templateDir,
						"invite.vm", false);
			} catch (Throwable t) {
				log.error("sendEmail", t);
			}
		}
	}

	public ActionForward addPrivileges(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> addPrivileges");
		try {
			getUserInfo(request);
			UserManForm umForm = (UserManForm) form;
			ISecurityAdminService saService = ServiceFactory
					.getSecurityAdminService();

			SecurityService ss = (SecurityService) saService;
			DBConfig curDBConfig = umForm.getCurDBConfig();
			String curWebUser = umForm.getCurWebUser();
			if (curWebUser != null) {
				List<String> privNames = new ArrayList<String>(2);
				String[] values = request.getParameterValues(curWebUser
						+ ".privSelector");
				if (values != null && values.length > 0) {
					for (int i = 0; i < values.length; i++) {
						privNames.add(values[i]);
					}
					ss.addPrivileges(curDBConfig, curWebUser, privNames);
				}
			}
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("addPrivileges", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward savePrivileges(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> savePrivileges");
		try {
			getUserInfo(request);
			UserManForm configForm = (UserManForm) form;
			ISecurityAdminService saService = ServiceFactory
					.getSecurityAdminService();

			DBConfig curDBConfig = configForm.getCurDBConfig();
			String curWebUser = configForm.getCurWebUser();
			SecurityService ss = (SecurityService) saService;

			for (User webUser : curDBConfig.getWebUsers()) {
				if (webUser.getName().equals(curWebUser)) {
					for (PrivilegeExperiments pe : webUser.getPrivExperiments()) {
						StringBuilder sb = new StringBuilder();
						sb.append(webUser.getName()).append('.');
						sb.append(pe.getPrivilege()).append('.');
						String prefix = sb.toString();
						for (ProjectPrivilegeStatus pps : pe.getPpStatusList()) {
							String key = prefix + pps.getExpId();
							String value = request.getParameter(key);
							System.out.println(key + ": " + value);
							if (value != null && value.equals("on")) {
								pps.setGranted(true);
							} else {
								pps.setGranted(false);
							}
						}
					}
					// persist it also
					ss.saveProjectPrivileges(curDBConfig, webUser);
				}
			}
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("viewMain", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward removePrivileges(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> removePrivileges");
		try {
			getUserInfo(request);
			UserManForm umForm = (UserManForm) form;
			ISecurityAdminService saService = ServiceFactory
					.getSecurityAdminService();

			SecurityService ss = (SecurityService) saService;
			DBConfig curDBConfig = umForm.getCurDBConfig();
			String curWebUser = umForm.getCurWebUser();
			if (curWebUser != null) {
				List<String> privNames = new ArrayList<String>(2);
				Enumeration<?> en = request.getParameterNames();
				while (en.hasMoreElements()) {
					String name = (String) en.nextElement();
					if (name.startsWith(curWebUser)) {
						String privName = name.substring(name.indexOf('.',
								curWebUser.length()) + 1);
						privNames.add(privName);
					}
				}
				if (!privNames.isEmpty()) {
					ss.removePrivileges(curDBConfig, curWebUser, privNames);
				}
			}
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("removePrivileges", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	private void validateFields(String userName, String pwd, String pwdConfirm,
			String email) throws ValidationException {
		if (userName == null || userName.trim().length() == 0) {
			throw new ValidationException(
					"A non  empty user name needs to be specified!");
		}
		validateFields(pwd, pwdConfirm);
		if (email != null && email.trim().length() > 0) {
			ValidationUtils.validEmail("email", email);
		}
	}

	private void validateFields(String pwd, String pwdConfirm)
			throws ValidationException {
		if (pwd == null || pwd.trim().length() == 0) {
			throw new ValidationException(
					"A non empty password needs to be specified!");
		}
		if (pwdConfirm == null || pwdConfirm.trim().length() == 0
				|| !pwd.equals(pwdConfirm)) {
			throw new ValidationException(
					"Both password field and confirm password field contents must match!");
		}
	}
}
