package clinical.web.common.query;

import java.util.Collection;
import java.util.Date;

import org.apache.struts.util.LabelValueBean;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.web.vo.JobResultGroupInfo;
import clinical.web.vo.JobResultTypeInfo;
import clinical.web.vo.JobResultTypeInfo.ResultType;
import clinical.web.vo.RangeInfo;

public class JobResultQueryPartInfo extends AbstractQueryPartInfo {
	private static final long serialVersionUID = 1L;
	private JobResultGroupInfo jobResultGroup;
	private JobResultTypeInfo jobResultType;
	private RangeInfo rangeInfo;
	private String connector;
	public final static String NONE = "NONE";
	public final static String AND = "AND";
	public final static String OR = "OR";

	public JobResultQueryPartInfo() {
	}

	public JobResultQueryPartInfo(JobResultGroupInfo jobResultGroup,
			JobResultTypeInfo jobResultType) {
		super();
		this.jobResultGroup = jobResultGroup;
		this.jobResultType = jobResultType;
		prepareLogicalOps();
	}

	public JobResultQueryPartInfo(JobResultQueryPartInfo other) {
		super(other);
		this.jobResultGroup = other.jobResultGroup;
		this.jobResultType = other.jobResultType;
		this.rangeInfo = other.rangeInfo;
		this.connector = other.connector;
	}

	private void prepareLogicalOps() {
		if (jobResultType.getType() == ResultType.INT
				|| jobResultType.getType() == ResultType.FLOAT) {
			prepareNumericLogicalOps();
		} else if (jobResultType.getType() == ResultType.STRING) {
			prepareVarcharLogicalOps();
		} else {
			throw new RuntimeException(jobResultType.getType().toString()
					+ " is not a supported type!");
		}
	}

	public RangeInfo getRangeInfo() {
		return rangeInfo;
	}

	public void setRangeInfo(RangeInfo rangeInfo) {
		this.rangeInfo = rangeInfo;
	}

	public String getConnector() {
		return connector;
	}

	public String getFormattedRange() {
		return RangeInfo.getFormattedRange(rangeInfo);
	}

	@Override
	public Collection<LabelValueBean> getRhsEnums() {
		return rhsEnums;
	}

	/**
	 * converts this single variable query part to the corresponding
	 * {@link SearchPredicate} representation ignoring any logical connectives
	 * with other query parts
	 * 
	 * @return
	 */
	public SearchPredicate toSearchPredicate() {
		SearchPredicate.Range range = null;
		SearchPredicate sp = null;
		SearchPredicate.DateRange dateRange = null;
		int spType = QueryUtils.getSearchPredicateType(getJobResultType()
				.getType());
		int logOp = getOperator();
		if (getLowBound() != null && getLowBound().length() > 0
				&& getUppBound() != null && getUppBound().length() > 0) {
			Object v = QueryUtils.convertToType(getLowBound(), spType);
			if (v instanceof Date) {
				Date lowBound = (Date) v;
				Date uppBound = (Date) QueryUtils.convertToType(getUppBound(),
						spType);
				dateRange = new SearchPredicate.DateRange(lowBound, uppBound);
			} else {
				Number lowBound = (Number) QueryUtils.convertToType(
						getLowBound(), spType);
				Number uppBound = (Number) QueryUtils.convertToType(
						getUppBound(), spType);

				range = new SearchPredicate.Range(lowBound, uppBound);
			}
		}
		Object value = null;
		if (range == null && dateRange != null) {
			if (getRhs().trim().equals("*")) {
				value = getRhs().trim();
			} else {
				value = QueryUtils.convertToType(getRhs(), spType);
			}
		}
		Object attribute = getJobResultType();
		if (range != null) {
			sp = new SearchPredicate(attribute, range, logOp, spType);
		} else if (dateRange != null) {
			sp = new SearchPredicate(attribute, dateRange, logOp,
					spType);
		} else {
			sp = new SearchPredicate(attribute, value, logOp, spType);
		}

		return sp;
	}

	public JSONObject toJSON(JSONObject js) throws JSONException {
		js = super.toJSON(js);
		js.put("connector", connector);
		if (jobResultGroup != null) {
			js.put("jrgi", jobResultGroup.toJSON(new JSONObject()));
		}
		if (jobResultType != null) {
			js.put("resultType", jobResultType.toJSON(new JSONObject()));
		}
		return js;
	}

	public static JobResultQueryPartInfo initializeFromJSON(JSONObject js)
			throws JSONException {
		JobResultGroupInfo jobResultGroup = JobResultGroupInfo
				.initializeFromJSON(js.getJSONObject("jrgi"));
		JobResultTypeInfo jobResultType = JobResultTypeInfo
				.initializeFromJSON(js.getJSONObject("resultType"));
		JobResultQueryPartInfo qpi = new JobResultQueryPartInfo(jobResultGroup,
				jobResultType);
		qpi.operator = js.getInt("operator");
		if (js.has("lowBound") && js.has("uppBound")) {
			qpi.lowBound = js.getString("lowBound");
			qpi.uppBound = js.getString("uppBound");
		}
		if (js.has("rhs"))
			qpi.rhs = js.getString("rhs");

		qpi.connector = js.getString("connector");
		if (js.has("partIdx")) {
			qpi.partIdx = js.getInt("partIdx");
		}
		return qpi;
	}

	public JobResultGroupInfo getJobResultGroup() {
		return jobResultGroup;
	}

	public JobResultTypeInfo getJobResultType() {
		return jobResultType;
	}

	public void setConnector(String connector) {
		this.connector = connector;
	}

}
