package clinical.web.download;

import java.io.File;

import clinical.web.common.ICachePolicy;

/**
 * @author I. Burak Ozyurt
 * @version $Id: DownloadCachePolicy.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class DownloadCachePolicy implements ICachePolicy {
	protected long lowMarkSize;
	protected long initialUsableSpace;
	/**
	 * percentage of the initial usable space left acts as the low storage mark
	 */
	protected double lowMarkPercent = 25;
	/** in hours */
	protected int finishedLowAge = 48;
	protected int finishedNormalAge = 96;
	protected int downloadedNormalAge = 24;
	protected int downloadedLowAge = 12;

	protected static DownloadCachePolicy instance = null;

	protected DownloadCachePolicy(String cacheRoot) {
		initialUsableSpace = new File(cacheRoot).getUsableSpace();
		lowMarkSize = (long) (initialUsableSpace * (lowMarkPercent / 100.0));
	}

	public synchronized static DownloadCachePolicy getInstance(String cacheRoot) {
		if (instance == null) {
			instance = new DownloadCachePolicy(cacheRoot);
		}
		return instance;
	}

	public synchronized static ICachePolicy getInstance() {
		if (instance == null)
			throw new RuntimeException(
					"DownloadCachePolicy is not properly initialized!");
		return instance;
	}

	/* (non-Javadoc)
	 * @see clinical.web.download.ICachePolicy#getLowMarkPercent()
	 */
	public synchronized double getLowMarkPercent() {
		return lowMarkPercent;
	}

	public synchronized void setLowMarkPercent(double lowMarkPercent) {
		if (lowMarkPercent > 0 && lowMarkPercent < 100) {
			this.lowMarkPercent = lowMarkPercent;
			lowMarkSize = (long) (initialUsableSpace * (lowMarkPercent / 100.0));
		}
	}

	/* (non-Javadoc)
	 * @see clinical.web.download.ICachePolicy#getLowMarkSize()
	 */
	public synchronized long getLowMarkSize() {
		return lowMarkSize;
	}

	/* (non-Javadoc)
	 * @see clinical.web.download.ICachePolicy#isBelowLowMark(long)
	 */
	public synchronized boolean isBelowLowMark(long availableSpace) {
		return availableSpace <= lowMarkSize;
	}

	public synchronized int getFinishedLowAge() {
		return finishedLowAge;
	}

	public synchronized int getFinishedNormalAge() {
		return finishedNormalAge;
	}

	public synchronized int getDownloadedNormalAge() {
		return downloadedNormalAge;
	}

	public synchronized int getDownloadedLowAge() {
		return downloadedLowAge;
	}

	public synchronized void setFinishedLowAge(int finishedLowAge) {
		this.finishedLowAge = finishedLowAge;
	}

	public synchronized void setFinishedNormalAge(int finishedNormalAge) {
		this.finishedNormalAge = finishedNormalAge;
	}

	public synchronized void setDownloadedNormalAge(int downloadedNormalAge) {
		this.downloadedNormalAge = downloadedNormalAge;
	}

	public synchronized void setDownloadedLowAge(int downloadedLowAge) {
		this.downloadedLowAge = downloadedLowAge;
	}

}
