package clinical.web.forms;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.struts.action.ActionForm;

import clinical.web.helpers.SubjectExperimentsSelector;
import clinical.web.vo.upload.VisitInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */

public class CBFBatchJobManForm extends ActionForm {

	private CBFJobManForm wrapper;

	private Map<String, String> jobId2SubjectIdMap = new LinkedHashMap<String, String>();
	private static final long serialVersionUID = 1L;

	public CBFBatchJobManForm() {
		wrapper = new CBFJobManForm();
	}

	public String getGaussianFilterParam() {
		return wrapper.getGaussianFilterParam();
	}

	public boolean isUseLTMethod() {
		return wrapper.isUseLTMethod();
	}

	public void setGaussianFilterParam(String gaussianFilterParam) {
		wrapper.setGaussianFilterParam(gaussianFilterParam);
	}

	public void setSubmittedSubjectId(String submittedSubjectId) {
		wrapper.setSubmittedSubjectId(submittedSubjectId);
	}

	public void setUseLTMethod(boolean useLTMethod) {
		wrapper.setUseLTMethod(useLTMethod);
	}

	public String getExp2ViListJSON() {
		return wrapper.getExp2ViListJSON();
	}

	public Map<String, List<VisitInfo>> getExp2ViListMap() {
		return wrapper.getExp2ViListMap();
	}

	public SubjectExperimentsSelector getExpSelector() {
		return wrapper.getExpSelector();
	}

	public String getGmThreshold() {
		return wrapper.getGmThreshold();
	}

	public boolean isDoFieldMapCorrection() {
		return wrapper.isDoFieldMapCorrection();
	}

	public boolean isDoPartialVolumeCorrection() {
		return wrapper.isDoPartialVolumeCorrection();
	}

	public boolean isDoReg() {
		return wrapper.isDoReg();
	}

	public boolean isDoSense() {
		return wrapper.isDoSense();
	}

	public boolean isDoSkullStripping() {
		return wrapper.isDoSkullStripping();
	}

	public boolean isHasData() {
		return wrapper.isHasData();
	}

	public boolean isUseAutomatedSegmentation() {
		return wrapper.isUseAutomatedSegmentation();
	}

	public void setDoFieldMapCorrection(boolean doFieldMapCorrection) {
		wrapper.setDoFieldMapCorrection(doFieldMapCorrection);
	}

	public void setDoPartialVolumeCorrection(boolean doPartialVolumeCorrection) {
		wrapper.setDoPartialVolumeCorrection(doPartialVolumeCorrection);
	}

	public void setDoReg(boolean doReg) {
		wrapper.setDoReg(doReg);
	}

	public void setDoSense(boolean doSense) {
		wrapper.setDoSense(doSense);
	}

	public void setDoSkullStripping(boolean doSkullStripping) {
		wrapper.setDoSkullStripping(doSkullStripping);
	}

	public void setExp2ViListJSON(String exp2ViListJSON) {
		wrapper.setExp2ViListJSON(exp2ViListJSON);
	}

	public void setExp2ViListMap(Map<String, List<VisitInfo>> exp2ViListMap) {
		wrapper.setExp2ViListMap(exp2ViListMap);
	}

	public void setExpSelector(SubjectExperimentsSelector expSelector) {
		wrapper.setExpSelector(expSelector);
	}

	public void setGmThreshold(String gmThreshold) {
		wrapper.setGmThreshold(gmThreshold);
	}

	public void setHasData(boolean hasData) {
		wrapper.setHasData(hasData);
	}

	public void setUseAutomatedSegmentation(boolean useAutomatedSegmentation) {
		wrapper.setUseAutomatedSegmentation(useAutomatedSegmentation);
	}

	public void putSubmittedJobInfo(String jobID, String subjectID) {
		jobId2SubjectIdMap.put(jobID, subjectID);
	}

	public Map<String, String> getJobId2SubjectIdMap() {
		return jobId2SubjectIdMap;
	}

	public int getNumOfJobs() {
		return jobId2SubjectIdMap.size();
	}

	public void clearJobId2SubjectIdMap() {
		jobId2SubjectIdMap.clear();
	}

	public int getAlignment() {
		return wrapper.getAlignment();
	}

	public void setAlignment(int alignment) {
		wrapper.setAlignment(alignment);
	}

	public int getCsfMethod() {
		return wrapper.getCsfMethod();
	}

	public void setCsfMethod(int csfMethod) {
		wrapper.setCsfMethod(csfMethod);
	}

}
