package clinical.web.forms;

import java.util.List;
import java.util.Map;

import org.apache.struts.action.ActionForm;

import clinical.web.helpers.SubjectExperimentsSelector;
import clinical.web.vo.upload.VisitInfo;
import clinical.web.workflow.cbf.CBFWFContext;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: CBFJobManForm.java 823 2013-07-30 00:26:37Z bozyurt $
 */

public class CBFJobManForm extends ActionForm {
	private static final long serialVersionUID = 1L;
	private String exp2ViListJSON;
	/** true only if there are visits with data to process */
	private boolean hasData = false;
	private SubjectExperimentsSelector expSelector;
	private boolean doFieldMapCorrection = false;
	private boolean doSense = false;
	private boolean doReg = true;
	private boolean doSkullStripping = true;
	private String gmThreshold = "0.9";
	private boolean doPartialVolumeCorrection = false;
	private boolean useAutomatedSegmentation = false;
	private int alignment = 3;
	private int csfMethod = CBFWFContext.PVM;
	private boolean useLTMethod = false;
	private String gaussianFilterParam = "0.0";

	private Map<String, List<VisitInfo>> exp2ViListMap;
	private String submittedJobId;
	private String submittedSubjectId;

	public String getExp2ViListJSON() {
		return exp2ViListJSON;
	}

	public void setExp2ViListJSON(String exp2ViListJSON) {
		this.exp2ViListJSON = exp2ViListJSON;
	}

	public boolean isHasData() {
		return hasData;
	}

	public void setHasData(boolean hasData) {
		this.hasData = hasData;
	}

	public SubjectExperimentsSelector getExpSelector() {
		return expSelector;
	}

	public void setExpSelector(SubjectExperimentsSelector expSelector) {
		this.expSelector = expSelector;
	}

	public boolean isDoFieldMapCorrection() {
		return doFieldMapCorrection;
	}

	public void setDoFieldMapCorrection(boolean doFieldMapCorrection) {
		this.doFieldMapCorrection = doFieldMapCorrection;
	}

	public Map<String, List<VisitInfo>> getExp2ViListMap() {
		return exp2ViListMap;
	}

	public void setExp2ViListMap(Map<String, List<VisitInfo>> exp2ViListMap) {
		this.exp2ViListMap = exp2ViListMap;
	}

	public void setSubmittedJobId(String submittedJobId) {
		this.submittedJobId = submittedJobId;
	}

	public String getSubmittedJobId() {
		return submittedJobId;
	}

	public void setSubmittedSubjectId(String submittedSubjectId) {
		this.submittedSubjectId = submittedSubjectId;
	}

	public String getSubmittedSubjectId() {
		return submittedSubjectId;
	}

	public boolean isDoSense() {
		return doSense;
	}

	public void setDoSense(boolean doSense) {
		this.doSense = doSense;
	}

	public boolean isDoReg() {
		return doReg;
	}

	public void setDoReg(boolean doReg) {
		this.doReg = doReg;
	}

	public boolean isDoSkullStripping() {
		return doSkullStripping;
	}

	public void setDoSkullStripping(boolean doSkullStripping) {
		this.doSkullStripping = doSkullStripping;
	}

	public String getGmThreshold() {
		return gmThreshold;
	}

	public void setGmThreshold(String gmThreshold) {
		this.gmThreshold = gmThreshold;
	}

	public boolean isDoPartialVolumeCorrection() {
		return doPartialVolumeCorrection;
	}

	public void setDoPartialVolumeCorrection(boolean doPartialVolumeCorrection) {
		this.doPartialVolumeCorrection = doPartialVolumeCorrection;
	}

	public boolean isUseAutomatedSegmentation() {
		return useAutomatedSegmentation;
	}

	public void setUseAutomatedSegmentation(boolean useAutomatedSegmentation) {
		this.useAutomatedSegmentation = useAutomatedSegmentation;
	}

	public int getAlignment() {
		return alignment;
	}

	public void setAlignment(int alignment) {
		this.alignment = alignment;
	}

	public int getCsfMethod() {
		return csfMethod;
	}

	public void setCsfMethod(int csfMethod) {
		this.csfMethod = csfMethod;
	}

	public boolean isUseLTMethod() {
		return useLTMethod;
	}

	public void setUseLTMethod(boolean useLTMethod) {
		this.useLTMethod = useLTMethod;
	}

	public String getGaussianFilterParam() {
		return gaussianFilterParam;
	}

	public void setGaussianFilterParam(String gaussianFilterParam) {
		this.gaussianFilterParam = gaussianFilterParam;
	}

}
