package clinical.web.forms;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.struts.action.ActionForm;

import clinical.web.common.security.DBConfig;
import clinical.web.common.security.Privilege;
import clinical.web.common.security.User;
import clinical.web.helpers.DBConfigSelector;
import clinical.web.vo.ExperimentInfo;

/**
 * @author I. Burak Ozyurt
 * @version $Id: UserAndDBConfigForm.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class UserAndDBConfigForm extends ActionForm {
	protected List<DBConfig> dbConfigs;
	protected DBConfigSelector dbConfigSelector;
	protected DBConfig curDBConfig;
	protected List<Privilege> privileges;

	/**
	 * scratch variable used to indicate the name of the current web user for
	 * subsequent calls to the form object
	 */
	protected String curWebUser;
	protected String curDBUser;
	protected List<ExperimentInfo> curDBExperiments;
	protected Map<String, UserProjectPrivMatrixMan> ppMatrixManMap = new HashMap<String, UserProjectPrivMatrixMan>(
			17);

	/**
	 * either <code>ADD_OP</code> or <code>EDIT_OP</code>
	 */
	protected String opType;

	/** current database id */
	protected String curDB;

	public final static String ADD_OP = "add";
	public final static String EDIT_OP = "edit";

	private static final long serialVersionUID = 1L;

	public UserAndDBConfigForm() {
		super();
	}

	public List<DBConfig> getDbConfigs() {
		return dbConfigs;
	}

	public DBConfigSelector getDbConfigSelector() {
		return dbConfigSelector;
	}

	public DBConfig getCurDBConfig() {
		return curDBConfig;
	}

	public void setDbConfigs(List<DBConfig> dbConfigs) {
		this.dbConfigs = dbConfigs;
	}

	public void setDbConfigSelector(DBConfigSelector dbConfigSelector) {
		this.dbConfigSelector = dbConfigSelector;
	}

	public void setCurDBConfig(DBConfig curDBConfig) {
		this.curDBConfig = curDBConfig;
	}

	public List<Privilege> getPrivileges() {
		return privileges;
	}

	public void setPrivileges(List<Privilege> privileges) {
		this.privileges = privileges;
	}

	public List<Privilege> getRemainingPrivileges() {
		return null;
	}

	public String getCurWebUser() {
		return curWebUser;
	}

	public void setCurWebUser(String curWebUser) {
		this.curWebUser = curWebUser;
	}

	public String getOpType() {
		return opType;
	}

	public void setOpType(String opType) {
		this.opType = opType;
	}

	public String getCurDBUser() {
		return curDBUser;
	}

	public void setCurDBUser(String curDBUser) {
		this.curDBUser = curDBUser;
	}

	public String getCurDB() {
		return curDB;
	}

	public void setCurDB(String curDB) {
		this.curDB = curDB;
	}

	public List<ExperimentInfo> getCurDBExperiments() {
		return this.curDBExperiments;
	}

	public void setCurDBExperiments(List<ExperimentInfo> curDBExperiments) {
		this.curDBExperiments = curDBExperiments;
	}
	
	public Map<String, UserProjectPrivMatrixMan> getPpMatrixManMap() {
		List<User> webUsers = curDBConfig.getWebUsers();
		for (User webUser : webUsers) {
			String name = webUser.getName();
			UserProjectPrivMatrixMan uppMan = new UserProjectPrivMatrixMan(
					curDBExperiments, webUser);
			ppMatrixManMap.put(name, uppMan);
		}

		return ppMatrixManMap;
	}

	public static class DebugMap<K, V> extends HashMap<K, V> {
		private static final long serialVersionUID = 1L;

		@Override
		public V get(Object key) {
			System.out.println("KEY:" + key);
			return super.get(key);
		}

		@Override
		public boolean containsKey(Object key) {
			System.out.println("contains KEY:" + key);
			return super.containsKey(key);
		}

	}

	public static class ExpPrivIndicator {
		int id;

	}
}
