package clinical.web.game.forms;

import java.util.*;
import javax.servlet.http.*;
import java.text.*;

import org.apache.commons.logging.*;
import org.apache.struts.action.*;
import org.apache.struts.util.*;
/**
  *
  * @version $Id: BDIForm.java 366 2011-05-05 20:06:27Z bozyurt $
  * @author Generated by Clinical Assessment Layout Manager (CALM)
  */

public class BDIForm extends ActionForm {

    private String sadness= "";
    private String pessimism= "";
    private String senseOfFailure= "";
    private String dissatisfaction= "";
    private String guilty= "";
    private String punishment= "";
    private String selfDislike= "";
    private String selfBlame= "";
    private String suicidalThoughts= "";
    private String crying= "";
    private String irritability= "";
    private String socialWithdrawal= "";
    private String indecisiveness= "";
    private String changeInBodyImage= "";
    private String lossOfEnergy= "";
    private String insomnia= "";
    private String fatigue= "";
    private String decreasedAppetitie= "";
    private String lossOfWeight= "";
    private String somaticPreoccupation= "";
    private String lackOfInterestInSex= "";
    private String date = "";
    private String time = "";
    private String informantid = "";
    private String informantrelation = "";
    private DynamicDropDownSelector clinicalrater;

    // variables standard for each generated Assessment Struts Form Bean
    private String assessmentID;
    private String subjectID;
    private String experimentID;
    private String visitID;
    private String segmentID;
    private int currentPageIdx = 1;
    private String selectedQuestion = "";
    private String skippedQuestions = "";
    private String dataClassificationForSkipped = "";

    private static Map pageQuestionsMap;
    private static Map variableMap = null;
    private static Map mandatoryFieldMetaDataMap = null;

    public BDIForm() {
    }

    public String getSadness() {  return this.sadness; }
    public String getPessimism() {  return this.pessimism; }
    public String getSenseOfFailure() {  return this.senseOfFailure; }
    public String getDissatisfaction() {  return this.dissatisfaction; }
    public String getGuilty() {  return this.guilty; }
    public String getPunishment() {  return this.punishment; }
    public String getSelfDislike() {  return this.selfDislike; }
    public String getSelfBlame() {  return this.selfBlame; }
    public String getSuicidalThoughts() {  return this.suicidalThoughts; }
    public String getCrying() {  return this.crying; }
    public String getIrritability() {  return this.irritability; }
    public String getSocialWithdrawal() {  return this.socialWithdrawal; }
    public String getIndecisiveness() {  return this.indecisiveness; }
    public String getChangeInBodyImage() {  return this.changeInBodyImage; }
    public String getLossOfEnergy() {  return this.lossOfEnergy; }
    public String getInsomnia() {  return this.insomnia; }
    public String getFatigue() {  return this.fatigue; }
    public String getDecreasedAppetitie() {  return this.decreasedAppetitie; }
    public String getLossOfWeight() {  return this.lossOfWeight; }
    public String getSomaticPreoccupation() {  return this.somaticPreoccupation; }
    public String getLackOfInterestInSex() {  return this.lackOfInterestInSex; }
    public String getDate() {  return this.date; }
    public String getTime() {  return this.time; }
    public String getInformantid() {  return this.informantid; }
    public String getInformantrelation() {  return this.informantrelation; }
    public DynamicDropDownSelector getClinicalrater() {  return this.clinicalrater; }

    public void setSadness(String newValue) {  this.sadness = newValue; }
    public void setPessimism(String newValue) {  this.pessimism = newValue; }
    public void setSenseOfFailure(String newValue) {  this.senseOfFailure = newValue; }
    public void setDissatisfaction(String newValue) {  this.dissatisfaction = newValue; }
    public void setGuilty(String newValue) {  this.guilty = newValue; }
    public void setPunishment(String newValue) {  this.punishment = newValue; }
    public void setSelfDislike(String newValue) {  this.selfDislike = newValue; }
    public void setSelfBlame(String newValue) {  this.selfBlame = newValue; }
    public void setSuicidalThoughts(String newValue) {  this.suicidalThoughts = newValue; }
    public void setCrying(String newValue) {  this.crying = newValue; }
    public void setIrritability(String newValue) {  this.irritability = newValue; }
    public void setSocialWithdrawal(String newValue) {  this.socialWithdrawal = newValue; }
    public void setIndecisiveness(String newValue) {  this.indecisiveness = newValue; }
    public void setChangeInBodyImage(String newValue) {  this.changeInBodyImage = newValue; }
    public void setLossOfEnergy(String newValue) {  this.lossOfEnergy = newValue; }
    public void setInsomnia(String newValue) {  this.insomnia = newValue; }
    public void setFatigue(String newValue) {  this.fatigue = newValue; }
    public void setDecreasedAppetitie(String newValue) {  this.decreasedAppetitie = newValue; }
    public void setLossOfWeight(String newValue) {  this.lossOfWeight = newValue; }
    public void setSomaticPreoccupation(String newValue) {  this.somaticPreoccupation = newValue; }
    public void setLackOfInterestInSex(String newValue) {  this.lackOfInterestInSex = newValue; }
    public void setDate(String newValue) {  this.date = newValue; }
    public void setTime(String newValue) {  this.time = newValue; }
    public void setInformantid(String newValue) {  this.informantid = newValue; }
    public void setInformantrelation(String newValue) {  this.informantrelation = newValue; }
    public void setClinicalrater(DynamicDropDownSelector newValue) {  this.clinicalrater = newValue; }

                    
                    
                    


    public String getAssessmentID() {  return this.assessmentID; }
    public String getSubjectID() {  return this.subjectID; }
    public String getExperimentID() {  return this.experimentID; }
    public String getVisitID() {  return this.visitID; }
    public String getSegmentID() {  return this.segmentID; }
    public int getCurrentPageIdx() {  return this.currentPageIdx; }
    public String getSelectedQuestion() {  return this.selectedQuestion; }
    public String getSkippedQuestions() {  return this.skippedQuestions; }
    public String getDataClassificationForSkipped() {  return this.dataClassificationForSkipped; }

    public void setAssessmentID(String newValue) {  this.assessmentID = newValue; }
    public void setSubjectID(String newValue) {  this.subjectID = newValue; }
    public void setExperimentID(String newValue) {  this.experimentID = newValue; }
    public void setVisitID(String newValue) {  this.visitID = newValue; }
    public void setSegmentID(String newValue) {  this.segmentID = newValue; }
    public void setCurrentPageIdx(int newValue) {  this.currentPageIdx = newValue; }
    public void setSelectedQuestion(String newValue) {  this.selectedQuestion = newValue; }
    public void setSkippedQuestions(String newValue) {  this.skippedQuestions = newValue; }
    public void setDataClassificationForSkipped(String newValue) {  this.dataClassificationForSkipped = newValue; }

    
public static class PageVariableInfo {
      int pageNumber;
      String formVarName;
      String dbVarName;
      Map metaDataMap;
      public PageVariableInfo(int pageNumber, String formVarName, String dbVarName) {
        this.pageNumber = pageNumber;
        this.formVarName = formVarName;
        this.dbVarName = dbVarName;
      }

      public int getPageNumber() { return this.pageNumber; }
      public String getFormVarName() { return this.formVarName; }
      public String getDbVarName() { return this.dbVarName; }
      public void addMetaData(String name, String value) {
        if (metaDataMap == null) {
          metaDataMap = new HashMap(3);
        }
        metaDataMap.put(name, value);
      }
      public Map getMetaDataMap() { return metaDataMap; }
    }

    private final static String assessmentName = "Beck Depression Inventory (BDI)";

    public static String getAssessmentName() { return assessmentName; }

    public static Map getVariableMap() {
      synchronized(BDIForm.class) {
        if (variableMap == null) {
      variableMap = new LinkedHashMap();
      PageVariableInfo pvi = null;

          variableMap.put("sadness", pvi = new PageVariableInfo(2,"sadness","sadness") );
          variableMap.put("pessimism", pvi = new PageVariableInfo(2,"pessimism","pessimism") );
          variableMap.put("sense of failure", pvi = new PageVariableInfo(2,"senseOfFailure","sense of failure") );
          variableMap.put("dissatisfaction", pvi = new PageVariableInfo(2,"dissatisfaction","dissatisfaction") );
          variableMap.put("guilty", pvi = new PageVariableInfo(2,"guilty","guilty") );
          variableMap.put("punishment", pvi = new PageVariableInfo(3,"punishment","punishment") );
          variableMap.put("self-dislike", pvi = new PageVariableInfo(3,"selfDislike","self-dislike") );
          variableMap.put("self-blame", pvi = new PageVariableInfo(3,"selfBlame","self-blame") );
          variableMap.put("suicidal thoughts", pvi = new PageVariableInfo(3,"suicidalThoughts","suicidal thoughts") );
          variableMap.put("crying", pvi = new PageVariableInfo(3,"crying","crying") );
          variableMap.put("irritability", pvi = new PageVariableInfo(3,"irritability","irritability") );
          variableMap.put("social withdrawal", pvi = new PageVariableInfo(4,"socialWithdrawal","social withdrawal") );
          variableMap.put("indecisiveness", pvi = new PageVariableInfo(4,"indecisiveness","indecisiveness") );
          variableMap.put("change in body image", pvi = new PageVariableInfo(4,"changeInBodyImage","change in body image") );
          variableMap.put("loss of energy", pvi = new PageVariableInfo(4,"lossOfEnergy","loss of energy") );
          variableMap.put("insomnia", pvi = new PageVariableInfo(4,"insomnia","insomnia") );
          variableMap.put("fatigue", pvi = new PageVariableInfo(4,"fatigue","fatigue") );
          variableMap.put("decreased appetitie", pvi = new PageVariableInfo(4,"decreasedAppetitie","decreased appetitie") );
          variableMap.put("loss of Weight", pvi = new PageVariableInfo(5,"lossOfWeight","loss of Weight") );
          variableMap.put("somatic preoccupation", pvi = new PageVariableInfo(5,"somaticPreoccupation","somatic preoccupation") );
          variableMap.put("lack of interest in sex", pvi = new PageVariableInfo(5,"lackOfInterestInSex","lack of interest in sex") );
        }
      }
      return variableMap;
    }
    public static Map getMandatoryFieldMetaDataMap() {
      if (mandatoryFieldMetaDataMap == null) {
        mandatoryFieldMetaDataMap = new HashMap(3);
        Map mdMap = new HashMap(3);
        mandatoryFieldMetaDataMap.put("clinicalrater",mdMap);
        mdMap.put("query","select a.name from nc_databaseuser a, nc_userclass b where a.userclass = b.uniqueid and b.name = 'researcher'");
      }
      return mandatoryFieldMetaDataMap;
    }


 public static class PageQuestionInfo {
    int pageNumber;
    int questionNumber;
    String type;
    int minAnswer;
    int maxAnswer;
    List scoreNames = new LinkedList();
    Map scoreNameIDMAp = new HashMap(3);

    public PageQuestionInfo(int pageNumber, int questionNumber, String type) {
      this(pageNumber, questionNumber, type, 1, 1);
    }

    public PageQuestionInfo(int pageNumber, int questionNumber, String type,
                            int minAnswer, int maxAnswer)
    {
      this.pageNumber = pageNumber;
      this.questionNumber = questionNumber;
      this.type = type;
      this.minAnswer = minAnswer;
      this.maxAnswer = maxAnswer;
    }

    public int getPageNumber() { return pageNumber; }
    public int getQuestionNumber() { return questionNumber; }
    public String getType() { return type; }
    public int getMinAnswer() { return minAnswer; }
    public int getMaxAnswer() { return maxAnswer; }

    public void addScoreNameIDAssoc(String scoreName, int id) {
       scoreNameIDMAp.put(scoreName, new Integer(id));
    }

    public Integer getIDForScoreName(String scoreName) {
       return (Integer) scoreNameIDMAp.get(scoreName);
    }

    public void addScoreName(String scoreName) {
      scoreNames.add(scoreName);
    }

    public List getScoreNames() { return scoreNames; }
  }


    public static Map getPageQuestionsMap() {
      synchronized(BDIForm.class) {
        if (pageQuestionsMap == null) {
          pageQuestionsMap = new LinkedHashMap();

          List list = null;
          PageQuestionInfo pqi = null;
          list = new LinkedList();
          pageQuestionsMap.put( new Integer(5), list);
          list.add( pqi = new PageQuestionInfo(5,23,"regular") );
          pqi.addScoreName("lack of interest in sex");
          pqi.addScoreNameIDAssoc("lack of interest in sex",0);
          list.add( pqi = new PageQuestionInfo(5,21,"regular") );
          pqi.addScoreName("loss of Weight");
          pqi.addScoreNameIDAssoc("loss of Weight",0);
          list.add( pqi = new PageQuestionInfo(5,22,"regular") );
          pqi.addScoreName("somatic preoccupation");
          pqi.addScoreNameIDAssoc("somatic preoccupation",0);
          list = new LinkedList();
          pageQuestionsMap.put( new Integer(4), list);
          list.add( pqi = new PageQuestionInfo(4,18,"regular") );
          pqi.addScoreName("insomnia");
          pqi.addScoreNameIDAssoc("insomnia",0);
          list.add( pqi = new PageQuestionInfo(4,20,"regular") );
          pqi.addScoreName("decreased appetitie");
          pqi.addScoreNameIDAssoc("decreased appetitie",0);
          list.add( pqi = new PageQuestionInfo(4,19,"regular") );
          pqi.addScoreName("fatigue");
          pqi.addScoreNameIDAssoc("fatigue",0);
          list.add( pqi = new PageQuestionInfo(4,17,"regular") );
          pqi.addScoreName("loss of energy");
          pqi.addScoreNameIDAssoc("loss of energy",0);
          list.add( pqi = new PageQuestionInfo(4,14,"regular") );
          pqi.addScoreName("social withdrawal");
          pqi.addScoreNameIDAssoc("social withdrawal",0);
          list.add( pqi = new PageQuestionInfo(4,16,"regular") );
          pqi.addScoreName("change in body image");
          pqi.addScoreNameIDAssoc("change in body image",0);
          list.add( pqi = new PageQuestionInfo(4,15,"regular") );
          pqi.addScoreName("indecisiveness");
          pqi.addScoreNameIDAssoc("indecisiveness",0);
          list = new LinkedList();
          pageQuestionsMap.put( new Integer(3), list);
          list.add( pqi = new PageQuestionInfo(3,13,"regular") );
          pqi.addScoreName("irritability");
          pqi.addScoreNameIDAssoc("irritability",0);
          list.add( pqi = new PageQuestionInfo(3,9,"regular") );
          pqi.addScoreName("self-blame");
          pqi.addScoreNameIDAssoc("self-blame",0);
          list.add( pqi = new PageQuestionInfo(3,11,"regular") );
          pqi.addScoreName("suicidal thoughts");
          pqi.addScoreNameIDAssoc("suicidal thoughts",0);
          list.add( pqi = new PageQuestionInfo(3,12,"regular") );
          pqi.addScoreName("crying");
          pqi.addScoreNameIDAssoc("crying",0);
          list.add( pqi = new PageQuestionInfo(3,7,"regular") );
          pqi.addScoreName("punishment");
          pqi.addScoreNameIDAssoc("punishment",0);
          list.add( pqi = new PageQuestionInfo(3,8,"regular") );
          pqi.addScoreName("self-dislike");
          pqi.addScoreNameIDAssoc("self-dislike",0);
          list = new LinkedList();
          pageQuestionsMap.put( new Integer(2), list);
          list.add( pqi = new PageQuestionInfo(2,3,"regular") );
          pqi.addScoreName("sense of failure");
          pqi.addScoreNameIDAssoc("sense of failure",0);
          list.add( pqi = new PageQuestionInfo(2,6,"regular") );
          pqi.addScoreName("guilty");
          pqi.addScoreNameIDAssoc("guilty",0);
          list.add( pqi = new PageQuestionInfo(2,1,"regular") );
          pqi.addScoreName("sadness");
          pqi.addScoreNameIDAssoc("sadness",0);
          list.add( pqi = new PageQuestionInfo(2,5,"regular") );
          pqi.addScoreName("dissatisfaction");
          pqi.addScoreNameIDAssoc("dissatisfaction",0);
          list.add( pqi = new PageQuestionInfo(2,2,"regular") );
          pqi.addScoreName("pessimism");
          pqi.addScoreNameIDAssoc("pessimism",0);
        }
      }
      return pageQuestionsMap;
    }

    private String q23_notes = "";
    private String q18_notes = "";
    private String q20_notes = "";
    private String q13_notes = "";
    private String q9_notes = "";
    private String q19_notes = "";
    private String q3_notes = "";
    private String q17_notes = "";
    private String q14_notes = "";
    private String q6_notes = "";
    private String q1_notes = "";
    private String q5_notes = "";
    private String q16_notes = "";
    private String q11_notes = "";
    private String q15_notes = "";
    private String q12_notes = "";
    private String q7_notes = "";
    private String q2_notes = "";
    private String q21_notes = "";
    private String q22_notes = "";
    private String q8_notes = "";

    public String getQ23_notes() {  return this.q23_notes; }
    public void setQ23_notes(String newValue) {  this.q23_notes = newValue; }
    public String getQ18_notes() {  return this.q18_notes; }
    public void setQ18_notes(String newValue) {  this.q18_notes = newValue; }
    public String getQ20_notes() {  return this.q20_notes; }
    public void setQ20_notes(String newValue) {  this.q20_notes = newValue; }
    public String getQ13_notes() {  return this.q13_notes; }
    public void setQ13_notes(String newValue) {  this.q13_notes = newValue; }
    public String getQ9_notes() {  return this.q9_notes; }
    public void setQ9_notes(String newValue) {  this.q9_notes = newValue; }
    public String getQ19_notes() {  return this.q19_notes; }
    public void setQ19_notes(String newValue) {  this.q19_notes = newValue; }
    public String getQ3_notes() {  return this.q3_notes; }
    public void setQ3_notes(String newValue) {  this.q3_notes = newValue; }
    public String getQ17_notes() {  return this.q17_notes; }
    public void setQ17_notes(String newValue) {  this.q17_notes = newValue; }
    public String getQ14_notes() {  return this.q14_notes; }
    public void setQ14_notes(String newValue) {  this.q14_notes = newValue; }
    public String getQ6_notes() {  return this.q6_notes; }
    public void setQ6_notes(String newValue) {  this.q6_notes = newValue; }
    public String getQ1_notes() {  return this.q1_notes; }
    public void setQ1_notes(String newValue) {  this.q1_notes = newValue; }
    public String getQ5_notes() {  return this.q5_notes; }
    public void setQ5_notes(String newValue) {  this.q5_notes = newValue; }
    public String getQ16_notes() {  return this.q16_notes; }
    public void setQ16_notes(String newValue) {  this.q16_notes = newValue; }
    public String getQ11_notes() {  return this.q11_notes; }
    public void setQ11_notes(String newValue) {  this.q11_notes = newValue; }
    public String getQ15_notes() {  return this.q15_notes; }
    public void setQ15_notes(String newValue) {  this.q15_notes = newValue; }
    public String getQ12_notes() {  return this.q12_notes; }
    public void setQ12_notes(String newValue) {  this.q12_notes = newValue; }
    public String getQ7_notes() {  return this.q7_notes; }
    public void setQ7_notes(String newValue) {  this.q7_notes = newValue; }
    public String getQ2_notes() {  return this.q2_notes; }
    public void setQ2_notes(String newValue) {  this.q2_notes = newValue; }
    public String getQ21_notes() {  return this.q21_notes; }
    public void setQ21_notes(String newValue) {  this.q21_notes = newValue; }
    public String getQ22_notes() {  return this.q22_notes; }
    public void setQ22_notes(String newValue) {  this.q22_notes = newValue; }
    public String getQ8_notes() {  return this.q8_notes; }
    public void setQ8_notes(String newValue) {  this.q8_notes = newValue; }
    
    public void reset(ActionMapping mapping, HttpServletRequest request) {
    }
}
