package clinical.web.helpers;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.server.vo.Collectionequipment;
import clinical.server.vo.Experiment;
import clinical.server.vo.Humansubject;
import clinical.server.vo.Protocol;
import clinical.server.vo.Researchgroup;
import clinical.server.vo.Subjexperiment;
import clinical.utils.Assertion;
import clinical.web.CBFBIRNConstants;
import clinical.web.IExperimentManagement;
import clinical.web.ISubjectVisitManagement;
import clinical.web.ServiceFactory;
import clinical.web.common.IAuthorizationService;
import clinical.web.common.IAuthorizationService.PrivilegeLabel;
import clinical.web.common.IDBCache;
import clinical.web.common.UserInfo;
import clinical.web.vo.upload.ColEquipInfo;
import clinical.web.vo.upload.EnrolledSubject;
import clinical.web.vo.upload.ExperimentInfo;
import clinical.web.vo.upload.ProtocolInfo;
import clinical.web.vo.upload.RGInfo;
import clinical.web.vo.upload.ScoreValue;
import clinical.web.vo.upload.SegmentInfo;
import clinical.web.vo.upload.UploadStatusInfo;
import clinical.web.vo.upload.VisitInfo;

public class CBFUploadHelper {
	public final static String MINCON = "Mincon";
	public final static String CSF = "CSF";
	public final static String EPISTAR = "EPISTAR";
	public final static String FAIR = "FAIR";
	public final static String PICORE = "PICORE";
	public final static String VSASL = "VSASL";
	public final static String CASL = "CASL";
	public final static String PCASL = "PCASL";
	public final static String PCASL_4MP = "4MP-PCASL";
	public final static String PCASL_8MP = "8MP-PCASL";
	public final static String Opt_PCASL = "Opt-PCASL";
	public final static String Opt_PCASL_Calib = "Opt-PCASL-Calib";
	public final static String PCASL_4MP_or_Opt_PCASL_Calib = "4MP-PCASL or Opt-PCASL-Calib";
	public final static String PCASL_VARIANT = "PCASL Variant";
	public final static String DTI = "DTI";
	public static final String PCASL_EP2D_UCLA = "PCASL_EP2D_UCLA";

	public final static String EPISTAR_CSF = "EPISTAR+CSF";
	public final static String FAIR_CSF = "FAIR+CSF";
	public final static String PICORE_CSF = "PICORE+CSF";
	public final static String VSASL_CSF = "VSASL+CSF";
	public final static String CASL_CSF = "CASL+CSF";
	public final static String PCASL_CSF = "PCASL+CSF";
	public final static String PCASL_4MP_CSF = "4MP-PCASL+CSF";
	public final static String PCASL_8MP_CSF = "8MP-PCASL+CSF";
	public final static String Opt_PCASL_CSF = "Opt-PCASL+CSF";
	public final static String Opt_PCASL_Calib_CSF = "Opt-PCASL-Calib+CSF";
	public final static String PCASL_4MP_or_Opt_PCASL_Calib_CSF = "4MP-PCASL or Opt-PCASL-Calib+CSF";
	public final static String PCASL_VARIANT_CSF = "PCASL Variant+CSF";
	public final static String OPT_PCASL_CSF = "Opt-PCASL+CSF";
	public final static String OPT_PCASL_CALIB_CSF = "Opt-PCASL-Calib+CSF";

	public final static String PFILE = "P-FILE";
	public final static String AFNI = "AFNI-BRIK";
	public final static String DICOM = "DICOM";
	public static final String UNKNOWN = "Unknown";

	static Set<String> aslSet = new HashSet<String>();

	static {
		aslSet.add(EPISTAR);
		aslSet.add(FAIR);
		aslSet.add(PICORE);
		aslSet.add(VSASL);
		aslSet.add(CASL);
		aslSet.add(PCASL);
		aslSet.add(PCASL_4MP);
		aslSet.add(PCASL_8MP);
		aslSet.add(Opt_PCASL);
		aslSet.add(Opt_PCASL_Calib);
		aslSet.add(PCASL_4MP_or_Opt_PCASL_Calib);
		aslSet.add(PCASL_VARIANT);
		aslSet.add(PCASL_EP2D_UCLA);
		String[] arr = { EPISTAR_CSF, FAIR_CSF, PICORE_CSF, VSASL_CSF,
				CASL_CSF, PCASL_CSF, PCASL_4MP_CSF, PCASL_8MP_CSF,
				Opt_PCASL_CSF, Opt_PCASL_Calib_CSF,
				PCASL_4MP_or_Opt_PCASL_Calib_CSF, PCASL_VARIANT_CSF,
				OPT_PCASL_CSF, OPT_PCASL_CALIB_CSF };
		for (String str : arr) {
			aslSet.add(str);
		}
	}

	public static boolean isASL(String protocolId) {
		return aslSet.contains(protocolId);
	}

	public static boolean isASLWithCSFEmbedded(String protocolId) {
		return (aslSet.contains(protocolId) && protocolId.endsWith("+CSF"));
	}

	public static boolean isDTI(String protocolId) {
		return protocolId.equals(DTI);
	}

	public static String formatSubjectID(String subjectID) {
		if (areAllDigits(subjectID)) {
			StringBuilder sb = new StringBuilder();
			int len = subjectID.length();
			for (int i = 0; i < len; i++) {
				sb.append(subjectID.charAt(i));
				if (i > 0 && (i + 1) < len && ((i + 1) % 4) == 0) {
					sb.append('-');
				}
			}
			return sb.toString();
		}
		return subjectID;
	}

	public static String deformatSubjectID(String formattedSubjectID) {
		String s = formattedSubjectID.replaceAll("-", "");
		return s;
	}

	public static boolean areAllDigits(String str) {
		int len = str.length();
		for (int i = 0; i < len; i++) {
			if (!Character.isDigit(str.charAt(i))) {
				return false;
			}
		}
		return true;
	}

	public ExpSubjectInfo getExpSubjectInfo(UserInfo ui, String dbID)
			throws Exception {
		IAuthorizationService authService = ServiceFactory
				.getAuthorizationService();
		IDBCache dbCache = ServiceFactory.getDBCache(dbID);
		List<Researchgroup> rgList = dbCache.getResearchGroups(ui, false);
		List<Experiment> expList = dbCache.getExperiments(ui, false);
		Map<BigDecimal, List<Researchgroup>> map = new HashMap<BigDecimal, List<Researchgroup>>(
				11);
		for (Researchgroup rg : rgList) {
			List<Researchgroup> expRgList = map.get(rg
					.getNcExperimentUniqueid());
			if (expRgList == null) {
				expRgList = new ArrayList<Researchgroup>(3);
				map.put(rg.getNcExperimentUniqueid(), expRgList);
			}
			expRgList.add(rg);
		}

		List<Protocol> protocols = dbCache.getProtocols(ui, true);
		List<Collectionequipment> ceList = dbCache.getCollectionEquipments(ui,
				false);

		List<ProtocolInfo> piList = new ArrayList<ProtocolInfo>(
				protocols.size());
		List<ColEquipInfo> ceiList = new ArrayList<ColEquipInfo>(ceList.size());
		for (Protocol p : protocols) {
			ProtocolInfo pi = new ProtocolInfo(p.getProtocolversion()
					.intValue(), p.getProtocolid(), p.getName(), null);
			piList.add(pi);
		}
		for (Collectionequipment ce : ceList) {
			ColEquipInfo cei = new ColEquipInfo(ce.getUniqueid().intValue(),
					ce.getMake(), ce.getModel());
			ceiList.add(cei);
		}

		ISubjectVisitManagement isvm = ServiceFactory
				.getSubjectVisitManagement(dbID);
		IExperimentManagement iem = ServiceFactory
				.getExperimentManagement(dbID);

		List<Humansubject> allSubjects = isvm.getAllSubjects(ui);
		Map<String, Humansubject> hsMap = new HashMap<String, Humansubject>();
		for (Humansubject hs : allSubjects) {
			hsMap.put(hs.getSubjectid(), hs);
		}
		allSubjects = null;

		List<ExperimentInfo> eiList = new ArrayList<ExperimentInfo>(3);
		for (Experiment exp : expList) {
			System.out.println(ui.getName() + " isAuthorized for exp:"
					+ exp.getName());
			if (authService.isAuthorized(ui, dbID, PrivilegeLabel.READ, exp
					.getUniqueid().intValue())) {
				ExperimentInfo ei = new ExperimentInfo(exp.getName(), exp
						.getUniqueid().intValue());
				List<Researchgroup> expRgList = map.get(exp.getUniqueid());
				if (expRgList != null) {
					for (Researchgroup rg : expRgList) {
						RGInfo rgi = new RGInfo(rg.getName(),
								rg.getDescription());
						ei.addRGInfo(rgi);
					}
				} else {
					// skip experiment with no research groups
					System.out
							.println("skipping experiment with no research groups: "
									+ ei.getName());
					continue;
				}
				List<Subjexperiment> enrolledSubjects = iem
						.getEnrolledSubjects(ui, ei.getExpId());
				expRgList = map.get(exp.getUniqueid());
				Map<BigDecimal, Researchgroup> rgMap = toMap(expRgList);
				for (Subjexperiment se : enrolledSubjects) {
					Researchgroup rg = rgMap.get(se
							.getNcResearchgroupUniqueid());
					Assertion.assertNotNull(rg);
					Humansubject hs = hsMap.get(se.getSubjectid());
					String gender = hs.getGender();
					EnrolledSubject es = new EnrolledSubject(se.getSubjectid(),
							rg.getName(), gender);
					ei.addEnrolledSubject(es);
				}

				eiList.add(ei);
			}
		}
		ExpSubjectInfo esi = new ExpSubjectInfo(eiList, piList, ceiList);
		return esi;
	}

	public static class ExpSubjectInfo {
		List<ExperimentInfo> eiList;
		List<ProtocolInfo> piList;
		List<ColEquipInfo> ceiList;

		public ExpSubjectInfo(List<ExperimentInfo> eiList,
				List<ProtocolInfo> piList, List<ColEquipInfo> ceiList) {
			super();
			this.eiList = eiList;
			this.piList = piList;
			this.ceiList = ceiList;
		}

		public ExpSubjectInfo() {
		}

		public JSONObject toJSON() throws JSONException {
			JSONObject js = new JSONObject();
			JSONArray jsArr = new JSONArray();
			js.put("experiments", jsArr);
			for (ExperimentInfo ei : eiList) {
				jsArr.put(ei.toJSON());
			}
			jsArr = new JSONArray();
			js.put("protocolList", jsArr);
			for (ProtocolInfo pi : piList) {
				jsArr.put(pi.toJSON());
			}
			jsArr = new JSONArray();
			js.put("ceiList", jsArr);
			for (ColEquipInfo cei : ceiList) {
				jsArr.put(cei.toJSON());
			}
			return js;
		}

		public void sanitizeProtocols() {
			for (Iterator<ProtocolInfo> it = piList.iterator(); it.hasNext();) {
				ProtocolInfo pi = it.next();
				String protocol = pi.getProtocolId();
				if (!CBFBirnHelper.isCBFProcessable(protocol)
						&& !protocol.equals(CBFBIRNConstants.ANATOMICAL)
						&& !protocol.equals(CBFBIRNConstants.MINCON)
						&& !protocol.equals(CBFBIRNConstants.CSF)
						&& !protocol.equals(CBFBIRNConstants.FIELD_MAP)
						&& !protocol.equalsIgnoreCase("unknown")) {
					it.remove();
				}
			}
		}
	}// ;

	public static Map<BigDecimal, Researchgroup> toMap(
			List<Researchgroup> rgList) {
		Map<BigDecimal, Researchgroup> map = new HashMap<BigDecimal, Researchgroup>(
				11);
		for (Researchgroup rg : rgList) {
			map.put(rg.getUniqueid(), rg);
		}
		return map;
	}

	public static String validate(VisitInfo vi, ExpSubjectInfo esi) {
		StringBuilder sb = new StringBuilder();
		String subjectID = vi.getSubjectID();
		vi.getExpId();
		if (subjectID == null || subjectID.trim().length() == 0) {
			sb.append("No subject ID is specified!\n");
		}
		String subjectGender = getGender(vi, esi);

		if (subjectGender != null
				&& !subjectGender.equals(getScoreValue("gender", vi))) {
			sb.append("Selected gender does not match subject's "
					+ "specified gender!\n");
		}

		if (vi.getScannerType() == null
				|| vi.getScannerType().trim().length() == 0) {
			sb.append("No valid scanner is selected for the scan visit!");
		}

		return sb.toString();
	}

	public static String validateSeries(VisitInfo vi, UploadStatusInfo usi) {
		StringBuilder sb = new StringBuilder(256);
		int csfCount = 0;
		int minCount = 0;
		int aslCount = 0;
		boolean hasASL = false;
		boolean hasCSFEmbedded = false;
		for (SegmentInfo si : vi.getSiList()) {
			String selProtocolId = si.getName();
			if (selProtocolId.equals(UNKNOWN)) {
				sb.append(si.getShi().getName()).append(
						":: No Standard Series Name is specified!\n");
			} else {
				if (selProtocolId.equals(CSF)) {
					if (csfCount == 1) {
						sb.append("Multiple CSF image series is "
								+ "not allowed\n");
					}
					csfCount++;
				} else if (selProtocolId.equals(MINCON)) {
					if (minCount == 1) {
						sb.append("Multiple MINCON image series is "
								+ "not allowed\n");
					}
					minCount++;
				} else {
					if (isASL(selProtocolId)) {
						hasASL = true;
						if (aslCount == 1) {
							sb.append("Only a single ASL series is allowed per upload!\n");
						}
						aslCount++;
					}
					if (isASLWithCSFEmbedded(selProtocolId)) {
						hasCSFEmbedded = true;
					}
				}
			}
		}

		if (minCount == 0) {
			sb.append("A MINCON image series is required "
					+ "for ASL processing\n");
		}
		if (csfCount == 0 && !hasCSFEmbedded) {
			sb.append("A CSF image series is required "
					+ "for ASL processing\n");
		}
		if (!hasASL) {
			sb.append("At least an ASL image series is required "
					+ "for ASL processing\n");
		}

		return sb.toString();
	}

	static String getGender(VisitInfo vi, ExpSubjectInfo esi) {
		ExperimentInfo selEI = null;
		for (ExperimentInfo ei : esi.eiList) {
			if (ei.getExpId() == vi.getExpId()) {
				selEI = ei;
				break;
			}
		}
		Assertion.assertNotNull(selEI);
		EnrolledSubject theES = null;
		for (EnrolledSubject es : selEI.getEnrolledSubjects()) {
			if (es.getSubjectID().equals(vi.getSubjectID())) {
				theES = es;
				break;
			}
		}
		Assertion.assertNotNull(theES);
		return theES.getGender();
	}

	static String getScoreValue(String scoreName, VisitInfo vi) {
		for (ScoreValue sv : vi.getAssessments().get(0).getSvList()) {
			if (sv.getName().equals(scoreName)) {
				return sv.getValue();
			}
		}
		return null;
	}

}
