package clinical.web.helpers;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import javax.mail.MessagingException;

import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;

import clinical.utils.EmailSenderFactory;
import clinical.utils.IEmailSender;

/**
 * @author I. Burak Ozyurt
 * @version $Id: EmailHelper.java 825 2013-07-30 21:16:55Z bozyurt $
 */
public class EmailHelper {
	protected String emailHost;
	protected String emailUser;
	protected String emailPwd;
	protected String emailFrom;
	protected String toUser;
	protected int port = 25;

	protected static final String JOB_STATUS_NOTIFICATION_TEMPLATE = "From HID Web Application User Notification System:\n\n"
			+ "Hi ${client},\n"
			+ "Your ${job_type} with id ${jobid} is finished ${status}\n";

	public EmailHelper(String emailHost, String emailUser, String emailPwd,
			String emailFrom, int port) {
		super();
		this.emailHost = emailHost;
		this.emailUser = emailUser;
		this.emailPwd = emailPwd;
		this.emailFrom = emailFrom;
		this.port = port;
	}

	public EmailHelper(String emailHost, String emailUser, String emailPwd,
			String emailFrom) {
		this(emailHost, emailUser, emailPwd, emailFrom, 25);
	}

	public void sendEmail(Map<String, String> paramMap)
			throws MessagingException {
		IEmailSender mailer = EmailSenderFactory.createEmailSender(emailUser,
				emailHost, emailFrom, emailPwd, port, false);

		String subject = paramMap.get("subject");
		String toEmail = paramMap.get("client");
		String message = JOB_STATUS_NOTIFICATION_TEMPLATE;
		for (Map.Entry<String, String> entry : paramMap.entrySet()) {
			String macro = entry.getKey();
			macro = "\\$\\{" + macro + "\\}";
			String value = entry.getValue();
			message = message.replaceAll(macro, value);
		}

		System.out.println(message);
		mailer.sendMessage(toEmail, subject, message);
	}

	public void sendEmail(String toEmail, String subject,
			Map<String, String> paramMap, String templateDir,
			String templateFile, boolean verbose) throws Exception {
		IEmailSender mailer = EmailSenderFactory.createEmailSender(emailUser,
				emailHost, emailFrom, emailPwd, port, false);
		Properties p = new Properties();
		p.setProperty("file.resource.loader.path", templateDir);
		p.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.NullLogSystem");
		Velocity.init(p);
		VelocityContext ctx = new VelocityContext();
		for (Map.Entry<String, String> entry : paramMap.entrySet()) {
			ctx.put(entry.getKey(), entry.getValue());
		}
		StringWriter sw = new StringWriter();
		Template template = Velocity.getTemplate(templateFile);
		template.merge(ctx, sw);
		if (verbose) {
			System.out.println(sw.toString());
		}
		mailer.sendMessage(toEmail, subject, sw.toString());
	}

	public static void testSendEMail() throws MessagingException {
		EmailHelper helper = new EmailHelper("outbound.ucsd.edu", "", "", "");

		Map<String, String> paramMap = new HashMap<String, String>();
		paramMap.put("subject", "your image download job is ready!");
		paramMap.put("client", "iozyurt@ucsd.edu");
		paramMap.put("job_type", "project download job");
		paramMap.put("jobid", "123456");
		paramMap
				.put(
						"status",
						".\nYou can download it at your convenience by login to the HID web application");

		helper.sendEmail(paramMap);
	}

	public static void testVelocityTemplateEmail() throws Exception {
		EmailHelper helper = new EmailHelper("smtp.ucsd.edu", "iozyurt", "",
				"iozyurt@ucsd.edu");
		String subject = "Invitation from CBFBIRN";
		Map<String, String> paramMap = new HashMap<String, String>();
		paramMap.put("email", "dshin@ucsd.edu");
		paramMap.put("username", "dshin");
		paramMap.put("pwd", "x");
		paramMap.put("siteURL", "http://localhost:8080/cbfbirn");
		helper
				.sendEmail(
						"bozyurt@acm.org",
						subject,
						paramMap,
						"/data/dev/java/cbf_birn/hid/clinical/branches/BRANCH_cbfbirn/clinical/conf/mail",
						"invite.vm", true);

	}

	public static void main(String[] args) throws Exception {
		testVelocityTemplateEmail();
	}

	public String getToUser() {
		return toUser;
	}

	public void setToUser(String toUser) {
		this.toUser = toUser;
	}
}
