package clinical.web.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 
 * 
 * @author I. Burak Ozyurt
 * @version $Id: HeaderInfo.java 366 2011-05-05 20:06:27Z bozyurt $
 */

public class HeaderInfo implements java.io.Serializable {
	private static final long serialVersionUID = -2726008242930128221L;
	private String title;
	private int headerType;
	private List<String> subHeaders = new ArrayList<String>(4);
	private List<String> dataTypes = new ArrayList<String>(4);
	private Map<String, Integer> subHeaderIdxMap = new HashMap<String, Integer>(
			5);
	private List<Object> subHeaderMetaDataList = new ArrayList<Object>();
	public final static int ASSESSMENT = 1;
	public final static int DERIVED_DATA = 2;

	public HeaderInfo(String title) {
		this(title, ASSESSMENT);
	}

	public HeaderInfo(String title, int headerType) {
		this.title = title;
		this.headerType = headerType;
	}

	public void addSubHeader(String scoreName, int svIdx) {
		subHeaders.add(scoreName);
		subHeaderIdxMap.put(scoreName, new Integer(svIdx));
	}

	public int getSubHeaderIndex(String scoreName) {
		Integer idx = subHeaderIdxMap.get(scoreName);
		if (idx == null)
			return -1;
		return idx.intValue();
	}

	public void setHeaderType(int newHeaderType) {
		this.headerType = newHeaderType;
	}

	public int getHeaderType() {
		return this.headerType;
	}

	/**
	 * Shows the data type of the score shown under this subheader. Can be
	 * <code>CF</code> for numeric assessments, <code>DF</code> for string
	 * assessments or <code>BS</code> for brain structure.
	 * 
	 * @param dataType
	 *            the data type of the score shown under this subheader. Can be
	 *            <code>CF</code> for numeric assessments, <code>DF</code>
	 *            for string assessments or <code>BS</code> for brain
	 *            structure.
	 */
	public void addSubHeaderDataType(String dataType) {
		dataTypes.add(dataType);
	}

	public List<String> getDataTypes() {
		return dataTypes;
	}

	public String getDataType(int idx) {
		return dataTypes.get(idx);
	}

	/**
	 * associates meta-data for the score/derived data the subheader is
	 * associated
	 * 
	 * @param metaData
	 *            object for assessment score <code>AsScoreInfo</code> , for
	 *            derived data <code>SubCorticalVarInfo</code>
	 */
	public void addSubHeaderMetaData(Object metaData) {
		subHeaderMetaDataList.add(metaData);
	}

	public List<Object> getSubHeaderMetaDataList() {
		return subHeaderMetaDataList;
	}

	public String getSubHeader(int idx) {
		return subHeaders.get(idx);
	}

	public List<String> getSubHeaders() {
		return subHeaders;
	}

	public int getSize() {
		return subHeaders.size();
	}

	public boolean contains(String scoreName) {
		return subHeaders.contains(scoreName);
	}

	// ---------------------- setters --------------
	public void setTitle(String newTitle) {
		this.title = newTitle;
	}

	// ---------------------- getters --------------
	public String getTitle() {
		return this.title;
	}

}
