package clinical.web.helpers;

import java.util.List;

import clinical.web.Constants;
import clinical.web.vo.ScoreValue;

/**
 * Represents the information necessary to build the header of assessment score
 * values.
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ScoreNameRowInfo.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class ScoreNameRowInfo {
	protected List<String> scoreNames;
	protected List<ScoreValue> scoreValues;
	protected int emptyCellCount;

	public ScoreNameRowInfo(List<String> scoreNames,
			List<ScoreValue> scoreValues) {
		assert (scoreNames != null);
		assert (scoreValues != null);

		this.scoreNames = scoreNames;
		this.scoreValues = scoreValues;

		emptyCellCount = Constants.MAX_COLUMNS_PER_ROW - scoreNames.size();
	}

	public List<ScoreValue> getScoreValues() {
		return scoreValues;
	}

	public List<String> getScoreNames() {
		return scoreNames;
	}

	public int getEmptyCellCount() {
		return emptyCellCount;
	}
}
