package clinical.web.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

import org.apache.struts.util.LabelValueBean;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: StatsOptionSelector.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class StatsOptionSelector {
	protected Collection<LabelValueBean> statsOptions;
	protected String selectedStatsOption;

	public StatsOptionSelector(Map<String, String> statsOptionMap) {
		statsOptions = new ArrayList<LabelValueBean>(statsOptionMap.size());
		boolean first = true;
		for (Map.Entry<String, String> entry : statsOptionMap.entrySet()) {
			LabelValueBean lvb = new LabelValueBean((String) entry.getKey(),
					(String) entry.getValue());
			statsOptions.add(lvb);
			if (first) {
				selectedStatsOption = (String) entry.getValue();
				first = false;
			}
		}
	}

	// ---------------------- setters --------------
	public void setSelectedStatsOption(String newSelectedStatsOption) {
		this.selectedStatsOption = newSelectedStatsOption;
	}

	// ---------------------- getters --------------
	public Collection<LabelValueBean> getStatsOptions() {
		return this.statsOptions;
	}

	public String getSelectedStatsOption() {
		return this.selectedStatsOption;
	}

}
