package clinical.web.helpers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.struts.util.LabelValueBean;

import clinical.server.vo.Experiment;
import clinical.utils.GenUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SubjectExperimentsSelector.java,v 1.3 2006/03/24 02:22:13
 *          bozyurt Exp $
 */
public class SubjectExperimentsSelector implements Serializable {
	private static final long serialVersionUID = 1L;
	protected Collection<LabelValueBean> experimentInfos;
	protected int selectedExpID = -1;

	public SubjectExperimentsSelector(List<Experiment> experiments) {
		experimentInfos = new ArrayList<LabelValueBean>(experiments.size());
		boolean first = true;
		for (Experiment exp : experiments) {
			LabelValueBean lvb = new LabelValueBean(exp.getName(), exp
					.getUniqueid().toString());
			lvb = new LabelValueBean(exp.getName(), exp.getUniqueid()
					.toString());
			experimentInfos.add(lvb);
			if (first) {
				selectedExpID = exp.getUniqueid().intValue();
				first = false;
			}
		}
	}

	public Collection<LabelValueBean> getExperimentInfos() {
		return this.experimentInfos;
	}

	public void setSelectedExpID(int newSelectedExpID) {
		this.selectedExpID = newSelectedExpID;
	}

	public int getSelectedExpID() {
		// System.out.println("#####################  selectedExpID:" + selectedExpID);
		return this.selectedExpID;
	}
	
	public int getNumExperiments() {
		return experimentInfos.size();
	}
	
	public String getSelectedExperimentName() {
		for(LabelValueBean lvb : experimentInfos) {
			int expID = GenUtils.toInt(lvb.getValue(), -1);
		    if (expID == this.selectedExpID) {
		    	return lvb.getLabel();
		    }
		}
		return null;
	}

}
