package clinical.web.helpers;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.apache.struts.util.LabelValueBean;

import clinical.server.vo.Experiment;
import clinical.utils.DateTimeUtils;
import clinical.web.forms.SubjectVisitManagementForm;
import clinical.web.vo.PropertyChangeTracker;
import clinical.web.vo.Visit;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: VisitFormInfo.java 372 2011-05-09 21:03:48Z bozyurt $
 */
public class VisitFormInfo {
	protected Visit visit;
	protected String experiment;
	protected String visitType;
	protected String timeStamp;
	protected List<LabelValueBean> experimentLabelValueList;
	protected List<LabelValueBean> visitTypeLVList;
	protected SubjectVisitManagementForm svmForm;
	protected PropertyChangeTracker pct;
	protected List<SegmentFormInfo> segmentFormInfos = new ArrayList<SegmentFormInfo>(
			2);
	protected List<StudyFormInfo> studyFormInfos = new ArrayList<StudyFormInfo>(
			2);
	protected StudyFormInfo currentStudyFormInfo;
	protected boolean dirty = false;
	protected boolean canBeDeleted = false;

	protected void prepareExperimentsDropdownInfo(String[] experimentNames) {
		experimentLabelValueList = new ArrayList<LabelValueBean>(
				experimentNames.length);
		for (int i = 0; i < experimentNames.length; i++) {
			experimentLabelValueList.add(new LabelValueBean(experimentNames[i],
					experimentNames[i]));
		}
	}

	public VisitFormInfo(Visit visit, String[] experimentNames,
			String[] visitTypes, SubjectVisitManagementForm svmForm) {
		pct = new PropertyChangeTracker();
		pct.setKeepTrackOfChanges(true);

		this.svmForm = svmForm;
		this.visit = visit;
		prepareExperimentsDropdownInfo(experimentNames);
		visitTypeLVList = new ArrayList<LabelValueBean>(visitTypes.length);
		for (int i = 0; i < visitTypes.length; i++) {
			visitTypeLVList
					.add(new LabelValueBean(visitTypes[i], visitTypes[i]));
		}

		visitType = visit.getVisitType();
		timeStamp = visit.getTimeStamp();
	}

	public Visit getVisit() {
		return visit;
	}

	public void setDirty(boolean newDirty) {
		this.dirty = newDirty;
	}

	public boolean isDirty() {
		return this.dirty;
	}

	public void setCurrentStudyFormInfo(StudyFormInfo newCurrentStudyFormInfo) {
		this.currentStudyFormInfo = newCurrentStudyFormInfo;
	}

	public StudyFormInfo getCurrentStudyFormInfo() {
		return this.currentStudyFormInfo;
	}

	public void addSegmentFormInfo(SegmentFormInfo sfi) {
		segmentFormInfos.add(sfi);
	}

	public void clearSegmentFormInfos() {
		segmentFormInfos.clear();
		System.out.println("cleared SegmentFormInfos");
	}

	public void clearStudyFormInfos() {
		studyFormInfos.clear();
		System.out.println("cleared StudyFormInfos");
	}

	public void addStudyFormInfo(StudyFormInfo sfi) {
		studyFormInfos.add(sfi);
	}

	public String getTimeStamp() {
		return timeStamp;
	}

	public void setTimeStamp(String newTs) {
		// pct.keepTrackOfPropertyChange(timeStamp, newTs,"timeStamp");
		timeStamp = newTs;
		Timestamp ts = DateTimeUtils.toTimeStamp(timeStamp);
		if (ts != null) {
			visit.setTimeStamp(ts);
		}
		setDirty(true);
	}

	public String getExperiment() {
		return experiment;
	}

	public void setExperiment(String nexp) {
		this.experiment = nexp;
		// also set the experiment id on visit
		for (Experiment exp : svmForm.getExperiments()) {
			if (exp.getName().equals(experiment)) {
				visit.setExperimentID(exp.getUniqueid().intValue());
				break;
			}
		}
		setDirty(true);
	}

	public void setVisitType(String newVisitType) {
		this.visitType = newVisitType;
		visit.setVisitType(newVisitType);
		setDirty(true);
	}

	public String getVisitType() {
		return this.visitType;
	}

	public List<SegmentFormInfo> getSegmentFormInfos() {
		return Collections.unmodifiableList(segmentFormInfos);
	}

	public List<StudyFormInfo> getStudyFormInfos() {
		return Collections.unmodifiableList(studyFormInfos);
	}

	public Collection<LabelValueBean> getExperimentNames() {
		return experimentLabelValueList;
	}

	public Collection<LabelValueBean> getVisitTypes() {
		return visitTypeLVList;
	}

	public PropertyChangeTracker getPropertyChangeTracker() {
		return pct;
	}

	public String[] getExperimentNamesAsArray() {
		String[] expNames = new String[experimentLabelValueList.size()];
		int idx = 0;
		for (Iterator<LabelValueBean> iter = experimentLabelValueList
				.iterator(); iter.hasNext();) {
			LabelValueBean lvb = iter.next();
			expNames[idx++] = lvb.getLabel();
		}
		return expNames;
	}

	public String[] getVisitTypesAsArray() {
		String[] visitTypes = new String[visitTypeLVList.size()];
		int idx = 0;
		for (Iterator<LabelValueBean> iter = visitTypeLVList.iterator(); iter
				.hasNext();) {
			LabelValueBean lvb = iter.next();
			visitTypes[idx++] = lvb.getLabel();
		}
		return visitTypes;
	}

	public String toString() {
		StringBuffer sb = new StringBuffer(128);
		sb.append("VisitFormInfo::[");
		if (visit != null)
			sb.append(visit.toString());
		sb.append(" experiment=").append(experiment);
		sb.append(" visitType=").append(visitType);
		sb.append(" timeStamp=").append(timeStamp);
		sb.append("segmentFormInfos");
		for (Iterator<SegmentFormInfo> iter = segmentFormInfos.iterator(); iter
				.hasNext();) {
			SegmentFormInfo sfi = iter.next();
			sb.append("\n").append(sfi);
		}
		sb.append(']');
		return sb.toString();
	}

	public boolean isCanBeDeleted() {
		return canBeDeleted;
	}

	public void setCanBeDeleted(boolean canBeDeleted) {
		this.canBeDeleted = canBeDeleted;
	}
}
