package clinical.web.scheduler.remote;

import java.io.File;

import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Disposition;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.representation.FileRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;

public class WFESClient {
	private String appURI = null;

	public WFESClient(String anAppURI) {
		this.appURI = anAppURI;
	}

	public String getUserUri(String username) {
		return appURI + "/users/" + username;
	}

	public String getJobUri(String username, String jobId) {
		return getUserUri(username) + "/jobs/" + jobId;
	}

	public String getJobDataUri(String username, String jobId) {
		return getJobUri(username, jobId) + "/data";
	}

	public ClientResource getAuthenticatedResource(String uri, String login,
			String pwd) {
		ClientResource cr = new ClientResource(uri);
		cr.setChallengeResponse(new ChallengeResponse(
				ChallengeScheme.HTTP_BASIC, login, pwd));
		return cr;
	}

	public void putFile(String login, String pwd, String userName,
			String jobId, File file) {
		ClientResource resource = getAuthenticatedResource(getJobDataUri(
				userName, jobId), login, pwd);
		Representation rep = new FileRepresentation(file,
				MediaType.APPLICATION_GNU_ZIP);
		Form form = new Form();
		form.add(Disposition.NAME_FILENAME, file.getName());
		rep.setDisposition(new Disposition(Disposition.TYPE_INLINE, form));
		resource.put(rep);
	}

	// test driver
	public static void main(String[] args) throws Exception {
		if (args.length != 2) {
			System.err.println("Usage: WFSClient <login> <pwd>");
			System.exit(1);
		}
		String login = args[0];
		String pwd = args[1];
		final String APP_URI = "http://localhost:3000/wfes";
		WFESClient client = new WFESClient(APP_URI);
		ClientResource resource = client.getAuthenticatedResource(client
				.getUserUri("bozyurt"), login, pwd);
		Representation result = resource.get();

		System.out.println(resource.getStatus() + ": " + result.getText());
	}
}
