package clinical.web.scheduler.remote;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.json.JSONObject;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;

import clinical.web.IAppConfigService;
import clinical.web.ServiceFactory;

public class WFESLocationService {
	private String login;
	private String password;
	private Map<String, WFESLocation> locationMap = Collections
			.synchronizedMap(new HashMap<String, WFESLocation>());
	private static WFESLocationService instance = null;

	private WFESLocationService() throws Exception {
		IAppConfigService acs = ServiceFactory.getAppConfigService();
		this.login = acs.getParamValue("wfes.login");
		this.password = acs.getParamValue("wfes.pwd");
	}

	public synchronized static WFESLocationService getInstance()
			throws Exception {
		if (instance != null) {
			instance = new WFESLocationService();
		}
		return instance;
	}

	public synchronized void loadLocations() throws Exception {
		IAppConfigService acs = ServiceFactory.getAppConfigService();

		String[] wfesURIs = acs.getParamValues("wfes.uri");
		locationMap.clear();
		for (String wfesURI : wfesURIs) {
			WFESLocation location = new WFESLocation(wfesURI);
			locationMap.put(wfesURI, location);
		}
	}

	public WFESLocation getAvailableWorkSlave() throws Exception {
		if (this.login == null || this.password == null) {
			// no slave configured and/or accessible
			return null;
		}
		Map<String, WFESLocation> copyLocMap = null;
		synchronized (locationMap) {
			copyLocMap = new HashMap<String, WFESLocation>(locationMap);
		}

		WFESLocation theLoc = null;
		for (WFESLocation loc : copyLocMap.values()) {
			String uri = loc.getWfesURI() + "/status";

			WFESStatus slaveStatus = null;
			try {
				slaveStatus = getSlaveStatus(uri);
			} catch (Exception x) {
				x.printStackTrace();
			}
			if (slaveStatus != null
					&& slaveStatus == WFESStatus.ONLINE_AVAILABLE) {
				theLoc = loc;
				theLoc.setStatus(slaveStatus);
				theLoc.setLastStatusCheckMsecs(System.currentTimeMillis());
				break;
			}
		}
		if (theLoc != null) {
			locationMap.put(theLoc.getWfesURI(), theLoc);
		}

		return theLoc;
	}

	private ClientResource getAuthenticatedResource(String uri) {
		ClientResource cr = new ClientResource(uri);
		cr.setChallengeResponse(new ChallengeResponse(
				ChallengeScheme.HTTP_BASIC, login, password));
		return cr;
	}

	private WFESStatus getSlaveStatus(String uri) throws Exception {
		WFESStatus ws = WFESStatus.OFFLINE;
		ClientResource cr = getAuthenticatedResource(uri);
		Representation rep = cr.get();
		Status status = cr.getStatus();
		if (status.equals(Status.SUCCESS_OK)) {
			if (rep.getMediaType() == MediaType.APPLICATION_JSON) {
				String jsonStr = rep.getText();
				JSONObject js = new JSONObject(jsonStr);
				String statusStr = js.getString("status");
				if (statusStr.equals("avail")) {
					ws = WFESStatus.ONLINE_AVAILABLE;
				}
			}
		}
		return ws;
	}

}
