package clinical.web.services;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

import clinical.cache.CacheUtils;
import clinical.server.dao.JobProvParamTypeDAO;
import clinical.server.vo.Assessmentdata;
import clinical.server.vo.Assessmentscorecode;
import clinical.server.vo.Experiment;
import clinical.server.vo.JobProvParamType;
import clinical.server.vo.JobProvenanceParam;
import clinical.utils.Assertion;
import clinical.web.DAOFactory;
import clinical.web.IRemoteDBServices;
import clinical.web.ServiceFactory;
import clinical.web.common.IAuthorizationService;
import clinical.web.common.IAuthorizationService.PrivilegeLabel;
import clinical.web.common.IDBCache;
import clinical.web.common.UserInfo;
import clinical.web.common.query.CBFQueryAggregator;
import clinical.web.common.query.TSQLProcessor;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.common.vo.CBFProcessReportRec;
import clinical.web.common.vo.CBFProcessReportRecListWrapper;
import clinical.web.exception.BaseException;
import clinical.web.vo.AssessmentQueryInfo;
import clinical.web.vo.AssessmentResultSummary;
import clinical.web.vo.CBFQueryMetaData;
import clinical.web.vo.CBFQueryResultSummary;
import clinical.web.vo.JobProvenanceInfo.JobProvenanceParamType;
import clinical.web.vo.JobProvenanceMetadata;
import clinical.web.vo.JobProvenanceQueryInfo;
import clinical.web.vo.JobResultGroupInfo;
import clinical.web.vo.JobResultQueryInfo;
import clinical.web.vo.JobResultResultSummary;
import clinical.web.vo.JobResultResultSummary.VisitJobResultValues;
import clinical.web.vo.ProvenanceResultSummary;
import clinical.web.vo.ProvenanceResultSummary.VisitProvResultValues;
import clinical.web.vo.VisitSegAsResultValues;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class CBFSearchServiceImpl extends AbstractServiceImpl implements
		ICBFSearchService {
	protected IDBCache dbCache;

	public CBFSearchServiceImpl(String dbID) throws BaseException {
		super(dbID);
		log = LogFactory.getLog(CBFSearchServiceImpl.class);
		dbCache = ServiceFactory.getDBCache(dbID);
	}

	public JSONObject getDistinctScoreValues(UserInfo ui, String asID,
			String scoreName) throws Exception {

		JSONObject js = new JSONObject();
		js.put("asID", asID);
		js.put("scoreName", scoreName);
		JSONArray jsArr = new JSONArray();
		js.put("posVals", jsArr);
		Map<String, List<Assessmentscorecode>> scoreCodeMap = dbCache
				.getScoreCodeMap(ui, false);
		String key = asID + ":" + scoreName;
		List<Assessmentscorecode> scList = scoreCodeMap.get(key);
		if (scList != null) {
			for (Assessmentscorecode sc : scList) {
				jsArr.put(sc.getScorecodevalue());
			}
		} else {
			Connection con = null;
			try {
				con = pool.getConnection(ui.getName());
				TSQLProcessor tsp = new TSQLProcessor(this.sqlDialect);
				StringBuilder tbuf = new StringBuilder();
				tbuf.append("select distinct a.textvalue from Assessmentdata as a ");
				tbuf.append("where a.assessmentid = ").append(asID)
						.append(" and ");
				tbuf.append("a.scorename = '").append(scoreName).append("'");

				List<?> results = tsp.executeQuery(con, tbuf.toString());
				for (Iterator<?> it = results.iterator(); it.hasNext();) {
					Assessmentdata ad = (Assessmentdata) it.next();
					if (ad.getTextvalue() != null)
						jsArr.put(ad.getTextvalue());
				}
			} finally {
				releaseConnection(con, ui);
			}
		}
		return js;
	}
	
	
	public JSONObject getDistinctProvParamValues(UserInfo ui, String provName) throws Exception {
		JSONObject js = new JSONObject();
		js.put("provName", provName);
		JSONArray jsArr = new JSONArray();
		js.put("posVals", jsArr);
		
		Connection con = null;
		try {
			con = pool.getConnection(ui.getName());
			TSQLProcessor tsp = new TSQLProcessor(this.sqlDialect);
			StringBuilder tbuf = new StringBuilder();
			tbuf.append("select distinct a.value from JobProvenanceParam as a ");
			tbuf.append("where a.name = '").append(provName).append("'");
			List<?> results = tsp.executeQuery(con, tbuf.toString());
			for (Iterator<?> it = results.iterator(); it.hasNext();) {
				JobProvenanceParam p = (JobProvenanceParam) it.next();
				if ( p.getValue() != null) {
					jsArr.put(p.getValue());
				}
			}
		} finally {
			releaseConnection(con, ui);
		}
		return js;
	}

	public AssessmentSelectionInfo getAssessmentQueryMetadata(UserInfo ui,
			String assessmentName, String primarySiteID) throws Exception {
		Connection con = null;
		try {
			con = pool.getConnection(ui.getName());
			IRemoteDBServices rds = ServiceFactory.getRemoteDBServices();
			List<AssessmentSelectionInfo> asiList = rds
					.getAllAssessmentsWithScores(primarySiteID);
			for (AssessmentSelectionInfo asi : asiList) {
				if (asi.getName().equals(assessmentName)) {
					return asi;
				}
			}
			return null;
		} finally {
			releaseConnection(con, ui);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * clinical.web.services.ICBFSearchService#getMetadataQuery(clinical.web
	 * .common.UserInfo, java.lang.String,
	 * clinical.web.common.IAuthorizationService.PrivilegeLabel)
	 */
	@Override
	public CBFQueryMetaData getMetadataQuery(UserInfo ui, String primarySiteID,
			PrivilegeLabel privilegeRequired) throws Exception {
		JobProvenanceMetadata jpMeta = new JobProvenanceMetadata();
		List<AssessmentSelectionInfo> asiList = null;
		Connection con = null;
		try {
			con = pool.getConnection(ui.getName());
			IAuthorizationService authService = ServiceFactory
					.getAuthorizationService();

			List<Experiment> allExps = dbCache.getExperiments(ui, false);
			List<Experiment> userExps = new ArrayList<Experiment>(
					allExps.size());
			for (Experiment exp : allExps) {
				if (authService.isAuthorized(ui, theDBID, privilegeRequired,
						exp.getUniqueid().intValue())) {
					userExps.add(exp);
				}
			}
			allExps = null;

			List<JobProvParamType> jpptList = getAllProvParamTypes(con);
			for (JobProvParamType jppt : jpptList) {
				JobProvenanceParamType type = JobProvenanceParamType
						.valueOf(jppt.getDataType());
				Assertion.assertNotNull(type);
				jpMeta.add(jppt.getName(), type);
			}

			IRemoteDBServices rds = ServiceFactory.getRemoteDBServices();
			asiList = rds.getAllAssessmentsWithScores(primarySiteID);

			IJobResultService jrs = ServiceFactory.getJobResultService(theDBID);

			List<JobResultGroupInfo> jrgiList = jrs.getJobResultGroups(con);

			CBFQueryMetaData qmd = new CBFQueryMetaData(asiList, jpMeta,
					jrgiList, userExps);
			return qmd;

		} finally {
			releaseConnection(con, ui);
		}
	}

	public List<JobProvParamType> getAllProvParamTypes(Connection con)
			throws Exception {
		JobProvParamTypeDAO dao = DAOFactory
				.createJobProvParamTypeDAO(this.theDBID);
		return dao.find(con, new JobProvParamType());
	}

	public List<AssessmentResultSummary> searchByAssessment(UserInfo ui,
			JSONObject searchFilterJSON) throws Exception {
		Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
		String primarySiteID = dbID2SiteIDMap.get(this.theDBID);
		AssessmentQueryInfo aqi = null;
		if (searchFilterJSON.has("asQPIList")) {
			aqi = AssessmentQueryInfo.initializeFromJSON(searchFilterJSON);
			if (!aqi.hasQueryParts()) {
				aqi = null;
			}
		}
		if (aqi == null) {
			log.error("searchByAssessment: No query specified! "
					+ searchFilterJSON.toString(2));
			return new ArrayList<AssessmentResultSummary>(0);
		}

		List<Integer> expIdList = null;
		if (searchFilterJSON.has("selExpIds")) {
			JSONArray jsonArray = searchFilterJSON.getJSONArray("selExpIds");
			int len = jsonArray.length();
			expIdList = new ArrayList<Integer>(len);
			for (int i = 0; i < len; i++) {
				expIdList.add(jsonArray.getInt(i));
			}
		}

		CBFQueryAggregator qa = new CBFQueryAggregator(this.theDBID, ui,
				expIdList);

		List<CBFQueryResultSummary> qsList = qa.handleQuery(aqi, null, null,
				primarySiteID);

		List<AssessmentResultSummary> arsList = new ArrayList<AssessmentResultSummary>(
				qsList.size());
		for (CBFQueryResultSummary cqrs : qsList) {
			arsList.add(cqrs.getArs());
		}
		return arsList;
	}

	public List<CBFProcessReportRec> filterRecsByExperiment(UserInfo ui,
			JSONArray selExpIdsArr, CBFProcessReportRecListWrapper resultSet)
			throws Exception {
		List<Experiment> experiments = dbCache.getExperiments(ui, false);
		Map<Integer, Experiment> expMap = new HashMap<Integer, Experiment>(17);
		for (Experiment exp : experiments) {
			expMap.put(exp.getUniqueid().intValue(), exp);
		}
		Set<String> selExpNames = new HashSet<String>();
		int len = selExpIdsArr.length();
		for (int i = 0; i < len; i++) {
			Experiment exp = expMap.get(selExpIdsArr.getInt(i));
			Assertion.assertNotNull(exp);
			selExpNames.add(exp.getName());
		}
		expMap = null;
		List<CBFProcessReportRec> filteredRecs = new ArrayList<CBFProcessReportRec>(
				resultSet.getRecords().size());
		for (CBFProcessReportRec rec : resultSet.getRecords()) {
			if (selExpNames.contains(rec.getProjectName())) {
				filteredRecs.add(rec);
			}
		}

		return filteredRecs;

	}

	public List<CBFProcessReportRec> filterRecsByFilterQuery(UserInfo ui,
			JSONObject searchFilterJSON,
			CBFProcessReportRecListWrapper resultSet) throws Exception {
		JobProvenanceQueryInfo jpqi = null;
		AssessmentQueryInfo aqi = null;
		JobResultQueryInfo jrqi = null;

		Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
		String primarySiteID = dbID2SiteIDMap.get(this.theDBID);
		if (searchFilterJSON.has("asQPIList")) {
			aqi = AssessmentQueryInfo.initializeFromJSON(searchFilterJSON);
			if (!aqi.hasQueryParts()) {
				aqi = null;
			}
		}

		if (searchFilterJSON.has("jobProvQPIList")) {
			jpqi = JobProvenanceQueryInfo.initializeFromJSON(searchFilterJSON);
			if (!jpqi.hasQueryParts()) {
				jpqi = null;
			}
		}
		if (searchFilterJSON.has("jobResultQPIList")) {
			jrqi = JobResultQueryInfo.initializeFromJSON(searchFilterJSON);
			if (!jrqi.hasQueryParts()) {
				jrqi = null;
			}
		}
		List<Integer> expIdList = null;
		if (searchFilterJSON.has("selExpIds")) {
			JSONArray jsonArray = searchFilterJSON.getJSONArray("selExpIds");
			int len = jsonArray.length();
			expIdList = new ArrayList<Integer>(len);
			for (int i = 0; i < len; i++) {
				expIdList.add(jsonArray.getInt(i));
			}

		}

		CBFQueryAggregator qa = new CBFQueryAggregator(this.theDBID, ui,
				expIdList);

		List<CBFQueryResultSummary> qsList = qa.handleQuery(aqi, jpqi, jrqi,
				primarySiteID);

		Map<String, List<CBFProcessReportRec>> recListMap = new HashMap<String, List<CBFProcessReportRec>>();

		Map<String, CBFProcessReportRec> recMap = new HashMap<String, CBFProcessReportRec>();
		for (CBFProcessReportRec rec : resultSet.getRecords()) {
			StringBuilder sb = new StringBuilder();
			sb.append(rec.getProjectName()).append(':')
					.append(rec.getSubjectID());
			sb.append(':').append(rec.getVisitId());
			String keyPrefix = sb.toString();
			List<CBFProcessReportRec> list = recListMap.get(keyPrefix);
			if (list == null) {
				list = new ArrayList<CBFProcessReportRec>(1);
				recListMap.put(keyPrefix, list);
			}
			list.add(rec);
			sb = new StringBuilder(100);
			sb.append(keyPrefix).append(':').append(rec.getJobUniqueID());
			String key = sb.toString();
			recMap.put(key, rec);
		}

		Set<CBFProcessReportRec> containedUniqueRecSet = new HashSet<CBFProcessReportRec>();

		for (CBFQueryResultSummary qs : qsList) {
			if (qs.getPrs() != null) {
				StringBuilder sb = new StringBuilder();
				ProvenanceResultSummary prs = qs.getPrs();
				sb.append(prs.getExpName()).append(':');
				sb.append(prs.getSubjectID());
				String keyPrefix = sb.toString();
				for (VisitProvResultValues vprv : prs.getVprvMap().values()) {
					StringBuilder buf = new StringBuilder(100);
					buf.append(keyPrefix).append(':').append(vprv.getVisitID());
					buf.append(':').append(vprv.getJobUniqueID());
					String key = buf.toString();
					CBFProcessReportRec rec = recMap.get(key);
					if (rec != null) {
						containedUniqueRecSet.add(rec);
					}
				}
			}
			if (qs.getArs() != null) {
				StringBuilder sb = new StringBuilder();
				AssessmentResultSummary ars = qs.getArs();
				sb.append(ars.getExpName()).append(':');
				sb.append(ars.getSubjectID());
				String keyPrefix = sb.toString();
				for (VisitSegAsResultValues vsarv : ars.getVsarvList()) {
					StringBuilder buf = new StringBuilder(100);
					buf.append(keyPrefix).append(':')
							.append(vsarv.getVisitID());
					String key = buf.toString();
					List<CBFProcessReportRec> list = recListMap.get(key);
					if (list != null) {
						for (CBFProcessReportRec rec : list) {
							containedUniqueRecSet.add(rec);
						}
					}
				}
			}
			if (qs.getJrs() != null) {
				StringBuilder sb = new StringBuilder();
				JobResultResultSummary jrs = qs.getJrs();
				sb.append(jrs.getExpName()).append(':');
				sb.append(jrs.getSubjectID());
				String keyPrefix = sb.toString();
				for (VisitJobResultValues vjrv : jrs.getVjrvMap().values()) {
					StringBuilder buf = new StringBuilder(100);
					buf.append(keyPrefix).append(':').append(vjrv.getVisitID());
					String key = buf.toString();
					List<CBFProcessReportRec> list = recListMap.get(key);
					if (list != null) {
						for (CBFProcessReportRec rec : list) {
							containedUniqueRecSet.add(rec);
						}
					}
				}
			}
		}

		List<CBFProcessReportRec> filteredRecs = new ArrayList<CBFProcessReportRec>(
				containedUniqueRecSet.size());
		for (CBFProcessReportRec rec : resultSet.getRecords()) {
			if (containedUniqueRecSet.contains(rec)) {
				filteredRecs.add(rec);
			}
		}

		return filteredRecs;
	}

}
