package clinical.web.services;

import java.io.File;
import java.util.List;

import clinical.server.vo.GroupAnalysisData;
import clinical.web.common.UserInfo;
import clinical.web.common.vo.CBFProcessReportRec;
import clinical.web.vo.CBFROIJobAssociation;
import clinical.web.vo.GroupDerivedDataInfo;
import clinical.web.vo.JobProvenanceInfo;

public interface ICBFROIGroupAnalysisService {

	public List<CBFROIJobAssociation> handleROIMasksTarBall(UserInfo ui,
			String stagingDirRoot, String tarBallName,
			List<CBFProcessReportRec> cbfRecList) throws Exception;

	public void prepareROIProcessInputData(UserInfo ui, File inputRootDir,
			List<CBFROIJobAssociation> finalAssocList) throws Exception;

	public List<CBFROIJobAssociation> populateAssociationsWithJobProvDetails(
			UserInfo ui, List<CBFROIJobAssociation> finalAssocList)
			throws Exception;

	public List<GroupAnalysisData> addDerivedDataWithJobProvenance(UserInfo ui,
			List<GroupDerivedDataInfo> gddiList, JobProvenanceInfo jpi)
			throws Exception;

}