package clinical.web.services;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.LogFactory;

import clinical.server.dao.JobFilterDAO;
import clinical.server.vo.JobFilter;
import clinical.web.Constants;
import clinical.web.DAOFactory;
import clinical.web.ISequenceHelper;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.common.query.TSQLProcessor;
import clinical.web.exception.BaseException;

public class JobFilterManagementServiceImpl extends AbstractServiceImpl implements IJobFilterManagementService {
	private ISequenceHelper seqHelper;

	public JobFilterManagementServiceImpl(String dbID) throws BaseException {
		super(dbID);
		log = LogFactory.getLog(JobFilterManagementServiceImpl.class);
		seqHelper = ServiceFactory.getSequenceHelper(dbID);
	}

	/* (non-Javadoc)
	 * @see clinical.web.services.IJobFilterManagementService#getFilters(clinical.web.common.UserInfo)
	 */
	@Override
	public List<JobFilter> getFilters(UserInfo ui) throws Exception {
		Connection con = null;
		try {
			con = pool.getConnection(ui.getName());
			TSQLProcessor tsp = new TSQLProcessor(this.sqlDialect);
			StringBuilder qb = new StringBuilder(128);
			qb.append("select a.* from JobFilter as a where ");
			qb.append("a.userName in ('all','");
			qb.append(ui.getName()).append("')");

			List<?> results = tsp.executeQuery(con, qb.toString());
			List<JobFilter> jfList = new ArrayList<JobFilter>(results.size());
			for (Iterator<?> it = results.iterator(); it.hasNext();) {
				JobFilter jf = (JobFilter) it.next();
				jfList.add(jf);
			}
			results = null;

			Collections.sort(jfList, new Comparator<JobFilter>() {
				@Override
				public int compare(JobFilter o1, JobFilter o2) {
					if (o1.getUserName().equals("all")
							&& !o2.getUserName().equals("all"))
						return -1;
					if (o2.getUserName().equals("all")
							&& !o1.getUserName().equals("all"))
						return 1;
					return 0;
				}
			});

			return jfList;
		} finally {
			releaseConnection(con, ui);
		}
	}

	/* (non-Javadoc)
	 * @see clinical.web.services.IJobFilterManagementService#saveFilter(clinical.web.common.UserInfo, clinical.server.vo.JobFilter)
	 */
	@Override
	public void saveFilter(UserInfo ui, JobFilter aFilter) throws Exception {
		Connection con = null;
		try {
			con = pool.getConnection(ui.getName());
			con.setAutoCommit(false);
			JobFilterDAO dao = DAOFactory.createJobFilterDAO(this.theDBID);
			JobFilter cr = new JobFilter();
			cr.setFilterExpr(aFilter.getFilterExpr());
			cr.setUserName(ui.getName());
			List<JobFilter> jfList = dao.find(con, cr);
			if (jfList.isEmpty()) {
				BigDecimal uniqueid = seqHelper.getNextUID(con,
						Constants.JOB_FILTER_DB_TABLE, "uniqueid");
				aFilter.setUniqueid(uniqueid);

				dao.insert(con, aFilter);
			} else {
				JobFilter jf = jfList.get(0);
				cr = new JobFilter();
				cr.setUniqueid(jf.getUniqueid());
				dao.update(con, aFilter, cr);
			}
			con.commit();
		} catch (Exception x) {
			log.error("Error in addFilter", x);
			try {
				con.rollback();
			} catch (SQLException e) {
				log.error("rollback:", e);
			}
			throw x;
		} finally {
			if (con != null)
				con.setAutoCommit(true);
			releaseConnection(con, ui);
		}
	}

}
