package clinical.web.services;

import java.util.List;

import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;
import clinical.web.exception.SubjectAssessmentManagementException;
import clinical.web.vo.AssessmentInfo;
import clinical.web.vo.AssessmentScoreValues;

/**
 * Provides subject assessment management service for Postgres databases.
 *
 * @author I. Burak Ozyurt
 * @version $Id: PostgresSubjectAssessmentManImpl.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class PostgresSubjectAssessmentManImpl
      extends
         AbstractSubjectAssessmentManImpl {

   public PostgresSubjectAssessmentManImpl(String dbID) throws BaseException {
      super(dbID);
   }

   public List<AssessmentScoreValues> getAssessmentValuesForSubject(
         UserInfo ui, String subjectID, int experimentID,
         List<AssessmentInfo> assessments, int entryID, boolean validated)
         throws SubjectAssessmentManagementException {
      return super.getAssessmentValuesForSubject(ui, subjectID, experimentID,
            -1, -1, assessments, entryID, validated);
   }

   protected String prepareSO(String schemaObjName) {
      return schemaObjName;
   }

   protected String prepareString(String value) {
      StringBuffer buf = new StringBuffer();
      value = escapeQuotes(value);
      buf.append("'").append(value).append("'");
      return buf.toString();
   }

   public static String escapeQuotes(String str) {
      if (str == null) {
         return str;
      }
      if (str.indexOf('\'') != -1) {
         str = str.replaceAll("'", "''");
      }
      return str;
   }

   protected String prepareBoolean(String prefix, boolean value) {
      StringBuffer buf = new StringBuffer();
      // buf.append(prefix).append(' ').append(value ? "1" : "0");
      buf.append(prefix).append(' ').append(value ? "true" : "false");
      return buf.toString();
   }

}
