package clinical.web.services;

import java.sql.Connection;
import java.util.Iterator;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import clinical.server.vo.Experiment;
import clinical.server.vo.ScoreSynonyms;
import clinical.web.common.IDBPoolService;
import clinical.web.common.UserInfo;
import clinical.web.common.query.TSQLProcessor;
import clinical.web.exception.BaseException;

public class SynonymExpansionServiceImpl extends AbstractServiceImpl implements SynonymExpansionService {

	public SynonymExpansionServiceImpl(String dbID) throws BaseException {
		super(dbID);
	}

	/* (non-Javadoc)
	 * @see clinical.web.services.SynonymExpansionService#getExperimentsUsingAssessment(clinical.web.common.UserInfo, java.lang.String)
	 */
	@Override
	public JSONObject getExperimentsUsingAssessment(UserInfo ui, String asID)
			throws Exception {
		JSONObject js = new JSONObject();
		js.put("asID", asID);
		JSONArray jsArr = new JSONArray();
		js.put("expList", jsArr);
		Connection con = null;
		try {
			con = pool.getConnection(ui.getName());
			TSQLProcessor tsp = new TSQLProcessor(this.sqlDialect);
			StringBuilder qb = new StringBuilder();
			qb.append("select distinct e.name, e.uniqueid from nc_Storedassessment as s, Experiment as e ");
			qb.append(
					"where s.ncExperimentUniqueid = e.uniqueid and s.assessmentid = ")
					.append(asID);
			List<?> results = tsp.executeQuery(con, qb.toString());
			for (Iterator<?> it = results.iterator(); it.hasNext();) {
				Experiment exp = (Experiment) it.next();
				JSONObject expJS = new JSONObject();
				expJS.put("id", exp.getUniqueid().intValue());
				expJS.put("name", exp.getName());
				jsArr.put(expJS);
			}
		} finally {
			releaseConnection(con, ui);
		}

		return js;
	}

	/* (non-Javadoc)
	 * @see clinical.web.services.SynonymExpansionService#saveScoreSynonyms(clinical.web.common.UserInfo, clinical.server.vo.ScoreSynonyms, java.util.List)
	 */
	@Override
	public void saveScoreSynonyms(UserInfo ui, ScoreSynonyms ss,
			List<Integer> expIds) throws Exception {
		Connection con = null;
		IDBPoolService dbPoolService = null;
		try {

		} finally {
			if (dbPoolService != null) {
				dbPoolService.releaseConnection(ui.getName(), con);
			}
		}
	}
}
