package clinical.web.tags.sec;

import java.util.StringTokenizer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;

import clinical.web.Constants;
import clinical.web.ServiceFactory;
import clinical.web.UserContainer;
import clinical.web.common.IAuthorizationService;
import clinical.web.common.IAuthorizationService.PrivilegeLabel;
import clinical.web.exception.BaseException;

/**
 * @author I. Burak Ozyurt
 * @version $Id: NotAuthorizedTag.java 559 2012-03-10 01:05:59Z bozyurt $
 */
public class NotAuthorizedTag extends TagSupport {
	protected String privileges;
	private static final long serialVersionUID = 1L;

	public int doStartTag() throws JspException {
		HttpServletRequest req = (HttpServletRequest) pageContext.getRequest();
		HttpSession session = req.getSession(false);
		if (session == null)
			return SKIP_BODY;
		// check if there is a user container in the session (set after login
		// only)
		UserContainer userCon = (UserContainer) session
				.getAttribute(Constants.CONTAINER_KEY);

		if (userCon == null)
			return SKIP_BODY;
		String[] privilege = null;
		if (privileges.indexOf(',') == -1) {
			privilege = new String[] { privileges };
		} else {
			StringTokenizer stok = new StringTokenizer(privileges, " \t,");
			privilege = new String[stok.countTokens()];
			int i = 0;
			while (stok.hasMoreTokens()) {
				privilege[i++] = stok.nextToken();
			}
		}

		try {
			
			IAuthorizationService authService = ServiceFactory
					.getAuthorizationService();
			boolean hasAll = true;
			for (int i = 0; i < privilege.length; i++) {
				String[] toks = getToks(privilege[i]);
				Integer expID = getExpID(toks);
				PrivilegeLabel privLabel = PrivilegeLabel.findByLabel(toks[0]);
				hasAll &= authService.isAuthorized(userCon.getUserInfo(), userCon
						.getDbID(), privLabel, expID);
				if (!hasAll)
					break;
			}

			if (!hasAll)
				return SKIP_BODY;
		} catch (BaseException be) {
			throw new JspTagException(be.getMessage());
		}

		return EVAL_BODY_INCLUDE;
	}

	Integer getExpID(String[] toks) {
		if (toks.length == 1)
			return null;
		return new Integer(Integer.parseInt(toks[1].trim()));
	}

	String[] getToks(String privTok) {
		if (privTok.indexOf(":") == -1) {
			return new String[] { privTok };
		}
		return privTok.split(":");
	}

	public void setPrivileges(String privileges) {
		this.privileges = privileges;
	}

}
