package clinical.web.vo;

import java.io.Serializable;

import org.json.JSONException;
import org.json.JSONObject;

import clinical.web.vo.CBFROIJobAssociation.JobVisitInfo;
import clinical.web.workflow.common.JSONUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class GroupAnalysisCBFJobInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	private String subjectId;
	private String visitDate;
	private String rootDir;
	private JobVisitInfo jvi;

	public GroupAnalysisCBFJobInfo(String subjectId, String visitDate,
			String rootDir, JobVisitInfo jvi) {
		super();
		this.subjectId = subjectId;
		this.visitDate = visitDate;
		this.rootDir = rootDir;
		this.jvi = jvi;
	}

	public String getSubjectId() {
		return subjectId;
	}

	public String getVisitDate() {
		return visitDate;
	}

	public String getRootDir() {
		return rootDir;
	}

	public JobVisitInfo getJvi() {
		return jvi;
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		js.put("subjectId", subjectId);
		JSONUtils.addStringField(js, "visitDate", visitDate, "");
		JSONUtils.addStringField(js, "rootDir", rootDir, "");
		js.put("jvi", jvi.toJSON());
		return js;
	}

	public static GroupAnalysisCBFJobInfo fromJSON(JSONObject js)
			throws JSONException {
		GroupAnalysisCBFJobInfo rec = null;
		String subjectId = js.getString("subjectId");
		String visitDate = JSONUtils.getString(js, "visitDate");
		String rootDir = JSONUtils.getString(js, "rootDir");
		JobVisitInfo jvi = JobVisitInfo.fromJSON(js.getJSONObject("jvi"));
		rec = new GroupAnalysisCBFJobInfo(subjectId, visitDate, rootDir, jvi);
		return rec;
	}

	@Override
	public String toString() {
		return "CBFGroupAnalysisJob [subjectId=" + subjectId + ", visitDate="
				+ visitDate + ", rootDir=" + rootDir + ", jvi=" + jvi + "]";
	}
	
}
