package clinical.web.vo;

import org.jdom.Element;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: HeaderFieldType.java 366 2011-05-05 20:06:27Z bozyurt $
 */

public class HeaderFieldType {
	protected String name;
	protected String type;
	protected String extractionName;
	protected String unit = "none";
	public final static String INT = "int";
	public final static String FLOAT = "float";
	public final static String STRING = "string";
	

	public HeaderFieldType(String name, String type, String extractionName) {
		super();
		this.name = name;
		this.type = type;
		this.extractionName = extractionName;
	}
	
	public HeaderFieldType(String name, String type) {
		this(name,type,name);
	}

	public HeaderFieldType() {}

	public String getName() {
		return name;
	}

	public String getType() {
		return type;
	}

	public String getExtractionName() {
		if (extractionName == null) {
			extractionName = name;
		}
		return extractionName;
	}

	public String getUnit() {
		return unit;
	}

	public Element toXml() {
		Element e = new Element("field");
		e.setAttribute("name", name);
		e.setAttribute("type", type);
		e.setAttribute("extractionName", extractionName);
		e.setAttribute("unit", unit);
		return e;
	}
	
	public static HeaderFieldType fromXml(Element e) {
		 String name = e.getAttributeValue("name");
		 String type = e.getAttributeValue("type");
		 HeaderFieldType hft = new HeaderFieldType(name, type);
		 hft.extractionName = e.getAttributeValue("extractionName");
		 hft.unit = e.getAttributeValue("unit");
		 return hft;
	}
}
