package clinical.web.vo;

import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.web.workflow.common.JSONUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class JobResultGroupInfo {
	private String name;
	private String description;
	private Integer id;
	private List<JobResultTypeInfo> resultTypes = new ArrayList<JobResultTypeInfo>(
			5);

	public JobResultGroupInfo(String name, String description, Integer id) {
		super();
		this.name = name;
		this.description = description;
		this.setId(id);
	}

	public void addResultType(JobResultTypeInfo jrti) {
		resultTypes.add(jrti);
	}

	public String getName() {
		return name;
	}

	public String getDescription() {
		return description;
	}

	public List<JobResultTypeInfo> getResultTypes() {
		return resultTypes;
	}

	public JSONObject toJSON(JSONObject js) throws JSONException {
		js.put("name", name);
		JSONUtils.addStringField(js, "descr", description, "");
		JSONArray jsArr = new JSONArray();
		js.put("resultTypes", jsArr);
		for (JobResultTypeInfo jrti : resultTypes) {
			jsArr.put(jrti.toJSON(new JSONObject()));
		}
		return js;
	}

	public static JobResultGroupInfo initializeFromJSON(JSONObject js)
			throws JSONException {
		String name = js.getString("name");
		String descr = js.getString("descr");
		Integer id = null;
		if (js.has("id")) {
			id = js.getInt("id");
		}
		// TODO also result types (not needed for short term)

		return new JobResultGroupInfo(name, descr, id);
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder(256);
		sb.append("JobResultTypeInfo::[");
		sb.append("name:").append(name);
		sb.append(",description:").append(description);
		for (JobResultTypeInfo jrti : resultTypes) {
			sb.append("\n\t").append(jrti);
		}
		sb.append(']');
		return super.toString();
	}

	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}
}
