package clinical.web.vo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import clinical.web.common.vo.AnalysisResultSummary;
import clinical.web.common.vo.VisitSegAnalysisResultValues;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: QuerySummary.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class QuerySummary implements Serializable {
	private static final long serialVersionUID = 1L;
	private String subjectID;
	private String expID;
	protected AssessmentResultSummary ars;
	protected AnalysisResultSummary ddrs;
	protected boolean hasArs = false;
	
	public QuerySummary(String subjectID, String expID) {
		super();
		this.subjectID = subjectID;
		this.expID = expID;
	}
	
	public String getSiteID() {
		if ( ars != null)
			return ars.getSiteID();
		if ( ddrs != null)
			return ddrs.getSiteID();
		return null;
	}

	public AssessmentResultSummary getArs() {
		return ars;
	}

	public void setArs(AssessmentResultSummary ars) {
		this.ars = ars;
	}

	public AnalysisResultSummary getDdrs() {
		return ddrs;
	}

	public void setDdrs(AnalysisResultSummary ddrs) {
		this.ddrs = ddrs;
	}

	public String getSubjectID() {
		return subjectID;
	}

	public String getExpID() {
		return expID;
	}

	public Map<String, String> getParamMap() {
		if (ars != null)
			return ars.getParamMap();
		else
			return ddrs.getParamMap();
	}

	public String getExpName() {
		if (ars != null) {
			return ars.getExpName();
		} else {
			return ddrs.getExpName();
		}		
	}
	
	public String getParamJSON() {
		if (ars != null)
			return ars.getParamJSON();
		else 
			return ddrs.getParamJSON();
	}

	public String getAllSiteIDs() {
		java.util.Set<String> uniqSiteIDs = new HashSet<String>(17);
		if (ars != null)
			uniqSiteIDs = ars.getUniqSiteIDs();
		if (ddrs != null)
			uniqSiteIDs.addAll(ddrs.getUniqSiteIDs());
		StringBuilder buf = new StringBuilder();
		for (Iterator<String> it = uniqSiteIDs.iterator(); it.hasNext();) {
			String sid = it.next();
			buf.append(sid);
			if (it.hasNext())
				buf.append(',');
		}

		return buf.toString();
	}

	public List<VSRWrapper> getVSRWrapperList() {
		List<VSRWrapper> list = null;
		Map<String, VSRWrapper> map = null;
		if (ars != null) {
			list = new ArrayList<VSRWrapper>(ars.getVsarvList().size());
			for (VisitSegAsResultValues vsarv : ars.getVsarvList()) {
				list.add(new VSRWrapper(vsarv));
			}
			if (ddrs != null) {
				map = new HashMap<String, VSRWrapper>();
				for (VSRWrapper vsr : list) {
					VisitSegAsResultValues vsarv = vsr.caVS;
					String key = vsarv.getSiteID() + ":" + vsarv.getVisitID()
							+ ":" + vsarv.getSegmentID();
					map.put(key, vsr);
				}
			}
		} else if (ddrs != null) {
			list = new ArrayList<VSRWrapper>(ddrs.getVsarvList().size());
			for (VisitSegAnalysisResultValues ddVS : ddrs.getVsarvList()) {
				list.add(new VSRWrapper(null, ddVS));
			}
		}
		if (map != null) {
			for (VisitSegAnalysisResultValues ddVS : ddrs.getVsarvList()) {
				String key = ddVS.getSiteID() + ":" + ddVS.getVisitID() + ":"
						+ ddVS.getSegmentID();

				VSRWrapper vsr = map.get(key);
				if (vsr != null) {
					vsr.ddVS = ddVS;
				}
			}
		}

		return list;
	}

	public static class VSRWrapper {
		VisitSegAsResultValues caVS;
		VisitSegAnalysisResultValues ddVS;

		public VSRWrapper(VisitSegAsResultValues caVS) {
			this.caVS = caVS;
		}

		public VSRWrapper(VisitSegAsResultValues caVS,
				VisitSegAnalysisResultValues ddVS) {
			this.caVS = caVS;
			this.ddVS = ddVS;
		}

		public VisitSegAsResultValues getCaVS() {
			return caVS;
		}

		public VisitSegAnalysisResultValues getDdVS() {
			return ddVS;
		}
	}
}
